/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.application.DrawingLoadServer;
import CH.ifa.draw.application.DrawingMenuListener;
import CH.ifa.draw.application.DrawingViewFrame;
import CH.ifa.draw.application.ToggleStickyCommand;
import CH.ifa.draw.contrib.DiamondFigure;
import CH.ifa.draw.contrib.PolygonTool;
import CH.ifa.draw.contrib.TriangleFigure;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.ElbowConnection;
import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.ImageFigureCreationTool;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.figures.ScribbleTool;
import CH.ifa.draw.figures.SelectCommand;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.figures.TextTool;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.AlignCommand;
import CH.ifa.draw.standard.BringToFrontCommand;
import CH.ifa.draw.standard.BufferedUpdateStrategy;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.CopyCommand;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.CutCommand;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.DuplicateCommand;
import CH.ifa.draw.standard.NullDrawingView;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.SelectionTool;
import CH.ifa.draw.standard.SendToBackCommand;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.standard.SnapToGridCommand;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToggleGridCommand;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.MessageDialog;
import CH.ifa.draw.util.PaletteButton;
import CH.ifa.draw.util.PaletteLayout;
import CH.ifa.draw.util.PaletteListener;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.util.StringUtil;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.io.MalformedInputException;

public class DrawApplication
implements DrawingEditor,
PaletteListener {
    private static int windowCount;
    protected Frame menuFrame;
    protected Frame toolFrame;
    private final String defaultDrawExtension = "draw";
    public String drawExtension;
    private Font fMenuFont;
    private boolean floating;
    private Vector fDrawings = new Vector();
    private Tool fTool;
    private Iconkit fIconkit;
    private Menu fDrawingsMenu;
    private TextField fStatusLine;
    private Vector fViewFrames = new Vector();
    private DrawingViewFrame fViewFrame;
    private boolean fToolButtonSticky = false;
    private ToolButton fDefaultToolButton;
    private ToolButton fSelectedToolButton;
    private ToolButton fConnTextTB;
    private ToolButton fTextTB;
    private static final String fgDrawPath = "/CH/ifa/draw/";
    public static final String IMAGES = "/CH/ifa/draw/images/";
    public static final int FILE_MENU = 0;
    public static final int EDIT_MENU = 1;
    public static final int ALIGNMENT_MENU = 2;
    public static final int ATTRIBUTES_MENU = 3;
    public static final int DRAWINGS_MENU = 5;
    private String fLastPath = System.getProperty("user.dir");
    private Hashtable dirByExt = new Hashtable();
    private String fallbackDir;
    private static final int FILEVERSION = 5;
    private Point newWindowLoc;
    private Dimension newWindowDim;

    public DrawApplication() {
        this("JHotDraw");
    }

    public DrawApplication(String string) {
        this(string, null, new String[0], null);
    }

    public DrawApplication(String string, String[] stringArray) {
        this(string, null, stringArray, null);
    }

    protected Component wrapStatusLine(Component component) {
        return component;
    }

    public DrawApplication(String string, String string2, String[] stringArray, String string3) {
        DrawingLoadServer drawingLoadServer = null;
        String string4 = System.getProperty("de.renew.loadServerPort");
        if (string4 != null) {
            try {
                int n = Integer.valueOf(string4);
                try {
                    drawingLoadServer = new DrawingLoadServer(this, n);
                }
                catch (IOException iOException) {
                    System.out.println("Server Socket is occupied!");
                    System.exit(-1);
                }
            }
            catch (Exception exception) {
                System.out.println("No Drawing Load Server: " + exception);
            }
        }
        this.menuFrame = new Frame(string);
        this.fStatusLine = this.createStatusLine();
        this.menuFrame.add("South", this.wrapStatusLine(this.fStatusLine));
        this.toolFrame = this.menuFrame;
        this.floating = this.toolFrame == this.menuFrame;
        this.fIconkit = new Iconkit(this.toolFrame);
        if (string3 != null) {
            Image image = this.fIconkit.loadImageResource(string3);
            if (image == null) {
                System.err.println("Resource icon " + string3 + " could not be loaded!");
            } else {
                this.menuFrame.setIconImage(image);
            }
        }
        Panel panel = this.createToolPalette();
        this.createTools(panel);
        this.toolFrame.add("Center", panel);
        MenuBar menuBar = new MenuBar();
        String string5 = System.getProperty("de.renew.menuFontSize");
        this.fMenuFont = menuBar.getFont();
        if (string5 != null) {
            try {
                int n = Integer.parseInt(string5);
                System.out.println("Setting menu font size to " + n + " pt.");
                this.fMenuFont = new Font("SansSerif", 0, n);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Failed to set menu font size to \"" + string5 + "\": wrong number format.");
            }
        }
        this.createMenus(menuBar);
        this.menuFrame.setMenuBar(menuBar);
        this.menuFrame.pack();
        String string6 = System.getProperty("de.renew.windowResizable");
        this.menuFrame.setResizable(Boolean.valueOf(string6));
        this.menuFrame.show();
        this.menuFrame.pack();
        if (this.toolFrame != this.menuFrame) {
            this.toolFrame.pack();
            this.toolFrame.show();
        }
        ++windowCount;
        this.addListeners();
        this.drawExtension = string2 == null ? "draw" : string2;
        int n = 0;
        while (n < stringArray.length) {
            this.loadAndOpenDrawing(stringArray[n]);
            ++n;
        }
        if (this.fDrawings.size() == 0) {
            this.promptNew();
        }
        this.toolDone();
        if (drawingLoadServer != null) {
            drawingLoadServer.start();
        }
    }

    protected void addListeners() {
        this.menuFrame.addWindowListener(new 1());
        if (this.toolFrame != this.menuFrame) {
            this.toolFrame.addWindowListener(new 2());
        }
    }

    public Frame menuFrame() {
        return this.menuFrame;
    }

    protected DrawApplication newWindow() {
        return new DrawApplication(this.menuFrame.getTitle());
    }

    private void updateName(Drawing drawing, String string) {
        this.showDrawingViewFrame(drawing);
        string = StringUtil.makeCanonical(string);
        this.fLastPath = StringUtil.getPath(string);
        String string2 = StringUtil.getFilename(string);
        this.fViewFrame.setTitle(string2);
        drawing.setName(string2);
        drawing.setFilename(string);
        int n = this.fDrawings.indexOf(drawing);
        this.fDrawingsMenu.getItem(n).setLabel(string2);
    }

    protected void createMenus(MenuBar menuBar) {
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createAlignmentMenu());
        menuBar.add(this.createAttributesMenu());
        menuBar.add(this.createDebugMenu());
        menuBar.add(this.createDrawingsMenu());
    }

    void addDrawing(Drawing drawing) {
        if (!this.fDrawings.contains(drawing)) {
            this.fDrawings.addElement(drawing);
            CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(drawing.getName());
            checkboxMenuItem.setFont(this.fMenuFont);
            checkboxMenuItem.addItemListener(new DrawingMenuListener(this, drawing));
            this.fDrawingsMenu.add(checkboxMenuItem);
            this.drawingAdded(drawing);
        }
    }

    protected boolean closeViewFrame(DrawingViewFrame drawingViewFrame) {
        int n;
        Drawing drawing = drawingViewFrame.view().drawing();
        if (drawing.isModified() && ((n = MessageDialog.invokeDialog(this.menuFrame, "Renew: Confirm Close", new String[]{"The drawing \"" + drawing.getName() + "\"", "you are about to close", "has been modified."}, 0, new String[]{" Save now ", " Close ", " Cancel "})) == 0 ? !this.saveDrawing(drawing) : n == 2)) {
            return false;
        }
        ((Component)drawingViewFrame).setVisible(false);
        drawingViewFrame.dispose();
        this.fViewFrames.removeElement(drawingViewFrame);
        if (drawingViewFrame == this.fViewFrame) {
            n = this.fViewFrames.size();
            if (n > 0) {
                this.setCurrentDrawing((DrawingViewFrame)this.fViewFrames.elementAt(n - 1));
                this.fViewFrame.show();
                this.fViewFrame.requestFocus();
            } else {
                this.setCurrentDrawing(null);
            }
        }
        n = this.fDrawings.indexOf(drawing);
        this.fDrawingsMenu.remove(n);
        this.fDrawings.removeElementAt(n);
        drawing.release();
        this.drawingReleased(drawing);
        drawingViewFrame.discard();
        return true;
    }

    protected void drawingAdded(Drawing drawing) {
    }

    protected void drawingReleased(Drawing drawing) {
    }

    protected Menu createMenu(String string) {
        Menu menu = new Menu(string);
        menu.setFont(this.fMenuFont);
        return menu;
    }

    protected MenuItem createMenuItem(String string, MenuShortcut menuShortcut, ActionListener actionListener) {
        MenuItem menuItem = menuShortcut == null ? new MenuItem(string) : new MenuItem(string, menuShortcut);
        menuItem.setFont(this.fMenuFont);
        menuItem.addActionListener(actionListener);
        return menuItem;
    }

    protected MenuItem createMenuItem(String string, ActionListener actionListener) {
        return this.createMenuItem(string, null, actionListener);
    }

    public CommandMenu createCommandMenu(String string) {
        CommandMenu commandMenu = new CommandMenu(string);
        commandMenu.setFont(this.fMenuFont);
        return commandMenu;
    }

    protected Menu createDrawingsMenu() {
        this.fDrawingsMenu = this.createMenu("Drawings");
        return this.fDrawingsMenu;
    }

    protected Enumeration drawings() {
        return this.fDrawings.elements();
    }

    protected DrawingViewFrame newDrawingViewFrame(Drawing drawing) {
        Dimension dimension = this.getDrawingViewSize();
        StandardDrawingView standardDrawingView = this.createDrawingView(dimension.width, dimension.height);
        this.addDrawing(drawing);
        DrawingViewFrame drawingViewFrame = new DrawingViewFrame(this, standardDrawingView, drawing);
        this.fViewFrames.addElement(drawingViewFrame);
        this.setCurrentDrawing(drawingViewFrame);
        return drawingViewFrame;
    }

    protected Menu createFileMenu() {
        Menu menu = this.createMenu("File");
        menu.add(this.createMenuItem("New Drawing", new MenuShortcut(78), new 3()));
        menu.add(this.createMenuItem("Open Drawing...", new MenuShortcut(79), new 4()));
        menu.add(this.createMenuItem("Save Drawing", new MenuShortcut(83), new 5()));
        menu.add(this.createMenuItem("Save Drawing As...", new 6()));
        menu.add(this.createMenuItem("Save All Drawings", new 7()));
        menu.add(this.createMenuItem("Close Drawing", new 8()));
        menu.addSeparator();
        menu.add(this.createMenuItem("Print...", new MenuShortcut(80), new 9()));
        menu.addSeparator();
        menu.add(this.createMenuItem("Exit", new 10()));
        return menu;
    }

    protected Menu createEditMenu() {
        CommandMenu commandMenu = this.createCommandMenu("Edit");
        commandMenu.add(new CutCommand("Cut", this), new MenuShortcut(88));
        commandMenu.add(new CopyCommand("Copy", this), new MenuShortcut(67));
        commandMenu.add(new PasteCommand("Paste", this), new MenuShortcut(86));
        commandMenu.addSeparator();
        commandMenu.add(new DuplicateCommand("Duplicate", this), new MenuShortcut(68));
        commandMenu.add(new DeleteCommand("Delete", this));
        commandMenu.addSeparator();
        commandMenu.add(new GroupCommand("Group", this));
        commandMenu.add(new UngroupCommand("Ungroup", this));
        commandMenu.addSeparator();
        commandMenu.add(new SelectCommand("Select All", this), new MenuShortcut(65));
        commandMenu.addSeparator();
        commandMenu.add(new ToggleStickyCommand("Toggle Sticky Tools", this));
        return commandMenu;
    }

    protected Menu createAlignmentMenu() {
        CommandMenu commandMenu = this.createCommandMenu("Layout");
        commandMenu.add(new ToggleGridCommand("Toggle Snap to Grid", this, new Point(5, 5)));
        commandMenu.add(new SnapToGridCommand("Snap to Grid now", this, new Point(5, 5)));
        commandMenu.addSeparator();
        commandMenu.add(new AlignCommand("Lefts", this, 0));
        commandMenu.add(new AlignCommand("Centers", this, 1));
        commandMenu.add(new AlignCommand("Rights", this, 2));
        commandMenu.addSeparator();
        commandMenu.add(new AlignCommand("Tops", this, 3));
        commandMenu.add(new AlignCommand("Middles", this, 4));
        commandMenu.add(new AlignCommand("Bottoms", this, 5));
        commandMenu.addSeparator();
        commandMenu.add(new SendToBackCommand("Send to Back", this));
        commandMenu.add(new BringToFrontCommand("Bring to Front", this));
        return commandMenu;
    }

    protected Menu createDebugMenu() {
        Menu menu = this.createMenu("Debug");
        menu.add(this.createMenuItem("Simple Update", new 11()));
        menu.add(this.createMenuItem("Buffered Update", new 12()));
        return menu;
    }

    protected Menu createAttributesMenu() {
        Menu menu = this.createMenu("Attributes");
        menu.add(this.createColorMenu("Fill Color", "FillColor"));
        menu.add(this.createColorMenu("Pen Color", "FrameColor"));
        menu.add(this.createVisibilityMenu());
        menu.add(this.createArrowMenu());
        menu.addSeparator();
        menu.add(this.createFontMenu());
        menu.add(this.createFontSizeMenu());
        menu.add(this.createFontStyleMenu());
        menu.add(this.createColorMenu("Text Color", "TextColor"));
        return menu;
    }

    protected Menu createColorMenu(String string, String string2) {
        CommandMenu commandMenu = this.createCommandMenu(string);
        int n = 0;
        while (n < ColorMap.size()) {
            commandMenu.add(new ChangeAttributeCommand(ColorMap.name(n), string2, ColorMap.color(n), this));
            ++n;
        }
        return commandMenu;
    }

    protected Menu createVisibilityMenu() {
        CommandMenu commandMenu = this.createCommandMenu("Visibility");
        commandMenu.add(new ChangeAttributeCommand("visible", "Visibility", Boolean.TRUE, this));
        commandMenu.add(new ChangeAttributeCommand("invisible", "Visibility", Boolean.FALSE, this));
        return commandMenu;
    }

    protected Menu createArrowMenu() {
        CommandMenu commandMenu = this.createCommandMenu("Arrow");
        commandMenu.add(new ChangeAttributeCommand("none", "ArrowMode", new Integer(0), this));
        commandMenu.add(new ChangeAttributeCommand("at Start", "ArrowMode", new Integer(1), this));
        commandMenu.add(new ChangeAttributeCommand("at End", "ArrowMode", new Integer(2), this));
        commandMenu.add(new ChangeAttributeCommand("at Both", "ArrowMode", new Integer(3), this));
        return commandMenu;
    }

    protected Menu createFontMenu() {
        CommandMenu commandMenu = this.createCommandMenu("Font");
        String[] stringArray = Toolkit.getDefaultToolkit().getFontList();
        int n = 0;
        while (n < stringArray.length) {
            commandMenu.add(new ChangeAttributeCommand(stringArray[n], "FontName", stringArray[n], this));
            ++n;
        }
        return commandMenu;
    }

    protected Menu createFontStyleMenu() {
        CommandMenu commandMenu = this.createCommandMenu("Font Style");
        commandMenu.add(new ChangeAttributeCommand("Plain", "FontStyle", new Integer(0), this));
        commandMenu.add(new ChangeAttributeCommand("Italic", "FontStyle", new Integer(2), this));
        commandMenu.add(new ChangeAttributeCommand("Bold", "FontStyle", new Integer(1), this));
        commandMenu.add(new ChangeAttributeCommand("Underlined", "FontStyle", new Integer(TextFigure.Font_UNDERLINED), this));
        return commandMenu;
    }

    protected Menu createFontSizeMenu() {
        CommandMenu commandMenu = this.createCommandMenu("Font Size");
        int[] nArray = new int[]{9, 10, 12, 14, 18, 24, 36, 48, 72};
        int n = 0;
        while (n < nArray.length) {
            commandMenu.add(new ChangeAttributeCommand(Integer.toString(nArray[n]), "FontSize", new Integer(nArray[n]), this));
            ++n;
        }
        return commandMenu;
    }

    protected Panel createToolPalette() {
        Panel panel = new Panel();
        panel.setBackground(Color.lightGray);
        panel.setLayout(new PaletteLayout(2, new Point(2, 2), false));
        return panel;
    }

    protected void createTools(Panel panel) {
        Tool tool = this.createSelectionTool();
        this.fDefaultToolButton = this.createToolButton("/CH/ifa/draw/images/SEL", "Selection Tool", tool);
        panel.add(this.fDefaultToolButton);
        this.createAdditionalTools(panel);
        tool = new CreationTool(this, new RectangleFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/RECT", "Rectangle Tool", tool));
        tool = new CreationTool(this, new RoundRectangleFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/RRECT", "Round Rectangle Tool", tool));
        tool = new CreationTool(this, new EllipseFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/ELLIPSE", "Ellipse Tool", tool));
        tool = new CreationTool(this, new DiamondFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/DIAMOND", "Diamond Tool", tool));
        tool = new CreationTool(this, new TriangleFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/TRIANGLE", "Triangle Tool", tool));
        tool = new CreationTool(this, new LineFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/LINE", "Line Tool", tool));
        tool = new ConnectionTool(this, new LineConnection());
        panel.add(this.createToolButton("/CH/ifa/draw/images/CONN", "Connection Tool", tool));
        tool = new ConnectionTool(this, new ElbowConnection());
        panel.add(this.createToolButton("/CH/ifa/draw/images/OCONN", "Elbow Connection Tool", tool));
        tool = new ScribbleTool(this);
        panel.add(this.createToolButton("/CH/ifa/draw/images/SCRIBBL", "Scribble Tool", tool));
        tool = new PolygonTool(this);
        panel.add(this.createToolButton("/CH/ifa/draw/images/POLYGON", "Polygon Tool", tool));
        tool = new ImageFigureCreationTool(this);
        panel.add(this.createToolButton("/CH/ifa/draw/images/IMAGE", "Image Tool", tool));
        tool = new TextTool((DrawingEditor)this, new TextFigure(false));
        this.fTextTB = this.createToolButton("/CH/ifa/draw/images/TEXT", "Text Tool", tool);
        panel.add(this.fTextTB);
        tool = new ConnectedTextTool((DrawingEditor)this, new TextFigure());
        this.fConnTextTB = this.createToolButton("/CH/ifa/draw/images/ATEXT", "Connected Text Tool", tool);
        panel.add(this.fConnTextTB);
    }

    protected void createAdditionalTools(Panel panel) {
    }

    protected Tool createSelectionTool() {
        return new SelectionTool(this);
    }

    public ToolButton createToolButton(String string, String string2, Tool tool) {
        return new ToolButton(this, string, string2, tool);
    }

    protected StandardDrawingView createDrawingView(int n, int n2) {
        return new StandardDrawingView(this, n, n2);
    }

    void unsetCurrentDrawing() {
        if (this.fViewFrame != null) {
            int n = this.fDrawings.indexOf(this.drawing());
            if (n >= 0) {
                ((CheckboxMenuItem)this.fDrawingsMenu.getItem(n)).setState(false);
            }
            this.fViewFrame = null;
        }
    }

    void setCurrentDrawing(DrawingViewFrame drawingViewFrame) {
        if (drawingViewFrame == null) {
            this.unsetCurrentDrawing();
            return;
        }
        Drawing drawing = drawingViewFrame.view().drawing();
        int n = this.fDrawings.indexOf(drawing);
        if (n >= 0 && this.fViewFrames.removeElement(drawingViewFrame)) {
            this.fViewFrames.addElement(drawingViewFrame);
            this.unsetCurrentDrawing();
            this.fViewFrame = drawingViewFrame;
            ((CheckboxMenuItem)this.fDrawingsMenu.getItem(n)).setState(true);
        }
    }

    protected DrawingViewFrame getViewFrame(Drawing drawing) {
        Enumeration enumeration = this.fViewFrames.elements();
        while (enumeration.hasMoreElements()) {
            DrawingViewFrame drawingViewFrame = (DrawingViewFrame)enumeration.nextElement();
            if (drawingViewFrame.view().drawing() != drawing) continue;
            return drawingViewFrame;
        }
        return null;
    }

    public DrawingViewFrame showDrawingViewFrame(Drawing drawing) {
        DrawingViewFrame drawingViewFrame = this.getViewFrame(drawing);
        if (drawingViewFrame != null) {
            this.setCurrentDrawing(drawingViewFrame);
            drawingViewFrame.show();
            drawingViewFrame.requestFocus();
        } else {
            drawingViewFrame = this.newDrawingViewFrame(drawing);
        }
        return drawingViewFrame;
    }

    public boolean closeDrawing(Drawing drawing) {
        DrawingViewFrame drawingViewFrame = this.getViewFrame(drawing);
        if (drawingViewFrame != null) {
            return this.closeViewFrame(drawingViewFrame);
        }
        return false;
    }

    protected Dimension getDrawingViewSize() {
        return new Dimension(400, 600);
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    protected TextField createStatusLine() {
        TextField textField = new TextField("No Tool", 40);
        textField.setEditable(false);
        return textField;
    }

    public void paletteUserSelected(PaletteButton paletteButton) {
        ToolButton toolButton = (ToolButton)paletteButton;
        this.setSelected(toolButton);
        this.setTool(toolButton.tool(), toolButton.name());
    }

    public void paletteUserOver(PaletteButton paletteButton, boolean bl) {
        ToolButton toolButton = (ToolButton)paletteButton;
        if (bl) {
            this.showStatus(toolButton.name());
            return;
        }
        if (this.fSelectedToolButton != null) {
            this.showStatus(this.fSelectedToolButton.name());
        }
    }

    public Drawing drawing() {
        return this.view().drawing();
    }

    public Tool tool() {
        return this.fTool;
    }

    public DrawingView view() {
        DrawingViewFrame drawingViewFrame = this.fViewFrame;
        if (drawingViewFrame == null) {
            return NullDrawingView.INSTANCE;
        }
        return drawingViewFrame.view();
    }

    public DrawingView previousView() {
        int n = this.fViewFrames.size();
        if (n >= 2) {
            return ((DrawingViewFrame)this.fViewFrames.elementAt(n - 2)).view();
        }
        return null;
    }

    public void toggleToolButtonSticky() {
        this.fToolButtonSticky = !this.fToolButtonSticky;
    }

    public void toolDone() {
        if (windowCount > 0) {
            if (this.fToolButtonSticky && this.tool() != null) {
                this.tool().deactivate();
                this.tool().activate();
                return;
            }
            if (this.fDefaultToolButton != null) {
                this.setTool(this.fDefaultToolButton.tool(), this.fDefaultToolButton.name());
                this.setSelected(this.fDefaultToolButton);
            }
        }
    }

    public void selectionChanged(DrawingView drawingView) {
        MenuBar menuBar = this.menuFrame.getMenuBar();
        CommandMenu commandMenu = (CommandMenu)menuBar.getMenu(1);
        commandMenu.checkEnabled();
        CommandMenu commandMenu2 = (CommandMenu)menuBar.getMenu(2);
        commandMenu2.checkEnabled();
    }

    public void showStatus(String string) {
        ((TextComponent)this.fStatusLine).setText(string);
    }

    private void setTool(Tool tool, String string) {
        if (this.fTool != null) {
            this.fTool.deactivate();
        }
        this.fTool = tool;
        if (this.fTool != null) {
            ((TextComponent)this.fStatusLine).setText(string);
            this.fTool.activate();
        }
    }

    private void setSelected(ToolButton toolButton) {
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.reset();
        }
        this.fSelectedToolButton = toolButton;
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.select();
        }
    }

    public ToolButton toolButtonForTextFigure(TextFigure textFigure) {
        if (textFigure.parent() == null) {
            return this.fTextTB;
        }
        return this.fConnTextTB;
    }

    public void doTextEdit(TextFigure textFigure, int n, int n2) {
        ToolButton toolButton = this.toolButtonForTextFigure(textFigure);
        this.paletteUserSelected(toolButton);
        TextTool textTool = (TextTool)toolButton.tool();
        textTool.beginEdit(textFigure);
        if (n > 0 && n2 > 0) {
            textTool.setCaretPosition(n, n2);
        }
    }

    public void doTextEdit(TextFigure textFigure) {
        this.doTextEdit(textFigure, 0, 0);
    }

    public void exit() {
        Enumeration enumeration;
        while ((enumeration = this.fViewFrames.elements()).hasMoreElements()) {
            DrawingViewFrame drawingViewFrame = (DrawingViewFrame)enumeration.nextElement();
            if (this.closeViewFrame(drawingViewFrame)) continue;
            return;
        }
        this.destroy();
        ((Component)this.toolFrame).setVisible(false);
        this.toolFrame.dispose();
        ((Component)this.menuFrame).setVisible(false);
        this.menuFrame.dispose();
        if (--windowCount <= 0) {
            System.exit(0);
        }
    }

    protected void destroy() {
    }

    public void promptNew() {
        Drawing drawing = this.createDrawing();
        this.newDrawingViewFrame(drawing);
    }

    public void promptOpen() {
        String string = this.getLoadPath("Open File...", null, new String[]{this.drawExtension, "ser"});
        if (string != null) {
            this.loadAndOpenDrawing(string);
        }
    }

    public boolean saveDrawing(Drawing drawing) {
        String string = drawing.getFilename();
        if (string == null) {
            if (!this.promptSaveAs(drawing)) {
                return false;
            }
            string = drawing.getFilename();
        }
        this.saveDrawing(drawing, string);
        return true;
    }

    public void saveDrawing(Drawing drawing, String string) {
        String string2 = "Saving drawing " + drawing.getName() + " as " + string + "...";
        System.out.println(string2);
        this.showStatus(string2);
        if (this.drawExtension.equals(StringUtil.getExtension(string))) {
            this.saveAsStorableOutput(drawing, string);
            return;
        }
        this.saveAsObjectOutput(drawing, string);
    }

    boolean promptSaveAs(Drawing drawing) {
        String string = drawing.getFilename();
        if (string == null) {
            string = String.valueOf(this.fLastPath) + File.separator + drawing.getName() + "." + this.drawExtension;
        }
        this.toolDone();
        string = this.getSavePath("Save File...", string, new String[]{this.drawExtension});
        if (string == null) {
            return false;
        }
        this.updateName(drawing, string);
        return true;
    }

    public void print() {
        this.fTool.deactivate();
        PrintJob printJob = this.menuFrame.getToolkit().getPrintJob(this.fViewFrame, "Print Drawing", null);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            if (graphics != null) {
                this.view().paint(graphics);
                graphics.dispose();
            }
            printJob.end();
        }
        this.fTool.activate();
    }

    protected String getSavePath(String string, String string2, String[] stringArray) {
        return this.getLoadOrSavePath(string, string2, stringArray, 1);
    }

    protected String getLoadPath(String string, String string2, String[] stringArray) {
        return this.getLoadOrSavePath(string, string2, stringArray, 0);
    }

    protected String getLoadOrSavePath(String string, String string2, String[] stringArray, int n) {
        String string3 = null;
        String string4 = null;
        FileDialog fileDialog = new FileDialog(this.menuFrame, string, n);
        if (string2 != null) {
            string4 = StringUtil.getPath(string2 = this.checkAndAddExtension(string2, stringArray));
            if ("".equals(string4)) {
                string4 = this.getDirForExt(StringUtil.getExtension(string2));
            } else {
                string2 = StringUtil.getExtendedFilename(string2);
            }
        } else if (stringArray != null && stringArray.length > 0) {
            string4 = this.getDirForExt(stringArray[0]);
        }
        if (string4 != null) {
            fileDialog.setDirectory(string4);
        }
        if (string2 != null) {
            fileDialog.setFile(string2);
        }
        fileDialog.show();
        String string5 = fileDialog.getFile();
        if (string5 != null) {
            string5 = this.stripTrailingAsterisks(string5);
            String string6 = fileDialog.getDirectory();
            if (!string6.endsWith(File.separator)) {
                string6 = String.valueOf(string6) + File.separator;
            }
            string3 = String.valueOf(string6) + string5;
            string3 = this.checkAndAddExtension(string3, stringArray);
            string3 = StringUtil.makeCanonical(string3);
            this.updateDirByExt(string3);
        }
        fileDialog.dispose();
        return string3;
    }

    protected String checkAndAddExtension(String string, String[] stringArray) {
        if (stringArray != null) {
            boolean bl = false;
            String string2 = StringUtil.getExtension(string);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string2)) {
                    bl = true;
                }
                ++n;
            }
            String string3 = string;
            if (stringArray.length > 0 && !bl) {
                string3 = String.valueOf(string3) + "." + stringArray[0];
            }
            return string3;
        }
        return string;
    }

    protected String stripTrailingAsterisks(String string) {
        if (string.endsWith("*.*")) {
            return string.substring(0, string.length() - 4);
        }
        return string;
    }

    protected void updateDirByExt(String string) {
        this.updateDirByExt(StringUtil.getExtension(string), StringUtil.getPath(string));
    }

    protected void updateDirByExt(String string, String string2) {
        this.dirByExt.put(string, string2);
        this.fallbackDir = string2;
    }

    protected String getDirForExt(String string) {
        String string2 = (String)this.dirByExt.get(string);
        if (string2 == null) {
            string2 = this.fallbackDir;
        }
        return string2;
    }

    private void saveAsStorableOutput(Drawing drawing, String string) {
        try {
            StorableOutput storableOutput = new StorableOutput(string);
            storableOutput.writeInt(5);
            storableOutput.writeStorable(drawing);
            DrawingViewFrame drawingViewFrame = this.getViewFrame(drawing);
            Point point = drawingViewFrame.getLocation();
            Dimension dimension = drawingViewFrame.getSize();
            storableOutput.writeInt(point.x);
            storableOutput.writeInt(point.y);
            storableOutput.writeInt(dimension.width);
            storableOutput.writeInt(dimension.height);
            storableOutput.close();
            return;
        }
        catch (IOException iOException) {
            this.showStatus(iOException.toString());
            return;
        }
    }

    private void saveAsObjectOutput(Drawing drawing, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(drawing);
            objectOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            this.showStatus(iOException.toString());
            return;
        }
    }

    public synchronized void loadAndOpenDrawing(String string) {
        this.newWindowLoc = null;
        this.newWindowDim = null;
        Drawing drawing = this.loadDrawing(string);
        if (drawing != null) {
            DrawingViewFrame drawingViewFrame = this.newDrawingViewFrame(drawing);
            if (this.newWindowLoc != null && this.newWindowDim != null) {
                ((Component)drawingViewFrame).setLocation(this.newWindowLoc);
                ((Component)drawingViewFrame).setSize(this.newWindowDim);
                drawingViewFrame.validate();
            }
        }
    }

    private void showAndPrint(String string) {
        this.showStatus(string);
        System.out.println(string);
    }

    private Drawing loadDrawing(String string) {
        string = StringUtil.makeCanonical(string);
        this.showAndPrint("Loading drawing from " + string + "...");
        Drawing drawing = null;
        String string2 = this.guessType(string);
        if (string2.equals("storable")) {
            drawing = this.readFromStorableInput(string);
        } else if (string2.equals("serialized")) {
            drawing = this.readFromObjectInput(string);
        } else {
            this.showAndPrint("Unknown file type of file \"" + string + "\".");
        }
        if (drawing != null) {
            drawing.setName(StringUtil.getFilename(string));
            drawing.setFilename(string);
            this.fLastPath = StringUtil.getPath(string);
            if (drawing instanceof Figure) {
                ((Figure)((Object)drawing)).invalidate();
            }
            this.updateDirByExt(string);
        }
        return drawing;
    }

    protected StorableInput makeStorableInput(String string, boolean bl) throws FileNotFoundException {
        return new StorableInput(string, bl);
    }

    private Drawing readFromStorableInput(String string) {
        Drawing drawing = null;
        try {
            StorableInput storableInput = this.makeStorableInput(string, true);
            try {
                drawing = this.readStorableDrawing(storableInput);
            }
            catch (MalformedInputException malformedInputException) {
                storableInput.close();
                storableInput = this.makeStorableInput(string, false);
                drawing = this.readStorableDrawing(storableInput);
            }
            try {
                this.newWindowLoc = new Point(storableInput.readInt(), storableInput.readInt());
                this.newWindowDim = new Dimension(storableInput.readInt(), storableInput.readInt());
            }
            catch (Exception exception) {}
        }
        catch (IOException iOException) {
            this.showStatus("Error: " + iOException);
            System.out.println("Error: " + iOException);
        }
        return drawing;
    }

    private Drawing readStorableDrawing(StorableInput storableInput) throws IOException {
        if (storableInput.canReadInt()) {
            storableInput.setVersion(storableInput.readInt());
        } else {
            storableInput.setVersion(0);
        }
        return (Drawing)storableInput.readStorable();
    }

    private Drawing readFromObjectInput(String string) {
        Drawing drawing = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            drawing = (Drawing)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            this.showStatus("Error: " + iOException);
            System.out.println("Error: " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.showStatus("Class not found: " + classNotFoundException);
            System.out.println("Error: " + classNotFoundException);
        }
        return drawing;
    }

    private String guessType(String string) {
        String string2 = StringUtil.getExtension(string);
        if (this.drawExtension.equals(string2)) {
            return "storable";
        }
        if ("ser".equals(string2)) {
            return "serialized";
        }
        return "unknown";
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        DrawingViewFrame drawingViewFrame = (DrawingViewFrame)windowEvent.getWindow();
        boolean bl = drawingViewFrame != null && drawingViewFrame != this.fViewFrame;
        this.setCurrentDrawing(drawingViewFrame);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        DrawingViewFrame drawingViewFrame = (DrawingViewFrame)windowEvent.getWindow();
        this.closeViewFrame(drawingViewFrame);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public static void main(String[] stringArray) {
        new DrawApplication("JHotDraw", stringArray);
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            DrawApplication.this.exit();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)DrawApplication.this.toolFrame).setVisible(false);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DrawApplication.this.promptNew();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DrawApplication.this.promptOpen();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DrawApplication.this.saveDrawing(DrawApplication.this.drawing());
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Drawing drawing = DrawApplication.this.drawing();
            if (DrawApplication.this.promptSaveAs(drawing)) {
                DrawApplication.this.saveDrawing(drawing);
            }
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Enumeration enumeration = DrawApplication.this.drawings();
            while (enumeration.hasMoreElements()) {
                Drawing drawing = (Drawing)enumeration.nextElement();
                if (drawing.getFilename() != null) continue;
                DrawApplication.this.showDrawingViewFrame(drawing);
                if (DrawApplication.this.promptSaveAs(drawing)) continue;
                return;
            }
            enumeration = DrawApplication.this.drawings();
            while (enumeration.hasMoreElements()) {
                DrawApplication.this.saveDrawing((Drawing)enumeration.nextElement());
            }
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (DrawApplication.this.fViewFrame != null) {
                DrawApplication.this.closeViewFrame(DrawApplication.this.fViewFrame);
            }
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DrawApplication.this.print();
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DrawApplication.this.exit();
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DrawApplication.this.view().setDisplayUpdate(new SimpleUpdateStrategy());
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DrawApplication.this.view().setDisplayUpdate(new BufferedUpdateStrategy());
        }

        /* synthetic */ 12() {
        }
    }
}

