/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.application.DrawApplication;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;

class DrawingLoadServer
extends Thread {
    private DrawApplication editor;
    private ServerSocket s;

    public DrawingLoadServer(DrawApplication drawApplication, int n) throws IOException {
        this.editor = drawApplication;
        System.out.println("Drawing Load Server setting up server socket at port " + n + "...");
        this.s = new ServerSocket(n);
    }

    public void run() {
        System.out.println("Drawing Load Server waiting for parameters...");
        while (true) {
            Socket socket = null;
            try {
                socket = this.s.accept();
                System.out.println("Parameter server accepted client.");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                try {
                    String string;
                    do {
                        if ((string = bufferedReader.readLine()) == null) continue;
                        System.out.println("Received Parameter " + string);
                        this.editor.loadAndOpenDrawing(string);
                    } while (string != null);
                }
                catch (IOException iOException) {}
                System.out.println("Connection closed.");
                bufferedReader.close();
                socket.close();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Drawing Load Server threw exception: " + exception);
                continue;
            }
            break;
        }
    }
}

