/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.NullDrawing;
import CH.ifa.draw.standard.NullDrawingView;
import CH.ifa.draw.standard.StandardDrawingView;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Toolkit;

public class DrawingViewFrame
extends Frame {
    private StandardDrawingView drawingView;
    private ScrollPane sp;
    private Dimension defSize;
    private boolean onDiscardReleaseDrawing = false;

    public DrawingViewFrame(DrawApplication drawApplication, StandardDrawingView standardDrawingView, Drawing drawing) {
        Object object;
        Image image = drawApplication.menuFrame().getIconImage();
        if (image != null && (object = Toolkit.getDefaultToolkit().createImage(image.getSource())) != null) {
            this.setIconImage((Image)object);
        }
        this.drawingView = standardDrawingView;
        this.addWindowListener(drawApplication);
        this.sp = new ScrollPane();
        object = this.sp.getVAdjustable();
        Adjustable adjustable = this.sp.getHAdjustable();
        adjustable.setUnitIncrement(16);
        object.setUnitIncrement(16);
        this.sp.add(standardDrawingView);
        this.add(this.sp);
        Point point = drawApplication.menuFrame.getLocationOnScreen();
        Dimension dimension = drawApplication.menuFrame.getSize();
        this.defSize = new Dimension(dimension.width, 600);
        ((Component)this).setBounds(point.x, point.y + dimension.height, this.defSize.width, this.defSize.height);
        this.doLayout();
        standardDrawingView.setDrawing(drawing);
        if (drawApplication.tool() == null) {
            drawApplication.toolDone();
        }
        this.setDrawing(drawing);
    }

    public DrawingView view() {
        DrawingView drawingView = this.drawingView;
        if (drawingView == null) {
            drawingView = NullDrawingView.INSTANCE;
        }
        return drawingView;
    }

    void setDrawing(Drawing drawing) {
        this.drawingView.setDrawing(drawing);
        this.setTitle(drawing.getName());
        if (!this.isShowing()) {
            this.show();
        }
        if (drawing.figures().hasMoreElements() && drawing instanceof Figure) {
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.sp.getViewportSize();
            Dimension dimension3 = new Dimension(dimension.width - dimension2.width, dimension.height - dimension2.height);
            Rectangle rectangle = ((Figure)((Object)drawing)).displayBox();
            int n = rectangle.x + rectangle.width + dimension3.width + 16;
            int n2 = rectangle.y + rectangle.height + dimension3.height + 16;
            Dimension dimension4 = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setSize(Math.min(n, dimension4.width), Math.min(n2, dimension4.height));
            this.validate();
            return;
        }
        ((Component)this).setSize(this.defSize.width, this.defSize.height);
        this.validate();
    }

    public void onDiscardRelease() {
        this.onDiscardReleaseDrawing = true;
    }

    void discard() {
        ((Component)this).setVisible(false);
        this.sp.remove(this.drawingView);
        this.remove(this.sp);
        if (this.onDiscardReleaseDrawing) {
            this.drawingView.drawing().release();
        }
        this.drawingView.setDrawing(NullDrawing.INSTANCE);
        this.drawingView = null;
        this.sp = null;
        this.defSize = null;
        this.dispose();
    }
}

