/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.ChopPolygonConnector;
import CH.ifa.draw.contrib.OutlineFigure;
import CH.ifa.draw.contrib.PolygonHandle;
import CH.ifa.draw.contrib.PolygonScaleHandle;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.AbstractLocator;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class PolygonFigure
extends AttributeFigure
implements OutlineFigure {
    static final int TOO_CLOSE = 2;
    private static final long serialVersionUID = 6254089689239215026L;
    private int polygonFigureSerializedDataVersion = 1;
    protected Polygon fPoly = new Polygon();

    public PolygonFigure() {
    }

    public PolygonFigure(int n, int n2) {
        this.fPoly.addPoint(n, n2);
    }

    public PolygonFigure(Polygon polygon) {
        this.fPoly = new Polygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public Rectangle displayBox() {
        return PolygonFigure.bounds(this.fPoly);
    }

    public boolean isEmpty() {
        return this.fPoly.npoints < 3 || this.size().width < 2 && this.size().height < 2;
    }

    public Vector handles() {
        Vector<AbstractHandle> vector = new Vector<AbstractHandle>(this.fPoly.npoints);
        int n = 0;
        while (n < this.fPoly.npoints) {
            vector.addElement(new PolygonHandle(this, PolygonFigure.locator(n), n));
            ++n;
        }
        vector.addElement(new PolygonScaleHandle(this));
        return vector;
    }

    public void basicDisplayBox(Point point, Point point2) {
        Rectangle rectangle = this.displayBox();
        int n = point.x - rectangle.x;
        int n2 = point.y - rectangle.y;
        this.fPoly.translate(n, n2);
        rectangle = this.displayBox();
        Point point3 = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        Polygon polygon = this.getPolygon();
        this.scaleRotate(point3, polygon, point2);
    }

    public Polygon getPolygon() {
        return new Polygon(this.fPoly.xpoints, this.fPoly.ypoints, this.fPoly.npoints);
    }

    public Polygon outline() {
        return this.getPolygon();
    }

    public Point center() {
        return PolygonFigure.center(this.fPoly);
    }

    public Enumeration points() {
        Vector<Point> vector = new Vector<Point>(this.fPoly.npoints);
        int n = 0;
        while (n < this.fPoly.npoints) {
            vector.addElement(new Point(this.fPoly.xpoints[n], this.fPoly.ypoints[n]));
            ++n;
        }
        return vector.elements();
    }

    public int pointCount() {
        return this.fPoly.npoints;
    }

    public void basicMoveBy(int n, int n2) {
        this.fPoly.translate(n, n2);
    }

    public void drawBackground(Graphics graphics) {
        graphics.fillPolygon(this.fPoly);
    }

    public void drawFrame(Graphics graphics) {
        graphics.drawPolygon(this.fPoly);
    }

    public boolean containsPoint(int n, int n2) {
        return this.fPoly.contains(n, n2);
    }

    public Connector connectorAt(int n, int n2) {
        return new ChopPolygonConnector(this);
    }

    public void addPoint(int n, int n2) {
        this.fPoly.addPoint(n, n2);
        this.changed();
    }

    public void setPointAt(Point point, int n) {
        this.willChange();
        this.fPoly.xpoints[n] = point.x;
        this.fPoly.ypoints[n] = point.y;
        this.changed();
    }

    public void insertPointAt(Point point, int n) {
        this.willChange();
        int n2 = this.fPoly.npoints + 1;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = this.fPoly.xpoints[n3];
            nArray2[n3] = this.fPoly.ypoints[n3];
            ++n3;
        }
        nArray[n] = point.x;
        nArray2[n] = point.y;
        int n4 = n;
        while (n4 < this.fPoly.npoints) {
            nArray[n4 + 1] = this.fPoly.xpoints[n4];
            nArray2[n4 + 1] = this.fPoly.ypoints[n4];
            ++n4;
        }
        this.fPoly = new Polygon(nArray, nArray2, n2);
        this.changed();
    }

    public void removePointAt(int n) {
        this.willChange();
        int n2 = this.fPoly.npoints - 1;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = this.fPoly.xpoints[n3];
            nArray2[n3] = this.fPoly.ypoints[n3];
            ++n3;
        }
        int n4 = n;
        while (n4 < n2) {
            nArray[n4] = this.fPoly.xpoints[n4 + 1];
            nArray2[n4] = this.fPoly.ypoints[n4 + 1];
            ++n4;
        }
        this.fPoly = new Polygon(nArray, nArray2, n2);
        this.changed();
    }

    public void scaleRotate(Point point, Polygon polygon, Point point2) {
        this.willChange();
        Point point3 = PolygonFigure.center(polygon);
        double d = Geom.length(point3.x, point3.y, point.x, point.y);
        if (d > 0.0) {
            double d2 = Geom.length(point3.x, point3.y, point2.x, point2.y);
            double d3 = d2 / d;
            double d4 = Math.atan2(point.y - point3.y, point.x - point3.x);
            double d5 = Math.atan2(point2.y - point3.y, point2.x - point3.x);
            double d6 = d5 - d4;
            int n = polygon.npoints;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = polygon.xpoints[n2];
                int n4 = polygon.ypoints[n2];
                double d7 = (double)Geom.length(point3.x, point3.y, n3, n4) * d3;
                double d8 = Math.atan2(n4 - point3.y, n3 - point3.x) + d6;
                nArray[n2] = (int)((double)point3.x + d7 * Math.cos(d8) + 0.5);
                nArray2[n2] = (int)((double)point3.y + d7 * Math.sin(d8) + 0.5);
                ++n2;
            }
            this.fPoly = new Polygon(nArray, nArray2, n);
        }
        this.changed();
    }

    public void smoothPoints() {
        this.willChange();
        boolean bl = false;
        int n = this.fPoly.npoints;
        do {
            bl = false;
            int n2 = 0;
            while (n2 < n && n >= 3) {
                int n3 = (n2 - 1 + n) % n;
                int n4 = (n2 + 1) % n;
                if (PolygonFigure.distanceFromLine(this.fPoly.xpoints[n3], this.fPoly.ypoints[n3], this.fPoly.xpoints[n4], this.fPoly.ypoints[n4], this.fPoly.xpoints[n2], this.fPoly.ypoints[n2]) < 2.0) {
                    bl = true;
                    --n;
                    int n5 = n2;
                    while (n5 < n) {
                        this.fPoly.xpoints[n5] = this.fPoly.xpoints[n5 + 1];
                        this.fPoly.ypoints[n5] = this.fPoly.ypoints[n5 + 1];
                        ++n5;
                    }
                    continue;
                }
                ++n2;
            }
        } while (bl);
        if (n != this.fPoly.npoints) {
            this.fPoly = new Polygon(this.fPoly.xpoints, this.fPoly.ypoints, n);
        }
        this.changed();
    }

    public int splitSegment(int n, int n2) {
        int n3 = this.findSegment(n, n2);
        if (n3 != -1) {
            this.insertPointAt(new Point(n, n2), n3 + 1);
            return n3 + 1;
        }
        return -1;
    }

    public Point pointAt(int n) {
        return new Point(this.fPoly.xpoints[n], this.fPoly.ypoints[n]);
    }

    public Point outermostPoint() {
        Point point = this.center();
        int n = 0;
        long l = 0L;
        int n2 = 0;
        while (n2 < this.fPoly.npoints) {
            long l2 = Geom.length2(point.x, point.y, this.fPoly.xpoints[n2], this.fPoly.ypoints[n2]);
            if (l2 > l) {
                l = l2;
                n = n2;
            }
            ++n2;
        }
        return new Point(this.fPoly.xpoints[n], this.fPoly.ypoints[n]);
    }

    public int findSegment(int n, int n2) {
        double d = 2.0;
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.fPoly.npoints) {
            int n5 = (n4 + 1) % this.fPoly.npoints;
            double d2 = PolygonFigure.distanceFromLine(this.fPoly.xpoints[n4], this.fPoly.ypoints[n4], this.fPoly.xpoints[n5], this.fPoly.ypoints[n5], n, n2);
            if (d2 < d) {
                d = d2;
                n3 = n4;
            }
            ++n4;
        }
        return n3;
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fPoly.npoints);
        int n = 0;
        while (n < this.fPoly.npoints) {
            storableOutput.writeInt(this.fPoly.xpoints[n]);
            storableOutput.writeInt(this.fPoly.ypoints[n]);
            ++n;
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        int n = storableInput.readInt();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = storableInput.readInt();
            nArray2[n2] = storableInput.readInt();
            ++n2;
        }
        this.fPoly = new Polygon(nArray, nArray2, n);
    }

    public static Locator locator(int n) {
        return new 1(n);
    }

    public static double distanceFromLine(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n3 - n;
        int n8 = n4 - n2;
        long l = n7 * n7 + n8 * n8;
        if (l == 0L) {
            return Geom.length(n, n2, n5, n6);
        }
        double d = (n2 - n6) * (n2 - n4) - (n - n5) * (n3 - n);
        double d2 = d / (double)l;
        if (d2 < 0.0 || d2 > 1.0) {
            return Double.MAX_VALUE;
        }
        double d3 = (double)n + d2 * (double)n7;
        double d4 = (double)n2 + d2 * (double)n8;
        double d5 = (double)n5 - d3;
        double d6 = (double)n6 - d4;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    public static Rectangle bounds(Polygon polygon) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = polygon.npoints;
        int n6 = 0;
        while (n6 < n5) {
            int n7 = polygon.xpoints[n6];
            int n8 = polygon.ypoints[n6];
            if (n7 > n3) {
                n3 = n7;
            }
            if (n7 < n) {
                n = n7;
            }
            if (n8 > n4) {
                n4 = n8;
            }
            if (n8 < n2) {
                n2 = n8;
            }
            ++n6;
        }
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public static Point center(Polygon polygon) {
        long l = 0L;
        long l2 = 0L;
        int n = polygon.npoints;
        int n2 = 0;
        while (n2 < n) {
            l += (long)polygon.xpoints[n2];
            l2 += (long)polygon.ypoints[n2];
            ++n2;
        }
        return new Point((int)(l / (long)n), (int)(l2 / (long)n));
    }

    public static Point chop(Polygon polygon, Point point) {
        int n;
        Point point2 = PolygonFigure.center(polygon);
        int n2 = -1;
        int n3 = -1;
        long l = Long.MAX_VALUE;
        int n4 = 0;
        while (n4 < polygon.npoints) {
            long l2;
            n = (n4 + 1) % polygon.npoints;
            Point point3 = Geom.intersect(polygon.xpoints[n4], polygon.ypoints[n4], polygon.xpoints[n], polygon.ypoints[n], point.x, point.y, point2.x, point2.y);
            if (point3 != null && (l2 = Geom.length2(point3.x, point3.y, point.x, point.y)) < l) {
                l = l2;
                n2 = point3.x;
                n3 = point3.y;
            }
            ++n4;
        }
        if (l == Long.MAX_VALUE) {
            n = 0;
            while (n < polygon.npoints) {
                long l3 = Geom.length2(polygon.xpoints[n], polygon.ypoints[n], point.x, point.y);
                if (l3 < l) {
                    l = l3;
                    n2 = polygon.xpoints[n];
                    n3 = polygon.ypoints[n];
                }
                ++n;
            }
        }
        return new Point(n2, n3);
    }

    private static final class 1
    extends AbstractLocator {
        private final /* synthetic */ int val$pointIndex;

        public Point locate(Figure figure) {
            PolygonFigure polygonFigure = (PolygonFigure)figure;
            if (this.val$pointIndex < polygonFigure.pointCount()) {
                return ((PolygonFigure)figure).pointAt(this.val$pointIndex);
            }
            return new Point(-1, -1);
        }

        /* synthetic */ 1(int n) {
            this.val$pointIndex = n;
        }
    }
}

