/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.PolygonFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

class PolygonScaleHandle
extends AbstractHandle {
    private Point fOrigin;
    private Point fCurrent;
    private Polygon fOrigPoly;

    public PolygonScaleHandle(PolygonFigure polygonFigure) {
        super(polygonFigure);
    }

    public void invokeStart(int n, int n2, Drawing drawing) {
        this.fOrigPoly = ((PolygonFigure)this.owner()).getPolygon();
        this.fOrigin = this.getOrigin();
        this.fCurrent = new Point(this.fOrigin.x, this.fOrigin.y);
    }

    public void invokeStep(int n, int n2, Drawing drawing) {
        this.fCurrent = new Point(this.fOrigin.x + n, this.fOrigin.y + n2);
        ((PolygonFigure)this.owner()).scaleRotate(this.fOrigin, this.fOrigPoly, this.fCurrent);
    }

    public void invokeEnd(int n, int n2, Drawing drawing) {
        this.fOrigPoly = null;
        this.fOrigin = null;
        this.fCurrent = null;
    }

    public Point locate() {
        if (this.fCurrent != null) {
            return this.fCurrent;
        }
        return this.getOrigin();
    }

    Point getOrigin() {
        Point point = ((PolygonFigure)this.owner()).outermostPoint();
        Point point2 = ((PolygonFigure)this.owner()).center();
        double d = Geom.length(point.x, point.y, point2.x, point2.y);
        if (d == 0.0) {
            return new Point(point.x - 4, point.y + 4);
        }
        double d2 = 8.0 / d;
        if (d2 > 1.0) {
            return new Point((point.x * 3 + point2.x) / 4, (point.y * 3 + point2.y) / 4);
        }
        return new Point((int)((double)point.x * (1.0 - d2) + (double)point2.x * d2), (int)((double)point.y * (1.0 - d2) + (double)point2.y * d2));
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.yellow);
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

