/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.IOException;

public class ArrowTip
implements LineDecoration {
    protected double fAngle;
    protected double fOuterRadius;
    protected double fInnerRadius;
    protected boolean fFilled;
    private static final long serialVersionUID = -3459171428373823638L;
    private int arrowTipSerializedDataVersion = 1;

    public ArrowTip() {
        this.fAngle = 0.4;
        this.fOuterRadius = 8.0;
        this.fInnerRadius = 8.0;
        this.fFilled = true;
    }

    public ArrowTip(double d, double d2, double d3, boolean bl) {
        this.fAngle = d;
        this.fOuterRadius = d2;
        this.fInnerRadius = d3;
        this.fFilled = bl;
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        Polygon polygon = this.outline(n, n2, n3, n4);
        if (this.fFilled) {
            color = color2;
        }
        if (!ColorMap.isTransparent(color)) {
            graphics.setColor(color);
            graphics.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        }
        if (!this.fFilled && !ColorMap.isTransparent(color2)) {
            graphics.setColor(color2);
            graphics.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        }
    }

    public Polygon outline(int n, int n2, int n3, int n4) {
        double d = 1.5707963267948966 - Math.atan2(n3 - n, n2 - n4);
        return this.outline(n, n2, d);
    }

    protected Polygon outline(int n, int n2, double d) {
        Polygon polygon = new Polygon();
        polygon.addPoint(n, n2);
        ArrowTip.addPointRelative(polygon, n, n2, this.fOuterRadius, d - this.fAngle);
        ArrowTip.addPointRelative(polygon, n, n2, this.fInnerRadius, d);
        ArrowTip.addPointRelative(polygon, n, n2, this.fOuterRadius, d + this.fAngle);
        return polygon;
    }

    public static void addPointRelative(Polygon polygon, int n, int n2, double d, double d2) {
        polygon.addPoint(n + (int)(d * Math.cos(d2)), n2 - (int)(d * Math.sin(d2)));
    }

    public void write(StorableOutput storableOutput) {
        storableOutput.writeDouble(this.fAngle);
        storableOutput.writeDouble(this.fOuterRadius);
        storableOutput.writeDouble(this.fInnerRadius);
        storableOutput.writeBoolean(this.fFilled);
    }

    public void read(StorableInput storableInput) throws IOException {
        if (storableInput.getVersion() >= 5) {
            this.fAngle = storableInput.readDouble();
            this.fOuterRadius = storableInput.readDouble();
            this.fInnerRadius = storableInput.readDouble();
            this.fFilled = storableInput.readBoolean();
        }
    }
}

