/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.FigureAttributes;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingContext;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.util.Enumeration;

public abstract class AttributeFigure
extends AbstractFigure
implements FigureWithID {
    private FigureAttributes fAttributes;
    private static FigureAttributes fgDefaultAttributes = null;
    private static final long serialVersionUID = -10857585979273442L;
    private int attributeFigureSerializedDataVersion = 1;
    private static final String _idAttr = "FigureWithID";

    protected AttributeFigure() {
    }

    public void draw(Graphics graphics) {
        if (this.isVisible()) {
            Color color;
            Color color2 = this.getFillColor();
            if (!ColorMap.isTransparent(color2)) {
                graphics.setColor(color2);
                this.drawBackground(graphics);
            }
            if (!ColorMap.isTransparent(color = this.getFrameColor())) {
                graphics.setColor(color);
                this.drawFrame(graphics);
            }
        }
    }

    public void draw(Graphics graphics, DrawingContext drawingContext) {
        if (!this.isVisible() || !drawingContext.isVisible(this)) {
            return;
        }
        if (drawingContext.isHighlighted(this)) {
            Color color = this.getFillColor();
            Color color2 = this.getFrameColor();
            Color color3 = null;
            if (ColorMap.isTransparent(color) || ColorMap.isBackground(color) || this instanceof PolyLineFigure) {
                if (this instanceof TextFigure) {
                    color3 = (Color)this.getAttribute("TextColor");
                    this.setTextColor(ColorMap.hilight(color3));
                } else if (!ColorMap.isTransparent(color2) && !ColorMap.isBackground(color)) {
                    this.setFrameColor(ColorMap.hilight(color2));
                }
            } else {
                this.setFillColor(ColorMap.hilight(color));
            }
            this.draw(graphics);
            this.setFillColor(color);
            this.setFrameColor(color2);
            if (color3 != null) {
                this.setTextColor(color3);
                return;
            }
        } else {
            this.draw(graphics);
        }
    }

    protected void drawBackground(Graphics graphics) {
    }

    protected void drawFrame(Graphics graphics) {
    }

    public Color getFillColor() {
        return (Color)this.getAttribute("FillColor");
    }

    public Color getFrameColor() {
        return (Color)this.getAttribute("FrameColor");
    }

    public void setFillColor(Color color) {
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set("FillColor", color);
    }

    public void setFrameColor(Color color) {
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set("FrameColor", color);
    }

    public void setTextColor(Color color) {
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set("TextColor", color);
    }

    private static void initializeAttributes() {
        fgDefaultAttributes = new FigureAttributes();
        fgDefaultAttributes.set("FrameColor", Color.black);
        fgDefaultAttributes.set("FillColor", new Color(7396243));
        fgDefaultAttributes.set("TextColor", Color.black);
        fgDefaultAttributes.set("ArrowMode", new Integer(0));
        fgDefaultAttributes.set("FontName", "Helvetica");
        fgDefaultAttributes.set("FontSize", new Integer(12));
        fgDefaultAttributes.set("FontStyle", new Integer(0));
        fgDefaultAttributes.set(_idAttr, new Integer(0));
    }

    public static Object getDefaultAttribute(String string) {
        if (fgDefaultAttributes == null) {
            AttributeFigure.initializeAttributes();
        }
        return fgDefaultAttributes.get(string);
    }

    public Object getAttribute(String string) {
        if (this.fAttributes != null && this.fAttributes.hasDefined(string)) {
            return this.fAttributes.get(string);
        }
        Object object = super.getAttribute(string);
        if (object == null) {
            return AttributeFigure.getDefaultAttribute(string);
        }
        return object;
    }

    public void setAttribute(String string, Object object) {
        super.setAttribute(string, object);
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set(string, object);
        this.changed();
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        if (this.fAttributes == null) {
            storableOutput.writeString("no_attributes");
            return;
        }
        storableOutput.writeString("attributes");
        this.fAttributes.write(storableOutput);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        String string = storableInput.readString();
        if (string.toLowerCase().equals("attributes")) {
            this.fAttributes = new FigureAttributes();
            this.fAttributes.read(storableInput);
            Enumeration enumeration = this.fAttributes.definedAttributes();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Object object = this.fAttributes.get(string2);
                super.setAttribute(string2, object);
            }
        }
    }

    public int getID() {
        return (Integer)this.getAttribute(_idAttr);
    }

    public void setID(int n) {
        this.setAttribute(_idAttr, new Integer(n));
    }
}

