/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ElbowHandle;
import CH.ifa.draw.figures.ElbowTextLocator;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.ChangeConnectionEndHandle;
import CH.ifa.draw.standard.ChangeConnectionStartHandle;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class ElbowConnection
extends LineConnection {
    private static final long serialVersionUID = 2193968743082078559L;
    private int elbowConnectionSerializedDataVersion = 1;

    public void updateConnection() {
        super.updateConnection();
        this.updatePoints();
    }

    public void layoutConnection() {
    }

    public Vector handles() {
        Vector<AbstractHandle> vector = new Vector<AbstractHandle>(this.fPoints.size() * 2);
        vector.addElement(new ChangeConnectionStartHandle(this));
        int n = 1;
        while (n < this.fPoints.size() - 1) {
            vector.addElement(new NullHandle(this, PolyLineFigure.locator(n)));
            ++n;
        }
        vector.addElement(new ChangeConnectionEndHandle(this));
        int n2 = 0;
        while (n2 < this.fPoints.size() - 1) {
            vector.addElement(new ElbowHandle(this, n2));
            ++n2;
        }
        return vector;
    }

    public Locator connectedTextLocator(Figure figure) {
        return new ElbowTextLocator();
    }

    protected void updatePoints() {
        this.willChange();
        Point point = this.startPoint();
        Point point2 = this.endPoint();
        this.fPoints.removeAllElements();
        this.fPoints.addElement(point);
        if (point.x == point2.x || point.y == point2.y) {
            this.fPoints.addElement(point2);
        } else {
            Rectangle rectangle = this.start().owner().displayBox();
            Rectangle rectangle2 = this.end().owner().displayBox();
            int n = Geom.direction(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2, rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height / 2);
            if (n == 1 || n == 2) {
                this.fPoints.addElement(new Point(point.x, (point.y + point2.y) / 2));
                this.fPoints.addElement(new Point(point2.x, (point.y + point2.y) / 2));
            } else {
                this.fPoints.addElement(new Point((point.x + point2.x) / 2, point.y));
                this.fPoints.addElement(new Point((point.x + point2.x) / 2, point2.y));
            }
            this.fPoints.addElement(point2);
        }
        this.changed();
    }
}

