/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ImageFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.CreationTool;
import java.awt.FileDialog;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;

public class ImageFigureCreationTool
extends CreationTool
implements ImageObserver {
    private Image image;
    private String fImage;
    private Figure fImageFigure;
    private boolean waitForSize = false;

    public ImageFigureCreationTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    public void activate() {
        super.activate();
        this.image = null;
        FileDialog fileDialog = new FileDialog(this.fEditor.menuFrame(), "Open Image...", 0);
        fileDialog.show();
        String string = fileDialog.getFile();
        this.fImage = string != null ? String.valueOf(fileDialog.getDirectory()) + string : null;
        fileDialog.dispose();
        if (this.fImage != null) {
            this.image = Toolkit.getDefaultToolkit().getImage(this.fImage);
            if (this.image != null) {
                MediaTracker mediaTracker = new MediaTracker(this.fEditor.menuFrame());
                mediaTracker.addImage(this.image, 123);
                try {
                    mediaTracker.waitForAll();
                }
                catch (Exception exception) {
                    this.image = null;
                }
            }
            if (this.image == null) {
                System.out.println("Image " + this.fImage + " could not be loaded!");
                this.fEditor.toolDone();
            }
        }
    }

    protected Figure createFigure() {
        if (this.fImage != null && this.image != null) {
            Point point = this.fEditor.view().lastClick();
            return new ImageFigure(this.image, this.fImage, point);
        }
        return null;
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        Figure figure = this.createdFigure();
        if (figure != null && figure.isEmpty()) {
            Point point = figure.displayBox().getLocation();
            int n3 = this.image.getWidth(this);
            int n4 = this.image.getHeight(this);
            if (n3 == -1 || n4 == -1) {
                System.out.println("Image not loaded properly!");
            } else {
                figure.displayBox(point, new Point(point.x + n3, point.y + n4));
            }
        }
        super.mouseUp(mouseEvent, n, n2);
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return false;
    }
}

