/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.FontSizeHandle;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.OffsetLocator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.Fontkit;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextFigure
extends AttributeFigure
implements ChildFigure,
TextHolder {
    public static final int Font_UNDERLINED;
    private int fOriginX = 0;
    private int fOriginY = 0;
    private transient boolean fSizeIsDirty = true;
    private transient int fWidth;
    private transient int fHeight;
    private String fText;
    private Font fFont;
    private static String fgCurrentFontName;
    private static int fgCurrentFontSize;
    private static int fgCurrentFontStyle;
    private String fCurrentFontName = fgCurrentFontName;
    private int fCurrentFontSize;
    private int fCurrentFontStyle = fgCurrentFontStyle;
    private boolean fIsReadOnly;
    private boolean fCanBeConnected = true;
    private ParentFigure fParent;
    private OffsetLocator fLocator;
    private static final long serialVersionUID = 4599820785949456124L;
    private int textFigureSerializedDataVersion = 1;

    public TextFigure() {
        this("");
    }

    public TextFigure(boolean bl) {
        this("");
        this.fCanBeConnected = bl;
    }

    public TextFigure(String string) {
        this.fCurrentFontSize = fgCurrentFontSize;
        this.setAttribute("FillColor", ColorMap.color("None"));
        this.setAttribute("FrameColor", ColorMap.color("None"));
        this.fText = new String(string);
        this.fSizeIsDirty = true;
    }

    public TextFigure(String string, boolean bl) {
        this(string);
        this.setReadOnly(bl);
    }

    public void moveBy(int n, int n2) {
        this.willChange();
        this.basicMoveBy(n, n2);
        if (this.fLocator != null) {
            this.fLocator.moveBy(n, n2);
        }
        this.changed();
    }

    protected void basicMoveBy(int n, int n2) {
        this.fOriginX += n;
        this.fOriginY += n2;
    }

    public void basicDisplayBox(Point point, Point point2) {
        this.fOriginX = point.x;
        this.fOriginY = point.y;
    }

    public Point getOrigin() {
        return new Point(this.fOriginX, this.fOriginY);
    }

    public Rectangle displayBox() {
        this.textExtent();
        return new Rectangle(this.fOriginX, this.fOriginY, this.fWidth, this.fHeight);
    }

    public Rectangle textDisplayBox() {
        return this.displayBox();
    }

    public boolean readOnly() {
        return this.fIsReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this.fIsReadOnly = bl;
    }

    public Font getFont() {
        if (this.fFont == null) {
            this.fFont = Fontkit.getFont(this.fCurrentFontName, this.fCurrentFontStyle & ~Font_UNDERLINED, this.fCurrentFontSize);
        }
        return this.fFont;
    }

    public void setFont(Font font) {
        this.willChange();
        this.fFont = font;
        this.fCurrentFontName = this.fFont.getName();
        this.fCurrentFontStyle = this.fFont.getStyle();
        this.fCurrentFontSize = this.fFont.getSize();
        this.markDirty();
        this.changed();
    }

    public void changed() {
        super.changed();
        this.updateLocation();
    }

    public Object getAttribute(String string) {
        if (string.equals("FontSize")) {
            return new Integer(this.fCurrentFontSize);
        }
        if (string.equals("FontStyle")) {
            return new Integer(this.fCurrentFontStyle);
        }
        if (string.equals("FontName")) {
            return this.fCurrentFontName;
        }
        return super.getAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        if (string.equals("FontSize") || string.equals("FontStyle") || string.equals("FontName")) {
            this.willChange();
            if (string.equals("FontSize")) {
                this.fCurrentFontSize = (Integer)object;
            } else if (string.equals("FontStyle")) {
                int n = (Integer)object;
                this.fCurrentFontStyle = n == 0 ? 0 : (this.fCurrentFontStyle ^= n);
            } else if (string.equals("FontName")) {
                this.fCurrentFontName = (String)object;
            }
            this.fFont = null;
            this.markDirty();
            this.changed();
            this.markDirty();
            this.changed();
            return;
        }
        super.setAttribute(string, object);
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String string) {
        if (!string.equals(this.fText)) {
            this.willChange();
            this.fText = new String(string);
            this.markDirty();
            this.changed();
        }
    }

    public boolean acceptsTyping() {
        return !this.fIsReadOnly;
    }

    public void draw(Graphics graphics) {
        if (this.isVisible()) {
            super.draw(graphics);
            Color color = (Color)this.getAttribute("TextColor");
            if (!ColorMap.isTransparent(color)) {
                graphics.setColor(color);
                graphics.setFont(this.getFont());
                FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
                int n = this.fOriginY + fontMetrics.getAscent();
                boolean bl = (this.fCurrentFontStyle & Font_UNDERLINED) != 0;
                StringTokenizer stringTokenizer = new StringTokenizer(this.getText(), "\n");
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    graphics.drawString(string, this.fOriginX, n);
                    if (bl) {
                        graphics.drawLine(this.fOriginX, n + 2, this.fOriginX + fontMetrics.stringWidth(string), n + 2);
                    }
                    n += fontMetrics.getHeight();
                }
            }
        }
    }

    public void drawBackground(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawFrame(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
    }

    private Dimension textExtent() {
        if (this.fSizeIsDirty) {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
            StringTokenizer stringTokenizer = new StringTokenizer(this.getText(), "\n");
            this.fWidth = 0;
            this.fHeight = 0;
            while (stringTokenizer.hasMoreElements()) {
                this.fWidth = Math.max(this.fWidth, fontMetrics.stringWidth(stringTokenizer.nextToken()));
                this.fHeight += fontMetrics.getHeight();
            }
            this.fSizeIsDirty = false;
        }
        return new Dimension(this.fWidth, this.fHeight);
    }

    private void markDirty() {
        this.fSizeIsDirty = true;
    }

    public Dimension overlayRowsAndColumns() {
        int n = 0;
        int n2 = 20;
        StringTokenizer stringTokenizer = new StringTokenizer(this.getText(), "\n");
        while (stringTokenizer.hasMoreElements()) {
            n2 = Math.max(n2, stringTokenizer.nextToken().length() + 3);
            ++n;
        }
        if (n == 0) {
            n = 1;
        }
        return new Dimension(n2, n);
    }

    public Vector handles() {
        Vector<LocatorHandle> vector = new Vector<LocatorHandle>();
        vector.addElement(new NullHandle(this, RelativeLocator.northWest()));
        vector.addElement(new NullHandle(this, RelativeLocator.northEast()));
        vector.addElement(new NullHandle(this, RelativeLocator.southEast()));
        vector.addElement(new FontSizeHandle(this, RelativeLocator.southWest()));
        return vector;
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fOriginX);
        storableOutput.writeInt(this.fOriginY);
        storableOutput.writeString(this.fText);
        storableOutput.writeString(this.fCurrentFontName);
        storableOutput.writeInt(this.fCurrentFontStyle);
        storableOutput.writeInt(this.fCurrentFontSize);
        storableOutput.writeBoolean(this.fIsReadOnly);
        storableOutput.writeStorable(this.fParent);
        storableOutput.writeStorable(this.fLocator);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fOriginX = storableInput.readInt();
        this.fOriginY = storableInput.readInt();
        String string = storableInput.readString();
        this.setText(string);
        this.fCurrentFontName = storableInput.readString();
        this.fCurrentFontStyle = storableInput.readInt();
        this.fCurrentFontSize = storableInput.readInt();
        this.fFont = null;
        this.fIsReadOnly = storableInput.readBoolean();
        this.fParent = (ParentFigure)storableInput.readStorable();
        this.fLocator = (OffsetLocator)storableInput.readStorable();
        if (this.fParent != null) {
            this.fParent.addChild(this);
        }
        if (System.getProperty("de.renew.noGraphics") != null) {
            this.fSizeIsDirty = false;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.fParent != null) {
            this.fParent.addChild(this);
        }
        this.markDirty();
    }

    /*
     * Unable to fully structure code
     */
    public boolean canBeParent(ParentFigure var1_1) {
        if (this.fCanBeConnected) ** GOTO lbl7
        return var1_1 == null;
lbl-1000:
        // 1 sources

        {
            if (var1_1 == this) {
                return false;
            }
            if (!(var1_1 instanceof ChildFigure)) break;
            var1_1 = ((ChildFigure)var1_1).parent();
lbl7:
            // 2 sources

            ** while (var1_1 != null)
        }
lbl8:
        // 2 sources

        return true;
    }

    public boolean setParent(ParentFigure parentFigure) {
        if (!this.canBeParent(parentFigure)) {
            return false;
        }
        if (this.fParent != null) {
            this.fParent.removeChild(this);
        }
        this.fParent = parentFigure;
        if (this.fParent == null) {
            this.fLocator = null;
        } else {
            this.fParent.addChild(this);
            if (this.fLocator != null) {
                this.fLocator.setBase(this.fParent.connectedTextLocator(this));
            } else {
                this.fLocator = new OffsetLocator(this.fParent.connectedTextLocator(this));
            }
            this.updateLocation();
        }
        return true;
    }

    public ParentFigure parent() {
        return this.fParent;
    }

    public void updateLocation() {
        if (this.fLocator != null) {
            Point point = this.fLocator.locate(this.fParent);
            point.x -= this.size().width / 2 + this.fOriginX;
            point.y -= this.size().height / 2 + this.fOriginY;
            if (point.x != 0 || point.y != 0) {
                this.willChange();
                this.basicMoveBy(point.x, point.y);
                this.changed();
            }
        }
    }

    public void release() {
        super.release();
        if (this.fParent != null) {
            this.fParent.removeChild(this);
        }
    }

    public static Font createCurrentFont() {
        return Fontkit.getFont(fgCurrentFontName, fgCurrentFontStyle, fgCurrentFontSize);
    }

    public static void setCurrentFontName(String string) {
        fgCurrentFontName = string;
    }

    public static void setCurrentFontSize(int n) {
        fgCurrentFontSize = n;
    }

    public static void setCurrentFontStyle(int n) {
        fgCurrentFontStyle = n;
    }

    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this.updateLocation();
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
    }

    public boolean inspect(DrawingView drawingView, boolean bl) {
        if (!bl) {
            return super.inspect(drawingView, false);
        }
        if (this.acceptsTyping()) {
            ((DrawApplication)drawingView.editor()).doTextEdit(this);
            return true;
        }
        return false;
    }

    static {
        block2: {
            Font_UNDERLINED = Math.max(Math.max(0, 1), 2) * 2;
            fgCurrentFontName = "Helvetica";
            fgCurrentFontSize = 12;
            String string = System.getProperty("de.renew.defaultFontSize");
            if (string == null) break block2;
            try {
                fgCurrentFontSize = Integer.parseInt(string);
                System.out.println("Setting default font size to " + fgCurrentFontSize + " pt.");
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Failed to set default font size to \"" + string + "\": wrong number format.");
            }
        }
    }
}

