/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.FloatingTextField;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class TextTool
extends CreationTool {
    private FloatingTextField fTextField;
    private TextHolder fTypingTarget;

    public TextTool(DrawingEditor drawingEditor, TextFigure textFigure) {
        super(drawingEditor, textFigure);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        TextHolder textHolder = null;
        Figure figure = this.drawing().findFigureInside(n, n2);
        if (figure instanceof TextHolder && !(textHolder = (TextHolder)((Object)figure)).acceptsTyping()) {
            textHolder = null;
        }
        if (textHolder != null) {
            this.beginEdit(textHolder);
            return;
        }
        if (this.fTypingTarget != null) {
            this.editor().toolDone();
            this.endEdit();
            return;
        }
        super.mouseDown(mouseEvent, n, n2);
        textHolder = (TextHolder)((Object)this.createdFigure());
        this.beginEdit(textHolder);
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
    }

    public void deactivate() {
        super.deactivate();
        this.endEdit();
    }

    public void activate() {
        super.activate();
        this.view().clearSelection();
    }

    protected boolean isTypingActive() {
        return this.fTypingTarget != null;
    }

    public void beginEdit(TextHolder textHolder) {
        if (this.fTextField == null) {
            this.fTextField = new FloatingTextField();
        }
        if (textHolder != this.fTypingTarget && this.fTypingTarget != null) {
            this.endEdit();
        }
        this.fTextField.createOverlay((Container)((Object)this.view()), textHolder.getFont());
        this.fTextField.setBounds(this.fieldBounds(textHolder), textHolder.getText());
        this.fTypingTarget = textHolder;
    }

    public void setCaretPosition(int n, int n2) {
        this.fTextField.setCaretPosition(n, n2);
    }

    public void endEdit() {
        if (this.fTypingTarget != null) {
            String string = this.fTextField.getText();
            this.fTypingTarget.setText(this.fTextField.getText());
            if (string.length() == 0) {
                this.drawing().remove((Figure)((Object)this.fTypingTarget));
            }
            this.fTypingTarget = null;
            this.fTextField.endOverlay();
            this.view().checkDamage();
        }
    }

    private Rectangle fieldBounds(TextHolder textHolder) {
        Rectangle rectangle = textHolder.textDisplayBox();
        Dimension dimension = textHolder.overlayRowsAndColumns();
        Dimension dimension2 = this.fTextField.getPreferredSize(dimension.height, dimension.width);
        return new Rectangle(rectangle.x, rectangle.y, dimension2.width, dimension2.height);
    }
}

