/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.DrawingContext;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureFilter;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.ChopBoxConnector;
import CH.ifa.draw.standard.FigureChangeEventMulticaster;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.FilteredFigureEnumerator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public abstract class AbstractFigure
implements ParentFigure {
    private transient FigureChangeListener fListener;
    private static final long serialVersionUID = -10857585979273442L;
    private int abstractFigureSerializedDataVersion = 1;
    private boolean fVisible = true;
    protected Vector children = new Vector();

    protected AbstractFigure() {
    }

    public void draw(Graphics graphics, DrawingContext drawingContext) {
        if (drawingContext.isVisible(this)) {
            this.draw(graphics);
        }
    }

    public void moveBy(int n, int n2) {
        this.willChange();
        this.basicMoveBy(n, n2);
        FigureEnumeration figureEnumeration = this.children();
        while (figureEnumeration.hasMoreElements()) {
            ((ChildFigure)figureEnumeration.nextElement()).updateLocation();
        }
        this.changed();
    }

    protected abstract void basicMoveBy(int var1, int var2);

    public void displayBox(Point point, Point point2) {
        this.willChange();
        this.basicDisplayBox(point, point2);
        this.changed();
    }

    public abstract void basicDisplayBox(Point var1, Point var2);

    public abstract Rectangle displayBox();

    public abstract Vector handles();

    public FigureEnumeration figures() {
        Vector<AbstractFigure> vector = new Vector<AbstractFigure>(1);
        vector.addElement(this);
        return new FigureEnumerator(vector);
    }

    public FigureEnumeration visibleFigures() {
        return new FilteredFigureEnumerator(this.figures(), new 1());
    }

    public Dimension size() {
        Rectangle rectangle = this.displayBox();
        return new Dimension(rectangle.width, rectangle.height);
    }

    public boolean isEmpty() {
        return this.size().width < 3 || this.size().height < 3;
    }

    public Figure findFigureInside(int n, int n2) {
        if (this.containsPoint(n, n2)) {
            return this;
        }
        return null;
    }

    public boolean containsPoint(int n, int n2) {
        if (this.isVisible()) {
            return this.displayBox().contains(n, n2);
        }
        return false;
    }

    public void displayBox(Rectangle rectangle) {
        this.displayBox(new Point(rectangle.x, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
    }

    public boolean includes(Figure figure) {
        return figure == this;
    }

    public FigureEnumeration decompose() {
        Vector<AbstractFigure> vector = new Vector<AbstractFigure>(1);
        vector.addElement(this);
        return new FigureEnumerator(vector);
    }

    public void addToContainer(FigureChangeListener figureChangeListener) {
        this.addFigureChangeListener(figureChangeListener);
        this.invalidate();
    }

    public void removeFromContainer(FigureChangeListener figureChangeListener) {
        this.invalidate();
        this.removeFigureChangeListener(figureChangeListener);
        this.changed();
    }

    public void addFigureChangeListener(FigureChangeListener figureChangeListener) {
        this.fListener = FigureChangeEventMulticaster.add(this.fListener, figureChangeListener);
    }

    public void removeFigureChangeListener(FigureChangeListener figureChangeListener) {
        this.fListener = FigureChangeEventMulticaster.remove(this.fListener, figureChangeListener);
    }

    public FigureChangeListener listener() {
        return this.fListener;
    }

    public void release() {
        if (this.fListener != null) {
            this.fListener.figureRemoved(new FigureChangeEvent(this));
        }
    }

    public void invalidate() {
        if (this.fListener != null) {
            Rectangle rectangle = this.displayBox();
            rectangle.grow(8, 8);
            this.fListener.figureInvalidated(new FigureChangeEvent(this, rectangle));
        }
    }

    public void willChange() {
        this.invalidate();
    }

    public void changed() {
        this.invalidate();
        if (this.fListener != null) {
            this.fListener.figureChanged(new FigureChangeEvent(this));
        }
    }

    public Point center() {
        return Geom.center(this.displayBox());
    }

    public boolean canConnect() {
        return true;
    }

    public Insets connectionInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public Connector connectorAt(int n, int n2) {
        return new ChopBoxConnector(this);
    }

    public void connectorVisibility(boolean bl) {
    }

    public Locator connectedTextLocator(Figure figure) {
        return RelativeLocator.center();
    }

    public Object getAttribute(String string) {
        if ("Visibility".equals(string)) {
            return new Boolean(this.isVisible());
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if ("Visibility".equals(string)) {
            this.setVisible((Boolean)object);
        }
    }

    public Object clone() {
        Closeable closeable;
        Object object = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(200);
        try {
            closeable = new ObjectOutputStream(byteArrayOutputStream);
            closeable.writeObject(this);
            closeable.close();
        }
        catch (IOException iOException) {
            System.out.println("Class not found: " + iOException);
        }
        closeable = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)closeable);
            object = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Class not found: " + classNotFoundException);
        }
        return object;
    }

    public void write(StorableOutput storableOutput) {
    }

    public void read(StorableInput storableInput) throws IOException {
    }

    public FigureEnumeration children() {
        return new FigureEnumerator(this.children);
    }

    public void addChild(ChildFigure childFigure) {
        this.children.addElement(childFigure);
        this.addFigureChangeListener(childFigure);
    }

    public void removeChild(ChildFigure childFigure) {
        this.children.removeElement(childFigure);
        this.removeFigureChangeListener(childFigure);
    }

    private boolean selectAllChildren(DrawingView drawingView) {
        FigureEnumeration figureEnumeration = this.children();
        if (figureEnumeration.hasMoreElements()) {
            drawingView.clearSelection();
            do {
                drawingView.addToSelection(figureEnumeration.nextFigure());
            } while (figureEnumeration.hasMoreElements());
            return true;
        }
        return false;
    }

    public boolean inspect(DrawingView drawingView, boolean bl) {
        if (bl) {
            return false;
        }
        if (this instanceof ChildFigure) {
            ParentFigure parentFigure = ((ChildFigure)((Object)this)).parent();
            if (parentFigure != null) {
                drawingView.clearSelection();
                drawingView.addToSelection(parentFigure);
                return true;
            }
        } else {
            return this.selectAllChildren(drawingView);
        }
        return false;
    }

    public boolean isVisible() {
        return this.fVisible;
    }

    public void setVisible(boolean bl) {
        this.willChange();
        this.fVisible = bl;
        this.changed();
    }

    public abstract void draw(Graphics var1);

    private final class 1
    implements FigureFilter {
        public boolean isUsed(Figure figure) {
            return figure.isVisible();
        }

        /* synthetic */ 1() {
        }
    }
}

