/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public abstract class AbstractHandle
implements Handle {
    public static final int HANDLESIZE = 8;
    private Figure fOwner;

    public AbstractHandle(Figure figure) {
        this.fOwner = figure;
    }

    public abstract Point locate();

    public void invokeStart(int n, int n2, Drawing drawing) {
    }

    public void invokeStart(int n, int n2, DrawingView drawingView) {
        this.invokeStart(n, n2, drawingView.drawing());
    }

    protected void invokeAction(int n, int n2, DrawingView drawingView) {
        this.invokeStart(n, n2, drawingView);
    }

    public void invokeStart(MouseEvent mouseEvent, DrawingView drawingView) {
        if ((mouseEvent.getModifiers() & 0xC) != 0) {
            this.invokeAction(mouseEvent.getX(), mouseEvent.getY(), drawingView);
            return;
        }
        this.invokeStart(mouseEvent.getX(), mouseEvent.getY(), drawingView);
    }

    public void invokeStep(int n, int n2, Drawing drawing) {
    }

    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        this.invokeStep(n - n3, n2 - n4, drawingView.drawing());
    }

    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        this.invokeEnd(n - n3, n2 - n4, drawingView.drawing());
    }

    public void invokeEnd(int n, int n2, Drawing drawing) {
    }

    public Figure owner() {
        return this.fOwner;
    }

    public Rectangle displayBox() {
        Point point = this.locate();
        return new Rectangle(point.x - 4, point.y - 4, 8, 8);
    }

    public boolean containsPoint(int n, int n2) {
        return this.displayBox().contains(n, n2);
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.white);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

