/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractConnector;
import CH.ifa.draw.util.Geom;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class ChopBoxConnector
extends AbstractConnector {
    private static final long serialVersionUID = -1461450322712345462L;

    public ChopBoxConnector() {
    }

    public ChopBoxConnector(Figure figure) {
        super(figure);
    }

    public Point findStart(ConnectionFigure connectionFigure) {
        Rectangle rectangle = connectionFigure.pointCount() == 2 ? connectionFigure.end().displayBox() : new Rectangle(connectionFigure.pointAt(1), new Dimension(0, 0));
        return this.chop(connectionFigure.start().owner(), rectangle);
    }

    public Point findEnd(ConnectionFigure connectionFigure) {
        Rectangle rectangle = connectionFigure.pointCount() == 2 ? connectionFigure.start().displayBox() : new Rectangle(connectionFigure.pointAt(connectionFigure.pointCount() - 2), new Dimension(0, 0));
        return this.chop(connectionFigure.end().owner(), rectangle);
    }

    protected Point chop(Figure figure, Rectangle rectangle) {
        Rectangle rectangle2;
        return Geom.angleToPoint(rectangle2, ((rectangle2 = figure.displayBox()).intersection(rectangle).equals(rectangle2) ? Math.PI : 0.0) + Geom.pointToAngle(rectangle2, Geom.center(rectangle)));
    }
}

