/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class ConnectionHandle
extends LocatorHandle {
    private ConnectionFigure fConnection;
    private ConnectionFigure fPrototype;
    private Figure fTarget;

    public ConnectionHandle(Figure figure, Locator locator, ConnectionFigure connectionFigure) {
        super(figure, locator);
        this.fPrototype = connectionFigure;
    }

    public void invokeStart(int n, int n2, DrawingView drawingView) {
        this.fConnection = this.createConnection();
        Point point = this.locate();
        this.fConnection.startPoint(point.x, point.y);
        this.fConnection.endPoint(point.x, point.y);
        drawingView.drawing().add(this.fConnection);
    }

    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        Connector connector;
        Point point = new Point(n, n2);
        Figure figure = this.findConnectableFigure(n, n2, drawingView.drawing());
        if (figure != this.fTarget) {
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(false);
            }
            this.fTarget = figure;
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(true);
            }
        }
        if ((connector = this.findConnectionTarget(point.x, point.y, drawingView.drawing())) != null) {
            point = Geom.center(connector.displayBox());
        }
        this.fConnection.endPoint(point.x, point.y);
    }

    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        Connector connector = this.findConnectionTarget(n, n2, drawingView.drawing());
        if (connector != null) {
            this.fConnection.connectStart(this.startConnector());
            this.fConnection.connectEnd(connector);
            this.fConnection.updateConnection();
        } else {
            drawingView.drawing().remove(this.fConnection);
        }
        this.fConnection = null;
        if (this.fTarget != null) {
            this.fTarget.connectorVisibility(false);
            this.fTarget = null;
        }
    }

    private Connector startConnector() {
        Point point = this.locate();
        return this.owner().connectorAt(point.x, point.y);
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    protected Connector findConnectionTarget(int n, int n2, Drawing drawing) {
        Figure figure = this.findConnectableFigure(n, n2, drawing);
        if (figure != null && figure.canConnect() && !figure.includes(this.owner()) && this.fConnection.canConnect(this.owner(), figure)) {
            return this.findConnector(n, n2, figure);
        }
        return null;
    }

    private Figure findConnectableFigure(int n, int n2, Drawing drawing) {
        FigureEnumeration figureEnumeration = drawing.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (figure.includes(this.fConnection) || !figure.canConnect() || !figure.containsPoint(n, n2)) continue;
            return figure;
        }
        return null;
    }

    protected Connector findConnector(int n, int n2, Figure figure) {
        return figure.connectorAt(n, n2);
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.blue);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

