/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class ConnectionTool
extends AbstractTool {
    private Connector fStartConnector;
    private Connector fEndConnector;
    private Connector fConnectorTarget;
    private Figure fTarget;
    private ConnectionFigure fConnection;
    private int fSplitPoint;
    private ConnectionFigure fEditedConnection;
    private ConnectionFigure fPrototype;

    public ConnectionTool(DrawingEditor drawingEditor, ConnectionFigure connectionFigure) {
        super(drawingEditor);
        this.fPrototype = connectionFigure;
    }

    public void mouseMove(MouseEvent mouseEvent, int n, int n2) {
        this.trackConnectors(mouseEvent, n, n2);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        int n3;
        int n4 = mouseEvent.getX();
        ConnectionFigure connectionFigure = this.findConnection(n4, n3 = mouseEvent.getY(), this.drawing());
        if (connectionFigure != null) {
            if (!connectionFigure.joinSegments(n4, n3)) {
                this.fSplitPoint = connectionFigure.splitSegment(n4, n3);
                this.fEditedConnection = connectionFigure;
                return;
            }
            this.fEditedConnection = null;
            return;
        }
        this.fTarget = this.findConnectionStart(n4, n3, this.drawing());
        if (this.fTarget != null) {
            this.fStartConnector = this.findConnector(n4, n3, this.fTarget);
            if (this.fStartConnector != null) {
                Point point = new Point(n4, n3);
                this.fConnection = this.createConnection();
                this.fConnection.startPoint(point.x, point.y);
                this.fConnection.endPoint(point.x, point.y);
                this.view().add(this.fConnection);
            }
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        if (this.fConnection != null) {
            this.trackConnectors(mouseEvent, n, n2);
            if (this.fConnectorTarget != null) {
                point = Geom.center(this.fConnectorTarget.displayBox());
            }
            this.fConnection.endPoint(point.x, point.y);
            return;
        }
        if (this.fEditedConnection != null) {
            Point point2 = new Point(n, n2);
            this.fEditedConnection.setPointAt(point2, this.fSplitPoint);
        }
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        Figure figure = null;
        if (this.fStartConnector != null) {
            figure = this.findTarget(mouseEvent.getX(), mouseEvent.getY(), this.drawing());
        }
        if (figure != null) {
            this.fEndConnector = this.findConnector(mouseEvent.getX(), mouseEvent.getY(), figure);
            if (this.fEndConnector != null) {
                this.fConnection.connectStart(this.fStartConnector);
                this.fConnection.connectEnd(this.fEndConnector);
                this.fConnection.updateConnection();
            }
        } else if (this.fConnection != null) {
            this.view().remove(this.fConnection);
        }
        this.fConnection = null;
        this.fEndConnector = null;
        this.fStartConnector = null;
        this.editor().toolDone();
    }

    public void deactivate() {
        super.deactivate();
        if (this.fTarget != null) {
            this.fTarget.connectorVisibility(false);
        }
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    protected Figure findSource(int n, int n2, Drawing drawing) {
        return this.findConnectableFigure(n, n2, drawing);
    }

    protected Figure findTarget(int n, int n2, Drawing drawing) {
        Figure figure = this.findConnectableFigure(n, n2, drawing);
        Figure figure2 = this.fStartConnector.owner();
        if (figure != null && this.fConnection != null && figure.canConnect() && !figure.includes(figure2) && this.fConnection.canConnect(figure2, figure)) {
            return figure;
        }
        return null;
    }

    protected ConnectionFigure findConnection(int n, int n2, Drawing drawing) {
        FigureEnumeration figureEnumeration = drawing.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = (Figure)figureEnumeration.nextElement();
            if ((figure = figure.findFigureInside(n, n2)) == null || !(figure instanceof ConnectionFigure)) continue;
            return (ConnectionFigure)figure;
        }
        return null;
    }

    protected ConnectionFigure createdFigure() {
        return this.fConnection;
    }

    protected void trackConnectors(MouseEvent mouseEvent, int n, int n2) {
        if (this.fConnection == null) {
            return;
        }
        Figure figure = null;
        figure = this.fStartConnector == null ? this.findSource(n, n2, this.drawing()) : this.findTarget(n, n2, this.drawing());
        if (figure != this.fTarget) {
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(false);
            }
            this.fTarget = figure;
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(true);
            }
        }
        Connector connector = null;
        if (figure != null) {
            connector = this.findConnector(mouseEvent.getX(), mouseEvent.getY(), figure);
        }
        if (connector != this.fConnectorTarget) {
            this.fConnectorTarget = connector;
        }
        this.view().checkDamage();
    }

    private Connector findConnector(int n, int n2, Figure figure) {
        return figure.connectorAt(n, n2);
    }

    protected Figure findConnectionStart(int n, int n2, Drawing drawing) {
        Figure figure = this.findConnectableFigure(n, n2, drawing);
        if (figure != null && figure.canConnect()) {
            return figure;
        }
        return null;
    }

    private Figure findConnectableFigure(int n, int n2, Drawing drawing) {
        FigureEnumeration figureEnumeration = drawing.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (this.fConnection != null && figure.includes(this.fConnection) || !figure.canConnect() || !figure.containsPoint(n, n2)) continue;
            return figure;
        }
        return null;
    }

    protected Connector getStartConnector() {
        return this.fStartConnector;
    }

    protected Connector getEndConnector() {
        return this.fEndConnector;
    }

    protected Connector getTarget() {
        return this.fConnectorTarget;
    }
}

