/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.util.Clipboard;
import CH.ifa.draw.util.Command;
import java.util.Vector;

abstract class FigureTransferCommand
extends Command {
    protected DrawingEditor fEditor;

    protected FigureTransferCommand(String string, DrawingEditor drawingEditor) {
        super(string);
        this.fEditor = drawingEditor;
    }

    protected void deleteSelection() {
        DrawingView drawingView = this.fEditor.view();
        drawingView.drawing().removeAll(drawingView.selection());
        drawingView.clearSelection();
    }

    protected void copySelection() {
        FigureSelection figureSelection = this.fEditor.view().getFigureSelection();
        Clipboard.getClipboard().setContents(figureSelection);
    }

    protected void insertFigures(Vector vector, int n, int n2) {
        DrawingView drawingView = this.fEditor.view();
        FigureEnumerator figureEnumerator = new FigureEnumerator(vector);
        while (figureEnumerator.hasMoreElements()) {
            Figure figure = figureEnumerator.nextFigure();
            figure = drawingView.add(figure);
            drawingView.addToSelection(figure);
        }
        StandardDrawingView.moveFigures(vector, n, n2);
        drawingView.checkDamage();
    }
}

