/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractLocator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Point;
import java.io.IOException;

public class OffsetLocator
extends AbstractLocator {
    private static final long serialVersionUID = 2679950024611847621L;
    private int offsetLocatorSerializedDataVersion = 1;
    private Locator fBase = null;
    private int fOffsetX = 0;
    private int fOffsetY = 0;

    public OffsetLocator() {
    }

    public OffsetLocator(Locator locator) {
        this();
        this.fBase = locator;
    }

    public OffsetLocator(Locator locator, int n, int n2) {
        this(locator);
        this.fOffsetX = n;
        this.fOffsetY = n2;
    }

    public Point locate(Figure figure) {
        Point point = this.fBase.locate(figure);
        point.x += this.fOffsetX;
        point.y += this.fOffsetY;
        return point;
    }

    public void setBase(Locator locator) {
        this.fBase = locator;
    }

    public void moveBy(int n, int n2) {
        this.fOffsetX += n;
        this.fOffsetY += n2;
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fOffsetX);
        storableOutput.writeInt(this.fOffsetY);
        storableOutput.writeStorable(this.fBase);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fOffsetX = storableInput.readInt();
        this.fOffsetY = storableInput.readInt();
        this.fBase = (Locator)storableInput.readStorable();
    }
}

