/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class SelectAreaTracker
extends AbstractTool {
    private Rectangle fSelectGroup;

    public SelectAreaTracker(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
        this.rubberBand(this.fAnchorX, this.fAnchorY, this.fAnchorX, this.fAnchorY);
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDrag(mouseEvent, n, n2);
        this.eraseRubberBand();
        this.rubberBand(this.fAnchorX, this.fAnchorY, n, n2);
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        super.mouseUp(mouseEvent, n, n2);
        this.eraseRubberBand();
        this.selectGroup(mouseEvent.isShiftDown());
    }

    private void rubberBand(int n, int n2, int n3, int n4) {
        this.fSelectGroup = new Rectangle(new Point(n, n2));
        this.fSelectGroup.add(new Point(n3, n4));
        this.drawXORRect(this.fSelectGroup);
    }

    private void eraseRubberBand() {
        this.drawXORRect(this.fSelectGroup);
    }

    private void drawXORRect(Rectangle rectangle) {
        Graphics graphics = this.view().getGraphics();
        graphics.setXORMode(this.view().getBackground());
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void selectGroup(boolean bl) {
        FigureEnumeration figureEnumeration = this.drawing().figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            Rectangle rectangle = figure.displayBox();
            if (!this.fSelectGroup.contains(rectangle.x, rectangle.y) || !this.fSelectGroup.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height)) continue;
            if (bl) {
                this.view().toggleSelection(figure);
                continue;
            }
            this.view().addToSelection(figure);
        }
    }
}

