/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.ChildDragTracker;
import CH.ifa.draw.standard.DragTracker;
import CH.ifa.draw.standard.HandleTracker;
import CH.ifa.draw.standard.SelectAreaTracker;
import java.awt.event.MouseEvent;

public class SelectionTool
extends AbstractTool {
    private Tool fChild;

    public SelectionTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        if (this.fChild != null) {
            return;
        }
        this.view().freezeView();
        Handle handle = this.view().findHandle(mouseEvent.getX(), mouseEvent.getY());
        if (handle != null) {
            this.fChild = this.createHandleTracker(this.fEditor, handle);
        } else {
            Figure figure = this.drawing().findFigure(mouseEvent.getX(), mouseEvent.getY());
            if (figure != null) {
                boolean bl;
                boolean bl2 = bl = (mouseEvent.getModifiers() & 0xC) != 0;
                if (mouseEvent.getClickCount() >= 2 && !bl) {
                    figure.inspect(this.view(), false);
                    return;
                }
                if (bl && this.alternateInspectFigure(figure)) {
                    return;
                }
                this.fChild = this.createDragTracker(this.fEditor, figure);
            } else {
                if (!mouseEvent.isShiftDown()) {
                    this.view().clearSelection();
                }
                this.fChild = this.createAreaTracker(this.fEditor);
            }
        }
        this.fChild.mouseDown(mouseEvent, n, n2);
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (this.fChild != null) {
            this.fChild.mouseDrag(mouseEvent, n, n2);
        }
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        this.view().unfreezeView();
        if (this.fChild != null) {
            this.fChild.mouseUp(mouseEvent, n, n2);
        }
        this.fChild = null;
    }

    protected Tool createHandleTracker(DrawingEditor drawingEditor, Handle handle) {
        return new HandleTracker(drawingEditor, handle);
    }

    protected Tool createDragTracker(DrawingEditor drawingEditor, Figure figure) {
        if (figure instanceof ChildFigure) {
            return new ChildDragTracker(drawingEditor, (ChildFigure)figure);
        }
        return new DragTracker(drawingEditor, figure);
    }

    protected Tool createAreaTracker(DrawingEditor drawingEditor) {
        return new SelectAreaTracker(drawingEditor);
    }

    protected boolean alternateInspectFigure(Figure figure) {
        return figure.inspect(this.view(), true);
    }
}

