/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.standard.GridConstrainer;
import CH.ifa.draw.util.Command;
import java.awt.Point;

public class SnapToGridCommand
extends Command {
    protected DrawingEditor fEditor;
    private Point fGrid;

    public SnapToGridCommand(String string, DrawingEditor drawingEditor, Point point) {
        super(string);
        this.fEditor = drawingEditor;
        this.fGrid = new Point(point.x, point.y);
    }

    public boolean isExecutable() {
        return this.fEditor.view().selectionCount() > 0;
    }

    public void execute() {
        DrawingView drawingView = this.fEditor.view();
        PointConstrainer pointConstrainer = drawingView.getConstrainer();
        if (pointConstrainer == null) {
            System.out.println("No active grid - using default grid.");
            pointConstrainer = new GridConstrainer(this.fGrid.x, this.fGrid.y);
        }
        FigureEnumeration figureEnumeration = drawingView.selectionElements();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            Point point = figure.center();
            Point point2 = pointConstrainer.constrainPoint(figure.center());
            figure.moveBy(point2.x - point.x, point2.y - point.y);
        }
        drawingView.checkDamage();
    }
}

