/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;

public class StandardDrawing
extends CompositeFigure
implements Drawing {
    static String fgUntitled = "untitled";
    private transient Vector fListeners;
    private transient Thread fDrawingLockHolder;
    private String fDrawingName = fgUntitled;
    private String fDrawingFilename;
    private boolean modified = false;
    private static final long serialVersionUID = -2602151437447962046L;
    private int drawingSerializedDataVersion = 1;

    public StandardDrawing() {
        this.fListeners = new Vector(2);
    }

    public String getName() {
        return this.fDrawingName;
    }

    public void setName(String string) {
        this.fDrawingName = string;
    }

    public String getFilename() {
        return this.fDrawingFilename;
    }

    public void setFilename(String string) {
        this.fDrawingFilename = string;
    }

    public void addDrawingChangeListener(DrawingChangeListener drawingChangeListener) {
        this.fListeners.addElement(drawingChangeListener);
    }

    public void removeDrawingChangeListener(DrawingChangeListener drawingChangeListener) {
        this.fListeners.removeElement(drawingChangeListener);
    }

    public Enumeration drawingChangeListeners() {
        return this.fListeners.elements();
    }

    public synchronized Figure remove(Figure figure) {
        if (figure.listener() != null) {
            figure.listener().figureRequestRemove(new FigureChangeEvent(figure, null));
            return figure;
        }
        return null;
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
        Figure figure = figureChangeEvent.getFigure();
        if (this.fFigures.contains(figure)) {
            this.modified = true;
            this.fFigures.removeElement(figure);
            figure.removeFromContainer(this);
            figure.release();
            return;
        }
        System.out.println("Attempt to remove non-existing figure");
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
        this.modified = true;
        if (this.fListeners != null) {
            int n = 0;
            while (n < this.fListeners.size()) {
                DrawingChangeListener drawingChangeListener = (DrawingChangeListener)this.fListeners.elementAt(n);
                drawingChangeListener.drawingInvalidated(new DrawingChangeEvent(this, figureChangeEvent.getInvalidatedRectangle()));
                ++n;
            }
        }
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
        if (this.fListeners != null) {
            int n = 0;
            while (n < this.fListeners.size()) {
                DrawingChangeListener drawingChangeListener = (DrawingChangeListener)this.fListeners.elementAt(n);
                drawingChangeListener.drawingRequestUpdate(new DrawingChangeEvent(this, null));
                ++n;
            }
        }
    }

    public Vector handles() {
        Vector<NullHandle> vector = new Vector<NullHandle>();
        vector.addElement(new NullHandle(this, RelativeLocator.northWest()));
        vector.addElement(new NullHandle(this, RelativeLocator.northEast()));
        vector.addElement(new NullHandle(this, RelativeLocator.southWest()));
        vector.addElement(new NullHandle(this, RelativeLocator.southEast()));
        return vector;
    }

    public Rectangle displayBox() {
        if (this.fFigures.size() > 0) {
            FigureEnumeration figureEnumeration = this.figures();
            Rectangle rectangle = figureEnumeration.nextFigure().displayBox();
            while (figureEnumeration.hasMoreElements()) {
                rectangle.add(figureEnumeration.nextFigure().displayBox());
            }
            return new Rectangle(rectangle.x - 10, rectangle.y - 10, rectangle.width + 20, rectangle.height + 20);
        }
        return new Rectangle(0, 0, 100, 100);
    }

    public void basicDisplayBox(Point point, Point point2) {
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void lock() {
        var1_1 = Thread.currentThread();
        if (this.fDrawingLockHolder != var1_1) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException v0) {}
lbl8:
            // 3 sources

            ** while (this.fDrawingLockHolder != null)
        }
lbl9:
        // 1 sources

        this.fDrawingLockHolder = var1_1;
    }

    public synchronized void unlock() {
        if (this.fDrawingLockHolder != null) {
            this.fDrawingLockHolder = null;
            this.notifyAll();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.fListeners = new Vector(2);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        this.modified = false;
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.modified = false;
    }
}

