/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Painter;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.BufferedUpdateStrategy;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.ContextGraphics;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;

public class StandardDrawingView
extends Panel
implements DrawingView,
MouseListener,
MouseMotionListener,
KeyListener {
    private transient DrawingEditor fEditor;
    private Drawing fDrawing;
    private transient Rectangle fDamage;
    private transient Vector fSelection;
    private transient Vector fSelectionHandles;
    private Dimension fViewSize;
    private Point fLastClick;
    private Vector fBackgrounds;
    private Vector fForegrounds;
    private Painter fUpdateStrategy;
    private PointConstrainer fConstrainer;
    private static final long serialVersionUID = -3878153366174603336L;
    private int drawingViewSerializedDataVersion = 1;
    private static boolean wantSpecialUpdate;

    public StandardDrawingView(DrawingEditor drawingEditor, int n, int n2) {
        this.setSize(n, n2);
        this.fEditor = drawingEditor;
        this.fViewSize = new Dimension(n, n2);
        this.fLastClick = new Point(0, 0);
        this.fConstrainer = null;
        this.fSelection = new Vector();
        if (wantSpecialUpdate) {
            this.setDisplayUpdate(new SimpleUpdateStrategy());
        } else {
            this.setDisplayUpdate(new BufferedUpdateStrategy());
        }
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    protected Dimension defaultSize() {
        return new Dimension(430, 406);
    }

    public void setEditor(DrawingEditor drawingEditor) {
        this.fEditor = drawingEditor;
    }

    public Tool tool() {
        return this.fEditor.tool();
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    public void setDrawing(Drawing drawing) {
        if (this.fDrawing != null) {
            this.clearSelection();
            this.fDrawing.removeDrawingChangeListener(this);
        }
        this.fDrawing = drawing;
        this.fDrawing.addDrawingChangeListener(this);
        this.checkMinimumSize();
        this.repaint();
    }

    public DrawingEditor editor() {
        return this.fEditor;
    }

    public Figure add(Figure figure) {
        return this.drawing().add(figure);
    }

    public Figure remove(Figure figure) {
        return this.drawing().remove(figure);
    }

    public void addAll(Vector vector) {
        FigureEnumerator figureEnumerator = new FigureEnumerator(vector);
        while (figureEnumerator.hasMoreElements()) {
            this.add(figureEnumerator.nextFigure());
        }
    }

    public Dimension getMinimumSize() {
        return this.fViewSize;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setDisplayUpdate(Painter painter) {
        this.fUpdateStrategy = painter;
    }

    public Vector selection() {
        return (Vector)this.fSelection.clone();
    }

    public FigureEnumeration selectionElements() {
        return new FigureEnumerator(this.fSelection);
    }

    public Vector selectionZOrdered() {
        Vector<Figure> vector = new Vector<Figure>(this.fSelection.size());
        FigureEnumeration figureEnumeration = this.drawing().figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!this.fSelection.contains(figure)) continue;
            vector.addElement(figure);
        }
        return vector;
    }

    public int selectionCount() {
        return this.fSelection.size();
    }

    public void addToSelection(Figure figure) {
        if (!this.fSelection.contains(figure)) {
            this.fSelection.addElement(figure);
            this.fSelectionHandles = null;
            figure.invalidate();
            this.selectionChanged();
        }
    }

    public void addToSelectionAll(Vector vector) {
        FigureEnumerator figureEnumerator = new FigureEnumerator(vector);
        while (figureEnumerator.hasMoreElements()) {
            this.addToSelection(figureEnumerator.nextFigure());
        }
    }

    public void removeFromSelection(Figure figure) {
        if (this.fSelection.contains(figure)) {
            this.fSelection.removeElement(figure);
            this.fSelectionHandles = null;
            figure.invalidate();
            this.selectionChanged();
        }
    }

    public void toggleSelection(Figure figure) {
        if (this.fSelection.contains(figure)) {
            this.removeFromSelection(figure);
        } else {
            this.addToSelection(figure);
        }
        this.selectionChanged();
    }

    public void clearSelection() {
        FigureEnumeration figureEnumeration = this.selectionElements();
        while (figureEnumeration.hasMoreElements()) {
            figureEnumeration.nextFigure().invalidate();
        }
        this.fSelection = new Vector();
        this.fSelectionHandles = null;
        this.selectionChanged();
    }

    private Enumeration selectionHandles() {
        if (this.fSelectionHandles == null) {
            this.fSelectionHandles = new Vector();
            FigureEnumeration figureEnumeration = this.selectionElements();
            while (figureEnumeration.hasMoreElements()) {
                Figure figure = figureEnumeration.nextFigure();
                Enumeration enumeration = figure.handles().elements();
                while (enumeration.hasMoreElements()) {
                    this.fSelectionHandles.addElement(enumeration.nextElement());
                }
            }
        }
        return this.fSelectionHandles.elements();
    }

    public FigureSelection getFigureSelection() {
        return new FigureSelection(this.selectionZOrdered());
    }

    public Handle findHandle(int n, int n2) {
        Enumeration enumeration = this.selectionHandles();
        while (enumeration.hasMoreElements()) {
            Handle handle = (Handle)enumeration.nextElement();
            if (!handle.containsPoint(n, n2)) continue;
            return handle;
        }
        return null;
    }

    protected void selectionChanged() {
        this.fEditor.selectionChanged(this);
    }

    public Point lastClick() {
        return this.fLastClick;
    }

    public void setConstrainer(PointConstrainer pointConstrainer) {
        this.fConstrainer = pointConstrainer;
    }

    public PointConstrainer getConstrainer() {
        return this.fConstrainer;
    }

    protected Point constrainPoint(Point point) {
        Dimension dimension = this.getSize();
        point.x = Geom.range(1, dimension.width, point.x);
        point.y = Geom.range(1, dimension.height, point.y);
        if (this.fConstrainer != null) {
            return this.fConstrainer.constrainPoint(point);
        }
        return point;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        Point point = this.constrainPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        this.fLastClick = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.tool().mouseDown(mouseEvent, point.x, point.y);
        this.checkDamage();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = this.constrainPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        this.tool().mouseDrag(mouseEvent, point.x, point.y);
        this.checkDamage();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.tool().mouseMove(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Point point = this.constrainPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        this.tool().mouseUp(mouseEvent, point.x, point.y);
        this.checkDamage();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 8 || n == 127) {
            DeleteCommand deleteCommand = new DeleteCommand("Delete", this.fEditor);
            ((Command)deleteCommand).execute();
        } else if (n == 40 || n == 38 || n == 39 || n == 37) {
            this.handleCursorKey(n);
        } else {
            this.tool().keyDown(keyEvent, n);
        }
        this.checkDamage();
    }

    protected void handleCursorKey(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = 1;
        if (this.fConstrainer != null) {
            n4 = this.fConstrainer.getStepX();
            n5 = this.fConstrainer.getStepY();
        }
        switch (n) {
            case 40: {
                n3 = n5;
                break;
            }
            case 38: {
                n3 = -n5;
                break;
            }
            case 39: {
                n2 = n4;
                break;
            }
            case 37: {
                n2 = -n4;
                break;
            }
        }
        this.moveSelection(n2, n3);
    }

    public static void moveFigures(Vector vector, int n, int n2) {
        FigureEnumerator figureEnumerator = new FigureEnumerator(vector);
        while (figureEnumerator.hasMoreElements()) {
            Figure figure;
            Figure figure2 = figure = figureEnumerator.nextFigure();
            while (figure2 != null) {
                if (figure2 instanceof ChildFigure) {
                    if ((figure2 = ((ChildFigure)figure2).parent()) == null || !vector.contains(figure2)) continue;
                    break;
                }
                figure2 = null;
            }
            if (figure2 != null) continue;
            figure.moveBy(n, n2);
        }
    }

    public void moveSelection(int n, int n2) {
        StandardDrawingView.moveFigures(this.fSelection, n, n2);
        this.checkDamage();
    }

    public synchronized void checkDamage() {
        Enumeration enumeration = this.drawing().drawingChangeListeners();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof DrawingView)) continue;
            ((DrawingView)e).repairDamage();
        }
    }

    public void repairDamage() {
        if (this.fDamage != null) {
            this.repaint(this.fDamage.x, this.fDamage.y, this.fDamage.width, this.fDamage.height);
            this.fDamage = null;
        }
    }

    public void drawingInvalidated(DrawingChangeEvent drawingChangeEvent) {
        Rectangle rectangle = drawingChangeEvent.getInvalidatedRectangle();
        if (this.fDamage == null) {
            this.fDamage = rectangle;
            return;
        }
        this.fDamage.add(rectangle);
    }

    public void drawingRequestUpdate(DrawingChangeEvent drawingChangeEvent) {
        this.repairDamage();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.fUpdateStrategy.draw(graphics, this);
    }

    public void drawAll(Graphics graphics) {
        boolean bl = graphics instanceof PrintGraphics;
        this.drawBackground(graphics);
        if (this.fBackgrounds != null && !bl) {
            this.drawPainters(graphics, this.fBackgrounds);
        }
        this.drawDrawing(new ContextGraphics(graphics, this.getBackground()));
        if (this.fForegrounds != null && !bl) {
            this.drawPainters(graphics, this.fForegrounds);
        }
        if (!bl) {
            this.drawHandles(graphics);
        }
    }

    public void drawHandles(Graphics graphics) {
        Enumeration enumeration = this.selectionHandles();
        while (enumeration.hasMoreElements()) {
            ((Handle)enumeration.nextElement()).draw(graphics);
        }
    }

    public void drawDrawing(Graphics graphics) {
        this.fDrawing.draw(graphics);
    }

    public void drawBackground(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
    }

    private void drawPainters(Graphics graphics, Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            ((Painter)vector.elementAt(n)).draw(graphics, this);
            ++n;
        }
    }

    public void addBackground(Painter painter) {
        if (this.fBackgrounds == null) {
            this.fBackgrounds = new Vector(3);
        }
        this.fBackgrounds.addElement(painter);
        this.repaint();
    }

    public void removeBackground(Painter painter) {
        if (this.fBackgrounds != null) {
            this.fBackgrounds.removeElement(painter);
        }
        this.repaint();
    }

    public void removeForeground(Painter painter) {
        if (this.fForegrounds != null) {
            this.fForegrounds.removeElement(painter);
        }
        this.repaint();
    }

    public void addForeground(Painter painter) {
        if (this.fForegrounds == null) {
            this.fForegrounds = new Vector(3);
        }
        this.fForegrounds.addElement(painter);
        this.repaint();
    }

    public void freezeView() {
        this.drawing().lock();
    }

    public void unfreezeView() {
        this.drawing().unlock();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.fSelection = new Vector();
        if (this.fDrawing != null) {
            this.fDrawing.addDrawingChangeListener(this);
        }
    }

    private void checkMinimumSize() {
        FigureEnumeration figureEnumeration = this.drawing().figures();
        Dimension dimension = new Dimension(0, 0);
        while (figureEnumeration.hasMoreElements()) {
            Rectangle rectangle = figureEnumeration.nextFigure().displayBox();
            dimension.width = Math.max(dimension.width, rectangle.x + rectangle.width);
            dimension.height = Math.max(dimension.height, rectangle.y + rectangle.height);
        }
        boolean bl = false;
        if (this.fViewSize.height < dimension.height) {
            this.fViewSize.height = dimension.height + 10;
            bl = true;
        }
        if (this.fViewSize.width < dimension.width) {
            this.fViewSize.width = dimension.width + 10;
            bl = true;
        }
        if (bl) {
            this.setSize(this.fViewSize);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    static {
        String string;
        String string2 = System.getProperty("java.version");
        if (string2 == null) {
            string2 = "0.0";
        }
        boolean bl = wantSpecialUpdate = !(string = string2.substring(0, 3)).equals("1.0") && !string.equals("1.1");
        if (System.getProperty("CH.ifa.draw.specialUpdate") != null) {
            wantSpecialUpdate = Boolean.getBoolean("CH.ifa.draw.specialUpdate");
        }
    }
}

