/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.util.Animatable;

public class Animator
extends Thread {
    private DrawingView fView;
    private Animatable fAnimatable;
    private boolean fIsRunning;
    private static final int DELAY = 62;

    public Animator(Animatable animatable, DrawingView drawingView) {
        super("Animator");
        this.setPriority(1);
        this.fView = drawingView;
        this.fAnimatable = animatable;
    }

    public void start() {
        super.start();
        this.fIsRunning = true;
        this.fAnimatable.animationStart();
    }

    public void end() {
        this.fAnimatable.animationStop();
        this.fIsRunning = false;
    }

    public void run() {
        while (this.fIsRunning) {
            long l = System.currentTimeMillis();
            this.fView.freezeView();
            this.fAnimatable.animationStep();
            this.fView.checkDamage();
            this.fView.unfreezeView();
            try {
                Thread.sleep(Math.max(0L, (l += 62L) - System.currentTimeMillis()));
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

