/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.ColorEntry;
import java.awt.Color;

public class ColorMap {
    public static final Color NONE = new Color(16762782);
    public static final Color BACKGROUND = new Color(0xFEFEFE);
    static ColorEntry[] fMap = new ColorEntry[]{new ColorEntry("Black", Color.black), new ColorEntry("Blue", Color.blue), new ColorEntry("Green", Color.green), new ColorEntry("Red", Color.red), new ColorEntry("Pink", Color.pink), new ColorEntry("Magenta", Color.magenta), new ColorEntry("Orange", Color.orange), new ColorEntry("Yellow", Color.yellow), new ColorEntry("New Tan", new Color(15452062)), new ColorEntry("Aquamarine", new Color(7396243)), new ColorEntry("Sea Green", new Color(2330216)), new ColorEntry("Dark Gray", Color.darkGray), new ColorEntry("Light Gray", Color.lightGray), new ColorEntry("White", Color.white), new ColorEntry("None", NONE), new ColorEntry("Backgound", BACKGROUND)};

    public static int size() {
        return fMap.length;
    }

    public static Color color(int n) {
        if (n < ColorMap.size() && n >= 0) {
            return ColorMap.fMap[n].fColor;
        }
        throw new ArrayIndexOutOfBoundsException("Color index: " + n);
    }

    public static Color color(String string) {
        int n = 0;
        while (n < fMap.length) {
            if (ColorMap.fMap[n].fName.equals(string)) {
                return ColorMap.fMap[n].fColor;
            }
            ++n;
        }
        return Color.black;
    }

    public static String name(int n) {
        if (n < ColorMap.size() && n >= 0) {
            return ColorMap.fMap[n].fName;
        }
        throw new ArrayIndexOutOfBoundsException("Color index: " + n);
    }

    public static int colorIndex(Color color) {
        int n = 0;
        while (n < fMap.length) {
            if (ColorMap.fMap[n].fColor.equals(color)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public static boolean isTransparent(Color color) {
        return color.equals(NONE);
    }

    public static boolean isBackground(Color color) {
        return color.equals(BACKGROUND);
    }

    public static Color hilight(Color color) {
        if (ColorMap.isBackground(color)) {
            return Color.black;
        }
        if (color.equals(Color.black)) {
            return Color.red;
        }
        Color color2 = color.brighter();
        if (color2.equals(color)) {
            color2 = color.darker();
        }
        return color2;
    }
}

