/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class FloatingTextField {
    private TextArea fEditWidget = new TextArea("", 1, 20, 3);
    private Container fContainer;

    public void createOverlay(Container container) {
        this.createOverlay(container, null);
    }

    public void createOverlay(Container container, Font font) {
        container.add((Component)this.fEditWidget, 0);
        if (font != null) {
            this.fEditWidget.setFont(font);
        }
        this.fContainer = container;
    }

    public void setBounds(Rectangle rectangle, String string) {
        this.fEditWidget.setText(string);
        this.fEditWidget.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.fEditWidget.setVisible(true);
        this.fEditWidget.selectAll();
        this.fEditWidget.requestFocus();
    }

    public String getText() {
        return this.fEditWidget.getText();
    }

    public Dimension getPreferredSize(int n, int n2) {
        Dimension dimension = this.fEditWidget.getPreferredSize(n, n2);
        return new Dimension(dimension.width + 4, dimension.height + 4);
    }

    public void setCaretPosition(int n, int n2) {
        int n3 = FloatingTextField.position(this.fEditWidget.getText(), n, n2);
        this.fEditWidget.select(n3, n3);
        this.fEditWidget.setCaretPosition(n3);
    }

    private static int position(String string, int n, int n2) {
        int n3 = 0;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        while (--n > 0) {
            try {
                String string2 = bufferedReader.readLine();
                n3 += string2.length() + 1;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return n3 + n2 - 1;
    }

    public void endOverlay() {
        this.fContainer.requestFocus();
        if (this.fEditWidget == null) {
            return;
        }
        this.fEditWidget.setVisible(false);
        this.fContainer.remove(this.fEditWidget);
        Rectangle rectangle = this.fEditWidget.getBounds();
        this.fContainer.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

