/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.PaletteListener;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public abstract class PaletteButton
extends Canvas
implements MouseListener,
MouseMotionListener {
    static final int NORMAL = 1;
    static final int PRESSED = 2;
    static final int SELECTED = 3;
    private PaletteListener fListener;
    private int fState;
    private int fOldState;

    public PaletteButton(PaletteListener paletteListener) {
        this.fListener = paletteListener;
        this.fOldState = 1;
        this.fState = 1;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public abstract void paintBackground(Graphics var1);

    public abstract void paintNormal(Graphics var1);

    public abstract void paintPressed(Graphics var1);

    public abstract void paintSelected(Graphics var1);

    public Object value() {
        return null;
    }

    public String name() {
        return "";
    }

    public void reset() {
        this.fState = 1;
        this.repaint();
    }

    public void select() {
        this.fState = 3;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.fOldState = this.fState;
        this.fState = 2;
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.fState = this.contains(mouseEvent.getX(), mouseEvent.getY()) ? 2 : this.fOldState;
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.fState = this.fOldState;
        this.repaint();
        if (this.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.fListener.paletteUserSelected(this);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.fListener.paletteUserOver(this, true);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.fState == 2) {
            this.mouseDragged(mouseEvent);
        }
        this.fListener.paletteUserOver(this, false);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        switch (this.fState) {
            case 2: {
                this.paintPressed(graphics);
                return;
            }
            case 3: {
                this.paintSelected(graphics);
                return;
            }
        }
        this.paintNormal(graphics);
    }
}

