/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.Serializable;

public class PaletteLayout
implements LayoutManager {
    private int fGap;
    private Point fBorder;
    private boolean fVerticalLayout;

    public PaletteLayout(int n) {
        this(n, new Point(0, 0), true);
    }

    public PaletteLayout(int n, Point point) {
        this(n, point, true);
    }

    public PaletteLayout(int n, Point point, boolean bl) {
        this.fGap = n;
        this.fBorder = point;
        this.fVerticalLayout = bl;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public Dimension minimumLayoutSize(Container container) {
        Serializable serializable;
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            serializable = container.getComponent(n2);
            if (((Component)serializable).isVisible()) {
                Dimension dimension2 = ((Component)serializable).getMinimumSize();
                if (this.fVerticalLayout) {
                    dimension.width = Math.max(dimension.width, dimension2.width);
                    if (n2 > 0) {
                        dimension.height += this.fGap;
                    }
                    dimension.height += dimension2.height;
                } else {
                    dimension.height = Math.max(dimension.height, dimension2.height);
                    if (n2 > 0) {
                        dimension.width += this.fGap;
                    }
                    dimension.width += dimension2.width;
                }
            }
            ++n2;
        }
        serializable = container.getInsets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
        dimension.width += 2 * this.fBorder.x;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        dimension.height += 2 * this.fBorder.y;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = insets.left + this.fBorder.x;
        int n3 = insets.top + this.fBorder.y;
        int n4 = 0;
        while (n4 < n) {
            Component component = container.getComponent(n4);
            if (component.isVisible()) {
                Dimension dimension = component.getMinimumSize();
                component.setBounds(n2, n3, dimension.width, dimension.height);
                if (this.fVerticalLayout) {
                    n3 += dimension.height;
                    n3 += this.fGap;
                } else {
                    n2 += dimension.width;
                    n2 += this.fGap;
                }
            }
            ++n4;
        }
    }
}

