/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInOut;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class StorableOutput
extends StorableInOut {
    private PrintWriter fStream;
    private int fIndent;

    public StorableOutput(String string) throws IOException {
        this(string, new FileOutputStream(string));
    }

    public StorableOutput(OutputStream outputStream) {
        this(null, outputStream);
    }

    private StorableOutput(String string, OutputStream outputStream) {
        super(string);
        try {
            this.fStream = new PrintWriter(new OutputStreamWriter(outputStream, "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("UTF-8 not supported!");
            this.fStream = new PrintWriter(outputStream);
        }
        this.fIndent = 0;
    }

    public void writeStorable(Storable storable) {
        if (storable == null) {
            this.fStream.print("NULL");
            this.space();
            return;
        }
        if (this.mapped(storable)) {
            this.writeRef(storable);
            return;
        }
        this.incrementIndent();
        this.startNewLine();
        this.map(storable);
        this.fStream.print(storable.getClass().getName());
        this.space();
        storable.write(this);
        this.space();
        this.decrementIndent();
    }

    public void writeInt(int n) {
        this.fStream.print(n);
        this.space();
    }

    public void writeColor(Color color) {
        this.writeInt(color.getRed());
        this.writeInt(color.getGreen());
        this.writeInt(color.getBlue());
    }

    public void writeDouble(double d) {
        this.fStream.print(d);
        this.space();
    }

    public void writeBoolean(boolean bl) {
        if (bl) {
            this.fStream.print(1);
        } else {
            this.fStream.print(0);
        }
        this.space();
    }

    public void writeString(String string) {
        this.fStream.print('\"');
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\n': {
                    this.fStream.print('\\');
                    this.fStream.print('n');
                    break;
                }
                case '\"': {
                    this.fStream.print('\\');
                    this.fStream.print('\"');
                    break;
                }
                case '\\': {
                    this.fStream.print('\\');
                    this.fStream.print('\\');
                    break;
                }
                case '\t': {
                    this.fStream.print('\\');
                    this.fStream.print('\t');
                    break;
                }
                default: {
                    this.fStream.print(c);
                }
            }
            ++n;
        }
        this.fStream.print('\"');
        this.space();
    }

    public void close() {
        this.fStream.close();
    }

    private void writeRef(Storable storable) {
        int n = this.getRef(storable);
        this.fStream.print("REF");
        this.space();
        this.fStream.print(n);
        this.space();
    }

    private void incrementIndent() {
        this.fIndent += 4;
    }

    private void decrementIndent() {
        this.fIndent -= 4;
        if (this.fIndent < 0) {
            this.fIndent = 0;
        }
    }

    private void startNewLine() {
        this.fStream.println();
        int n = 0;
        while (n < this.fIndent) {
            this.space();
            ++n;
        }
    }

    private void space() {
        this.fStream.print(' ');
    }
}

