/*
 * Decompiled with CFR 0.152.
 */
package collections;

import collections.Bag;
import collections.CheckedCollection;
import collections.Collection;
import collections.CollectionEnumeration;
import collections.CorruptedEnumerationException;
import collections.IllegalElementException;
import collections.UpdatableBag;
import collections.UpdatableCollection;
import java.util.Enumeration;

public class CheckedBag
extends CheckedCollection
implements UpdatableBag {
    public CheckedBag(UpdatableBag updatableBag) {
        super(updatableBag);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new CheckedBag((UpdatableBag)this.thys.duplicate());
    }

    public UpdatableBag thys() {
        return (UpdatableBag)this.thys;
    }

    public UpdatableBag prev() {
        return (UpdatableBag)this.prev;
    }

    public synchronized void addIfAbsent(Object object) throws IllegalElementException {
        this.preCheck();
        try {
            this.thys().addIfAbsent(object);
            this.checkAdd(this.thys, this.prev, object, true, true);
            this.postCheck();
            return;
        }
        catch (IllegalElementException illegalElementException) {
            this.assert(!this.prev.canInclude(object));
            this.assert(this.thys.sameStructure(this.prev));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalElementException;
        }
    }

    public synchronized Bag addingIfAbsent(Object object) throws IllegalElementException {
        this.preCheck();
        try {
            Bag bag = this.thys().addingIfAbsent(object);
            this.checkAdd(bag, this.thys, object, true, false);
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            return bag;
        }
        catch (IllegalElementException illegalElementException) {
            this.assert(!this.prev.canInclude(object));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalElementException;
        }
    }

    public synchronized void add(Object object) throws IllegalElementException {
        this.preCheck();
        try {
            this.thys().add(object);
            this.checkAdd(this.thys, this.prev, object, false, true);
            this.postCheck();
            return;
        }
        catch (IllegalElementException illegalElementException) {
            this.assert(!this.prev.canInclude(object));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalElementException;
        }
    }

    public synchronized Bag adding(Object object) throws IllegalElementException {
        this.preCheck();
        try {
            Bag bag = this.thys().adding(object);
            this.checkAdd(bag, this.thys, object, false, false);
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            return bag;
        }
        catch (IllegalElementException illegalElementException) {
            this.assert(!this.prev.canInclude(object));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalElementException;
        }
    }

    public synchronized void addElements(Enumeration enumeration) throws IllegalElementException, CorruptedEnumerationException {
        this.preCheck();
        this.thys().addElements(enumeration);
        this.postCheck();
    }

    protected void checkAdd(Collection collection, Collection collection2, Object object, boolean bl, boolean bl2) {
        int n;
        this.assert(collection.canInclude(object));
        int n2 = collection2.occurrencesOf(object);
        int n3 = n2 + 1;
        if (bl && n2 != 0) {
            n3 = n2;
        }
        this.assert((n = collection.occurrencesOf(object)) == n3);
        this.assert(collection.size() == collection2.size() + (n3 - n2));
        if (bl2) {
            int n4 = ((UpdatableCollection)collection).version();
            this.assert(n4 == this.prevVersion == (n == n2));
        }
        CollectionEnumeration collectionEnumeration = collection2.elements();
        while (collectionEnumeration.hasMoreElements()) {
            Object e = collectionEnumeration.nextElement();
            this.assert(e.equals(object) || collection.occurrencesOf(e) == collection2.occurrencesOf(e));
        }
        collection.checkImplementation();
    }
}

