/*
 * Decompiled with CFR 0.152.
 */
package collections;

import collections.Collection;
import collections.CollectionEnumeration;
import collections.CorruptedEnumerationException;
import collections.IllegalElementException;
import collections.ImplementationError;
import collections.Set;
import collections.UpdatableCollection;
import java.util.Enumeration;
import java.util.NoSuchElementException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CheckedCollection
implements UpdatableCollection {
    public UpdatableCollection thys;
    public UpdatableCollection prev;
    public int prevVersion;

    public CheckedCollection(UpdatableCollection updatableCollection) {
        this.thys = updatableCollection;
        this.thys.checkImplementation();
    }

    protected Object clone() throws CloneNotSupportedException {
        return new CheckedCollection((UpdatableCollection)this.thys.duplicate());
    }

    public synchronized Collection duplicate() {
        Collection collection = null;
        try {
            collection = (Collection)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return collection;
    }

    protected void postCheck() {
        this.thys.checkImplementation();
        this.prev = null;
    }

    protected void preCheck() {
        this.prev = (UpdatableCollection)this.thys.duplicate();
        this.prevVersion = this.thys.version();
    }

    public synchronized boolean canInclude(Object object) {
        this.preCheck();
        boolean bl = this.thys.canInclude(object);
        this.assert(!bl || object != null);
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return bl;
    }

    public synchronized boolean isEmpty() {
        this.preCheck();
        boolean bl = this.thys.isEmpty();
        this.assert(bl == (this.thys.size() == 0));
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return bl;
    }

    public synchronized int size() {
        this.preCheck();
        int n = this.thys.size();
        this.assert(n >= 0);
        this.assert(n == 0 == this.thys.isEmpty());
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return n;
    }

    public synchronized int occurrencesOf(Object object) {
        this.preCheck();
        int n = this.thys.occurrencesOf(object);
        this.assert(n >= 0);
        this.assert(n <= this.thys.size());
        this.assert(this.thys.canInclude(object) || n == 0);
        this.assert(n != 0 || !this.thys.includes(object));
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return n;
    }

    public synchronized boolean includes(Object object) {
        this.preCheck();
        boolean bl = this.thys.includes(object);
        this.assert(bl == this.thys.occurrencesOf(object) >= 1);
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return bl;
    }

    public synchronized CollectionEnumeration elements() {
        int n = this.thys.size();
        CollectionEnumeration collectionEnumeration = this.thys.elements();
        while (collectionEnumeration.hasMoreElements()) {
            this.assert(collectionEnumeration.numberOfRemainingElements() == n);
            --n;
            Object e = collectionEnumeration.nextElement();
            this.assert(this.thys.includes(e));
        }
        this.postCheck();
        return this.thys.elements();
    }

    public synchronized boolean sameStructure(Collection collection) {
        boolean bl = this.thys.sameStructure(collection);
        this.postCheck();
        return bl;
    }

    public String toString() {
        String string = this.thys.toString();
        this.postCheck();
        return string;
    }

    public synchronized int version() {
        int n = this.thys.version();
        this.postCheck();
        return n;
    }

    public synchronized void clear() {
        this.preCheck();
        this.thys.clear();
        this.assert(this.thys.isEmpty());
        this.assert(this.thys.version() == this.prevVersion == this.prev.isEmpty());
        this.postCheck();
    }

    public synchronized void exclude(Object object) {
        this.preCheck();
        this.thys.exclude(object);
        this.checkRemove(this.thys, this.prev, object, true, true);
        this.postCheck();
    }

    public synchronized Collection excluding(Object object) {
        this.preCheck();
        Collection collection = this.thys.excluding(object);
        this.checkRemove(collection, this.thys, object, true, false);
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return collection;
    }

    public synchronized void removeOneOf(Object object) {
        this.preCheck();
        this.thys.removeOneOf(object);
        this.checkRemove(this.thys, this.prev, object, false, true);
        this.postCheck();
    }

    public synchronized Collection removingOneOf(Object object) {
        this.preCheck();
        Collection collection = this.thys.removingOneOf(object);
        this.checkRemove(collection, this.thys, object, false, false);
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return collection;
    }

    public synchronized void replaceOneOf(Object object, Object object2) throws IllegalElementException {
        this.preCheck();
        try {
            this.thys.replaceOneOf(object, object2);
            this.checkReplace(this.thys, this.prev, object, object2, false, true);
            this.postCheck();
            return;
        }
        catch (IllegalElementException illegalElementException) {
            this.assert(this.thys.includes(object) && !this.thys.canInclude(object2));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalElementException;
        }
    }

    public synchronized Collection replacingOneOf(Object object, Object object2) throws IllegalElementException {
        this.preCheck();
        try {
            Collection collection = this.thys.replacingOneOf(object, object2);
            this.checkReplace(collection, this.thys, object, object2, false, false);
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            return collection;
        }
        catch (IllegalElementException illegalElementException) {
            this.assert(this.thys.includes(object) && !this.thys.canInclude(object2));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalElementException;
        }
    }

    public synchronized void replaceAllOf(Object object, Object object2) throws IllegalElementException {
        this.preCheck();
        try {
            this.thys.replaceAllOf(object, object2);
            this.checkReplace(this.thys, this.prev, object, object2, true, true);
            this.postCheck();
            return;
        }
        catch (IllegalElementException illegalElementException) {
            this.assert(this.thys.includes(object) && !this.thys.canInclude(object2));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalElementException;
        }
    }

    public synchronized Collection replacingAllOf(Object object, Object object2) throws IllegalElementException {
        this.preCheck();
        try {
            Collection collection = this.thys.replacingAllOf(object, object2);
            this.checkReplace(collection, this.thys, object, object2, true, false);
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            return collection;
        }
        catch (IllegalElementException illegalElementException) {
            this.assert(this.thys.includes(object) && !this.thys.canInclude(object2));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalElementException;
        }
    }

    public Object take() throws NoSuchElementException {
        this.preCheck();
        try {
            Object object = this.thys.take();
            this.assert(object != null);
            this.checkRemove(this.thys, this.prev, object, false, true);
            this.postCheck();
            return object;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.assert(this.prev.isEmpty());
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw noSuchElementException;
        }
    }

    public synchronized void excludeElements(Enumeration enumeration) throws CorruptedEnumerationException {
        this.preCheck();
        this.thys.excludeElements(enumeration);
        this.postCheck();
    }

    public synchronized void removeElements(Enumeration enumeration) throws CorruptedEnumerationException {
        this.preCheck();
        this.thys.removeElements(enumeration);
        this.postCheck();
    }

    public void assert(boolean bl) throws ImplementationError {
        ImplementationError.assert(this.thys, bl);
    }

    public synchronized void checkImplementation() throws ImplementationError {
    }

    protected void checkRemove(Collection collection, Collection collection2, Object object, boolean bl, boolean bl2) {
        int n;
        int n2 = collection2.occurrencesOf(object);
        int n3 = 0;
        if (!bl && n2 > 1) {
            n3 = n2 - 1;
        }
        this.assert((n = collection.occurrencesOf(object)) == n3);
        this.assert(collection.size() == collection2.size() - (n2 - n));
        if (bl2) {
            int n4 = ((UpdatableCollection)collection).version();
            this.assert(n4 == this.prevVersion == (n2 == n));
        }
        CollectionEnumeration collectionEnumeration = collection2.elements();
        while (collectionEnumeration.hasMoreElements()) {
            Object e = collectionEnumeration.nextElement();
            this.assert(!e.equals(object) == (collection.occurrencesOf(e) == collection2.occurrencesOf(e)));
        }
        collection.checkImplementation();
    }

    protected void checkReplace(Collection collection, Collection collection2, Object object, Object object2, boolean bl, boolean bl2) {
        int n;
        int n2 = this.prev.occurrencesOf(object);
        if (!bl && n2 > 1) {
            n2 = 1;
        }
        if (object.equals(object2)) {
            n2 = 0;
        }
        this.assert(collection.occurrencesOf(object) == collection2.occurrencesOf(object) - n2);
        if (n2 != 0) {
            this.assert(collection.canInclude(object2));
        }
        if ((n = this.prev.occurrencesOf(object2) + n2) > 1 && collection instanceof Set) {
            n = 1;
        }
        this.assert(collection.occurrencesOf(object2) == n);
        if (bl2) {
            int n3 = ((UpdatableCollection)collection).version();
            this.assert(n3 != this.prevVersion || n2 == 0);
        }
        CollectionEnumeration collectionEnumeration = collection2.elements();
        while (collectionEnumeration.hasMoreElements()) {
            Object e = collectionEnumeration.nextElement();
            if (e.equals(object) || e.equals(object2)) continue;
            this.assert(collection.occurrencesOf(e) == collection2.occurrencesOf(e));
        }
        collection.checkImplementation();
    }
}

