/*
 * Decompiled with CFR 0.152.
 */
package collections;

import collections.CheckedCollection;
import collections.CollectionEnumeration;
import collections.IllegalElementException;
import collections.Map;
import collections.UpdatableCollection;
import collections.UpdatableMap;
import java.util.NoSuchElementException;

public class CheckedMap
extends CheckedCollection
implements UpdatableMap {
    public CheckedMap(UpdatableMap updatableMap) {
        super(updatableMap);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new CheckedMap((UpdatableMap)this.thys.duplicate());
    }

    public UpdatableMap thys() {
        return (UpdatableMap)this.thys;
    }

    public UpdatableMap prev() {
        return (UpdatableMap)this.prev;
    }

    public boolean canIncludeKey(Object object) {
        this.preCheck();
        boolean bl = this.thys().canIncludeKey(object);
        this.assert(!bl || object != null);
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return bl;
    }

    public synchronized boolean includesKey(Object object) {
        this.preCheck();
        boolean bl = this.thys().includesKey(object);
        this.assert(!bl || this.thys().canInclude(object));
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return bl;
    }

    public synchronized boolean includesAt(Object object, Object object2) {
        this.preCheck();
        boolean bl = this.thys().includesAt(object, object2);
        this.assert(!bl || this.thys().includesKey(object) && this.thys().includes(object2));
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return bl;
    }

    public synchronized CollectionEnumeration keys() {
        int n = this.thys().size();
        CollectionEnumeration collectionEnumeration = this.keys();
        while (collectionEnumeration.hasMoreElements()) {
            this.assert(collectionEnumeration.numberOfRemainingElements() == n);
            --n;
            Object e = collectionEnumeration.nextElement();
            Object object = this.thys().at(collectionEnumeration);
            this.assert(this.thys().canIncludeKey(e));
            this.assert(this.thys().canInclude(object));
            this.assert(this.thys().aKeyOf(object) != null);
            this.assert(this.thys().includesKey(e));
            this.assert(this.thys().includes(object));
            this.assert(this.thys().includesAt(collectionEnumeration, object));
        }
        this.postCheck();
        return this.thys().keys();
    }

    public synchronized Object at(Object object) throws NoSuchElementException {
        this.preCheck();
        try {
            Object object2 = this.thys().at(object);
            this.assert(this.thys().includesAt(object, object2));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            return object2;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.assert(!this.thys().includesKey(object));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw noSuchElementException;
        }
    }

    public synchronized Object aKeyOf(Object object) {
        this.preCheck();
        Object object2 = this.thys().aKeyOf(object);
        this.assert(object2 == null && !this.thys().includes(object) || this.thys().at(object2).equals(object));
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return object2;
    }

    public synchronized void putAt(Object object, Object object2) throws IllegalElementException {
        this.preCheck();
        try {
            this.thys().putAt(object, object2);
            this.checkPut(this.thys(), this.prev(), object, object2, true);
            this.postCheck();
            return;
        }
        catch (IllegalElementException illegalElementException) {
            this.assert(!this.canIncludeKey(object) || !this.canInclude(object2));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalElementException;
        }
    }

    public synchronized Map puttingAt(Object object, Object object2) throws IllegalElementException {
        this.preCheck();
        try {
            Map map = this.thys().puttingAt(object, object2);
            this.checkPut(map, this.thys(), object, object2, false);
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            return map;
        }
        catch (IllegalElementException illegalElementException) {
            this.assert(!this.canIncludeKey(object) || !this.canInclude(object2));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalElementException;
        }
    }

    public synchronized void removeAt(Object object) {
        this.preCheck();
        this.thys().removeAt(object);
        this.checkRemoveAt(this.thys(), this.prev(), object, true);
        this.postCheck();
    }

    public synchronized Map removingAt(Object object) {
        this.preCheck();
        Map map = this.thys().removingAt(object);
        this.checkRemoveAt(map, this.thys(), object, false);
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return map;
    }

    public synchronized void replaceElement(Object object, Object object2, Object object3) throws IllegalElementException {
        this.preCheck();
        try {
            this.thys().replaceElement(object, object2, object3);
            this.assert(!this.thys().includesAt(object, object2) || this.thys().includesAt(object, object3));
            this.assert(this.thys().size() == this.prev().size());
            this.assert(this.thys().version() != this.prevVersion || !this.prev().includesAt(object, object2));
            CollectionEnumeration collectionEnumeration = this.prev().keys();
            while (collectionEnumeration.hasMoreElements()) {
                Object e = collectionEnumeration.nextElement();
                this.assert(e.equals(object) || this.thys().includesAt(e, this.prev().at(e)));
            }
            this.postCheck();
            return;
        }
        catch (IllegalElementException illegalElementException) {
            this.assert(!this.canInclude(object3));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalElementException;
        }
    }

    protected void checkPut(Map map, Map map2, Object object, Object object2, boolean bl) {
        this.assert(map.canIncludeKey(object));
        this.assert(map.canInclude(object2));
        int n = map2.size();
        if (!map2.includesKey(object)) {
            ++n;
        }
        this.assert(map.includesAt(object, object2));
        this.assert(map.size() == n);
        CollectionEnumeration collectionEnumeration = map2.keys();
        while (collectionEnumeration.hasMoreElements()) {
            Object e = collectionEnumeration.nextElement();
            this.assert(e.equals(object) || map.includesAt(e, map2.at(e)));
        }
        if (bl) {
            int n2 = ((UpdatableCollection)((Object)map)).version();
            this.assert(n2 == this.prevVersion == map2.includesAt(object, object2));
        }
        map.checkImplementation();
    }

    protected void checkRemoveAt(Map map, Map map2, Object object, boolean bl) {
        int n = map2.size();
        if (map2.includesKey(object)) {
            --n;
        }
        this.assert(!map.includesKey(object));
        this.assert(map.size() == n);
        CollectionEnumeration collectionEnumeration = map2.keys();
        while (collectionEnumeration.hasMoreElements()) {
            Object e = collectionEnumeration.nextElement();
            this.assert(e.equals(object) || map.includesAt(e, map2.at(e)));
        }
        if (bl) {
            int n2 = ((UpdatableCollection)((Object)map)).version();
            this.assert(n2 == this.prevVersion == !map2.includesKey(object));
        }
        map.checkImplementation();
    }
}

