/*
 * Decompiled with CFR 0.152.
 */
package collections;

import collections.CheckedCollection;
import collections.CollectionEnumeration;
import collections.CorruptedEnumerationException;
import collections.IllegalElementException;
import collections.Seq;
import collections.UpdatableCollection;
import collections.UpdatableSeq;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class CheckedSeq
extends CheckedCollection
implements UpdatableSeq {
    public CheckedSeq(UpdatableSeq updatableSeq) {
        super(updatableSeq);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new CheckedSeq((UpdatableSeq)this.thys.duplicate());
    }

    public UpdatableSeq thys() {
        return (UpdatableSeq)this.thys;
    }

    public UpdatableSeq prev() {
        return (UpdatableSeq)this.prev;
    }

    public synchronized CollectionEnumeration elements() {
        int n = this.thys.size();
        CollectionEnumeration collectionEnumeration = this.thys.elements();
        int n2 = 0;
        while (collectionEnumeration.hasMoreElements()) {
            this.assert(collectionEnumeration.numberOfRemainingElements() == n);
            --n;
            Object e = collectionEnumeration.nextElement();
            this.assert(this.thys().at(n2).equals(e));
            this.assert(this.thys().firstIndexOf(e, n2) == n2);
            this.assert(this.thys().lastIndexOf(e, n2) == n2);
            this.assert(this.thys().firstIndexOf(e) <= n2);
            this.assert(this.thys().lastIndexOf(e) >= n2);
            ++n2;
        }
        this.postCheck();
        return this.thys.elements();
    }

    public synchronized Object at(int n) throws NoSuchElementException {
        this.preCheck();
        try {
            Object object = this.thys().at(n);
            this.assert(object != null);
            this.assert(this.thys.includes(object));
            this.assert(n >= 0 && n < this.thys.size());
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            return object;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.assert(n < 0 || n >= this.thys.size());
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw noSuchElementException;
        }
    }

    public synchronized Object first() throws NoSuchElementException {
        this.preCheck();
        try {
            Object object = this.thys().first();
            this.assert(object.equals(this.thys().at(0)));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            return object;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.assert(this.thys.isEmpty());
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw noSuchElementException;
        }
    }

    public synchronized Object last() throws NoSuchElementException {
        this.preCheck();
        try {
            Object object = this.thys().last();
            this.assert(object.equals(this.thys().at(this.thys.size() - 1)));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            return object;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.assert(this.thys.isEmpty());
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw noSuchElementException;
        }
    }

    public synchronized int firstIndexOf(Object object, int n) {
        this.preCheck();
        int n2 = this.thys().firstIndexOf(object, n);
        int n3 = n < 0 ? 0 : n;
        int n4 = n2;
        if (n4 < 0) {
            n4 = this.thys.size();
        }
        int n5 = n3;
        while (n5 < n4) {
            this.assert(!this.thys().at(n5).equals(object));
            ++n5;
        }
        if (n2 != -1) {
            this.assert(this.thys().at(n2).equals(object));
            this.assert(n2 >= n);
            this.assert(n2 < this.thys.size());
        }
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return n2;
    }

    public synchronized int firstIndexOf(Object object) {
        this.preCheck();
        int n = this.thys().firstIndexOf(object);
        this.assert(n == this.thys().firstIndexOf(object, 0));
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return n;
    }

    public synchronized int lastIndexOf(Object object, int n) {
        this.preCheck();
        int n2 = this.thys().lastIndexOf(object, n);
        int n3 = n2 + 1;
        if (n2 < 0) {
            n3 = 0;
        }
        int n4 = n3;
        while (n4 <= n) {
            this.assert(!this.thys().at(n4).equals(object));
            ++n4;
        }
        if (n2 != -1) {
            this.assert(this.thys().at(n2).equals(object));
            this.assert(n2 <= n);
            this.assert(n2 < this.thys.size());
        }
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return n2;
    }

    public synchronized int lastIndexOf(Object object) {
        this.preCheck();
        int n = this.thys().lastIndexOf(object);
        this.assert(n == this.thys().lastIndexOf(object, this.thys.size() - 1));
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return n;
    }

    public synchronized Seq subseq(int n, int n2) throws NoSuchElementException {
        this.preCheck();
        Seq seq = this.thys().subseq(n, n2);
        if (n2 <= 0) {
            this.assert(seq.isEmpty());
        } else {
            this.assert(seq.size() == n2);
            int n3 = 0;
            while (n3 < n2) {
                this.assert(seq.at(n3).equals(this.thys().at(n3 + n)));
                ++n3;
            }
        }
        seq.checkImplementation();
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        return seq;
    }

    public synchronized void insertAt(int n, Object object) throws IllegalElementException, NoSuchElementException {
        this.preCheck();
        try {
            this.thys().insertAt(n, object);
            this.checkInsert(this.thys(), this.prev(), n, object, true);
            this.postCheck();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.assert(!this.thys.canInclude(object));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalArgumentException;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.assert(n < 0 || n >= this.thys.size());
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw noSuchElementException;
        }
    }

    public synchronized Seq insertingAt(int n, Object object) throws IllegalElementException, NoSuchElementException {
        this.preCheck();
        try {
            Seq seq = this.thys().insertingAt(n, object);
            this.checkInsert(seq, this.thys(), n, object, false);
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            return seq;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.assert(!this.thys.canInclude(object));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalArgumentException;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.assert(n < 0 || n >= this.thys.size());
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw noSuchElementException;
        }
    }

    public synchronized void replaceAt(int n, Object object) throws IllegalElementException, NoSuchElementException {
        this.preCheck();
        try {
            this.thys().replaceAt(n, object);
            this.checkReplaceAt(this.thys(), this.prev(), n, object, true);
            this.postCheck();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.assert(!this.thys.canInclude(object));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalArgumentException;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.assert(n < 0 || n >= this.thys.size());
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw noSuchElementException;
        }
    }

    public synchronized Seq replacingAt(int n, Object object) throws IllegalElementException, NoSuchElementException {
        this.preCheck();
        try {
            Seq seq = this.thys().replacingAt(n, object);
            this.checkReplaceAt(seq, this.thys(), n, object, false);
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            return seq;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.assert(!this.thys.canInclude(object));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalArgumentException;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.assert(n < 0 || n >= this.thys.size());
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw noSuchElementException;
        }
    }

    public synchronized void removeAt(int n) throws NoSuchElementException {
        this.preCheck();
        try {
            this.thys().removeAt(n);
            this.checkRemoveAt(this.thys(), this.prev(), n, true);
            this.postCheck();
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.assert(n < 0 || n >= this.thys.size());
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw noSuchElementException;
        }
    }

    public synchronized Seq removingAt(int n) throws NoSuchElementException {
        this.preCheck();
        try {
            Seq seq = this.thys().removingAt(n);
            this.checkRemoveAt(seq, this.thys(), n, false);
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            return seq;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.assert(n < 0 || n >= this.thys.size());
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw noSuchElementException;
        }
    }

    public synchronized void insertFirst(Object object) throws IllegalElementException {
        this.preCheck();
        IllegalElementException illegalElementException = null;
        try {
            this.prev().insertAt(0, object);
        }
        catch (IllegalElementException illegalElementException2) {
            illegalElementException = illegalElementException2;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.assert(false);
        }
        try {
            this.thys().insertFirst(object);
        }
        catch (IllegalElementException illegalElementException3) {
            this.assert(illegalElementException != null);
        }
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        if (illegalElementException != null) {
            throw illegalElementException;
        }
    }

    public synchronized void replaceFirst(Object object) throws IllegalElementException, NoSuchElementException {
        this.preCheck();
        IllegalElementException illegalElementException = null;
        NoSuchElementException noSuchElementException = null;
        try {
            this.prev().replaceAt(0, object);
        }
        catch (IllegalElementException illegalElementException2) {
            illegalElementException = illegalElementException2;
        }
        catch (NoSuchElementException noSuchElementException2) {
            noSuchElementException = noSuchElementException2;
        }
        try {
            this.thys().replaceFirst(object);
        }
        catch (IllegalElementException illegalElementException3) {
            this.assert(illegalElementException != null);
        }
        catch (NoSuchElementException noSuchElementException3) {
            this.assert(noSuchElementException != null);
        }
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        if (illegalElementException != null) {
            throw illegalElementException;
        }
        if (noSuchElementException != null) {
            throw noSuchElementException;
        }
    }

    public synchronized void removeFirst() throws NoSuchElementException {
        this.preCheck();
        NoSuchElementException noSuchElementException = null;
        try {
            this.prev().removeAt(0);
        }
        catch (NoSuchElementException noSuchElementException2) {
            noSuchElementException = noSuchElementException2;
        }
        try {
            this.thys().removeFirst();
        }
        catch (IllegalElementException illegalElementException) {
            this.assert(noSuchElementException != null);
        }
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        if (noSuchElementException != null) {
            throw noSuchElementException;
        }
    }

    public synchronized void insertLast(Object object) throws IllegalElementException {
        this.preCheck();
        IllegalElementException illegalElementException = null;
        try {
            this.prev().insertAt(this.thys.size(), object);
        }
        catch (IllegalElementException illegalElementException2) {
            illegalElementException = illegalElementException2;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.assert(false);
        }
        try {
            this.thys().insertLast(object);
        }
        catch (IllegalElementException illegalElementException3) {
            this.assert(illegalElementException != null);
        }
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        if (illegalElementException != null) {
            throw illegalElementException;
        }
    }

    public synchronized void replaceLast(Object object) throws IllegalElementException, NoSuchElementException {
        this.preCheck();
        IllegalElementException illegalElementException = null;
        NoSuchElementException noSuchElementException = null;
        try {
            this.prev().replaceAt(this.thys.size() - 1, object);
        }
        catch (IllegalElementException illegalElementException2) {
            illegalElementException = illegalElementException2;
        }
        catch (NoSuchElementException noSuchElementException2) {
            noSuchElementException = noSuchElementException2;
        }
        try {
            this.thys().replaceLast(object);
        }
        catch (IllegalElementException illegalElementException3) {
            this.assert(illegalElementException != null);
        }
        catch (NoSuchElementException noSuchElementException3) {
            this.assert(noSuchElementException != null);
        }
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        if (illegalElementException != null) {
            throw illegalElementException;
        }
        if (noSuchElementException != null) {
            throw noSuchElementException;
        }
    }

    public synchronized void removeLast() throws NoSuchElementException {
        this.preCheck();
        NoSuchElementException noSuchElementException = null;
        try {
            this.prev().removeAt(this.thys.size() - 1);
        }
        catch (NoSuchElementException noSuchElementException2) {
            noSuchElementException = noSuchElementException2;
        }
        try {
            this.thys().removeLast();
        }
        catch (IllegalElementException illegalElementException) {
            this.assert(noSuchElementException != null);
        }
        this.assert(this.thys.sameStructure(this.prev));
        this.postCheck();
        if (noSuchElementException != null) {
            throw noSuchElementException;
        }
    }

    public synchronized void removeFromTo(int n, int n2) throws NoSuchElementException {
        this.preCheck();
        try {
            this.thys().removeFromTo(n, n2);
            int n3 = n2 - n + 1;
            if (n3 < 0) {
                n3 = 0;
            }
            this.assert(this.thys.size() == this.prev.size() - n3);
            this.assert(n >= 0 && n < this.prev.size());
            this.assert(n2 >= 0 && n2 < this.prev.size());
            this.assert(this.thys.version() != this.prevVersion || n3 <= 0);
            int n4 = 0;
            while (n4 < n) {
                this.assert(this.thys().at(n4).equals(this.prev().at(n4)));
                ++n4;
            }
            int n5 = n;
            while (n5 < this.thys.size()) {
                this.assert(this.thys().at(n5).equals(this.prev().at(n5 + n3)));
                ++n5;
            }
            this.postCheck();
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.assert(n < 0 || n >= this.thys.size() || n2 < 0 || n2 >= this.thys.size());
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw noSuchElementException;
        }
    }

    public synchronized void insertElementsAt(int n, Enumeration enumeration) throws IllegalElementException, CorruptedEnumerationException, NoSuchElementException {
        this.preCheck();
        try {
            int n2 = -1;
            if (enumeration instanceof CollectionEnumeration) {
                n2 = ((CollectionEnumeration)enumeration).numberOfRemainingElements();
            }
            this.thys().insertElementsAt(n, enumeration);
            if (n2 < 0) {
                n2 = this.thys.size() - this.prev.size();
            }
            this.assert(this.thys.size() == this.prev.size() + n2);
            this.assert(!enumeration.hasMoreElements());
            this.assert(n >= 0 && n < this.prev.size());
            this.assert(this.thys.version() != this.prevVersion || n2 <= 0);
            int n3 = 0;
            while (n3 < n) {
                this.assert(this.thys().at(n3).equals(this.prev().at(n3)));
                ++n3;
            }
            int n4 = n + n2;
            while (n4 < this.thys.size()) {
                this.assert(this.thys().at(n4).equals(this.prev().at(n4 - n2)));
                ++n4;
            }
            this.postCheck();
            return;
        }
        catch (CorruptedEnumerationException corruptedEnumerationException) {
            this.postCheck();
            throw corruptedEnumerationException;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.assert(n < 0 || n >= this.thys.size());
            this.assert(this.thys.sameStructure(this.prev));
            throw noSuchElementException;
        }
        catch (IllegalElementException illegalElementException) {
            this.postCheck();
            throw illegalElementException;
        }
    }

    public synchronized void prependElements(Enumeration enumeration) throws IllegalElementException, CorruptedEnumerationException {
        this.preCheck();
        try {
            int n = -1;
            if (enumeration instanceof CollectionEnumeration) {
                n = ((CollectionEnumeration)enumeration).numberOfRemainingElements();
            }
            this.thys().prependElements(enumeration);
            if (n < 0) {
                n = this.thys.size() - this.prev.size();
            }
            this.thys().prependElements(enumeration);
            this.assert(this.thys.size() == this.prev.size() + n);
            this.assert(!enumeration.hasMoreElements());
            this.assert(this.thys.version() != this.prevVersion || n <= 0);
            int n2 = n;
            while (n2 < this.thys.size()) {
                this.assert(this.thys().at(n2).equals(this.prev().at(n2 - n)));
                ++n2;
            }
            this.postCheck();
            return;
        }
        catch (IllegalElementException illegalElementException) {
            this.postCheck();
            throw illegalElementException;
        }
        catch (CorruptedEnumerationException corruptedEnumerationException) {
            this.postCheck();
            throw corruptedEnumerationException;
        }
    }

    public synchronized void appendElements(Enumeration enumeration) throws IllegalElementException, CorruptedEnumerationException {
        this.preCheck();
        try {
            int n = -1;
            if (enumeration instanceof CollectionEnumeration) {
                n = ((CollectionEnumeration)enumeration).numberOfRemainingElements();
            }
            this.thys().appendElements(enumeration);
            if (n < 0) {
                n = this.thys.size() - this.prev.size();
            }
            this.assert(this.thys.size() == this.prev.size() + n);
            this.assert(!enumeration.hasMoreElements());
            this.assert(this.thys.version() != this.prevVersion || n <= 0);
            int n2 = 0;
            while (n2 < this.prev.size()) {
                this.assert(this.thys().at(n2).equals(this.prev().at(n2)));
                ++n2;
            }
            this.postCheck();
            return;
        }
        catch (IllegalElementException illegalElementException) {
            this.postCheck();
            throw illegalElementException;
        }
        catch (CorruptedEnumerationException corruptedEnumerationException) {
            this.postCheck();
            throw corruptedEnumerationException;
        }
    }

    protected void checkInsert(Seq seq, Seq seq2, int n, Object object, boolean bl) {
        this.assert(seq.canInclude(object));
        this.assert(seq.size() == seq2.size() + 1);
        this.assert(n >= 0 && n < seq.size());
        this.assert(seq.at(n).equals(object));
        int n2 = 0;
        while (n2 < n) {
            this.assert(seq.at(n2).equals(seq2.at(n2)));
            ++n2;
        }
        int n3 = n + 1;
        while (n3 < this.thys.size()) {
            this.assert(seq.at(n3).equals(seq2.at(n3 - 1)));
            ++n3;
        }
        if (bl) {
            int n4 = ((UpdatableCollection)((Object)seq)).version();
            this.assert(n4 != this.prevVersion);
        }
        seq.checkImplementation();
    }

    protected void checkReplaceAt(Seq seq, Seq seq2, int n, Object object, boolean bl) {
        this.assert(seq.canInclude(object));
        this.assert(seq.size() == seq2.size());
        this.assert(n >= 0 && n < seq.size());
        this.assert(seq.at(n).equals(object));
        int n2 = 0;
        while (n2 < n) {
            this.assert(seq.at(n2).equals(seq2.at(n2)));
            ++n2;
        }
        int n3 = n + 1;
        while (n3 < seq.size()) {
            this.assert(seq.at(n3).equals(seq2.at(n3)));
            ++n3;
        }
        if (bl) {
            int n4 = ((UpdatableCollection)((Object)seq)).version();
            this.assert(n4 != this.prevVersion || seq.at(n).equals(seq2.at(n)));
        }
        seq.checkImplementation();
    }

    protected void checkRemoveAt(Seq seq, Seq seq2, int n, boolean bl) {
        this.assert(seq.size() == seq2.size() - 1);
        this.assert(n >= 0 && n < seq2.size());
        int n2 = 0;
        while (n2 < n) {
            this.assert(seq.at(n2).equals(seq2.at(n2)));
            ++n2;
        }
        int n3 = n;
        while (n3 < seq.size()) {
            this.assert(seq.at(n3).equals(seq2.at(n3 + 1)));
            ++n3;
        }
        if (bl) {
            int n4 = ((UpdatableCollection)((Object)seq)).version();
            this.assert(n4 != this.prevVersion);
        }
        seq.checkImplementation();
    }
}

