/*
 * Decompiled with CFR 0.152.
 */
package collections;

import collections.CheckedCollection;
import collections.Collection;
import collections.CollectionEnumeration;
import collections.CorruptedEnumerationException;
import collections.IllegalElementException;
import collections.Set;
import collections.UpdatableCollection;
import collections.UpdatableSet;
import java.util.Enumeration;

public class CheckedSet
extends CheckedCollection
implements UpdatableSet {
    public CheckedSet(UpdatableSet updatableSet) {
        super(updatableSet);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new CheckedSet((UpdatableSet)this.thys.duplicate());
    }

    public UpdatableSet thys() {
        return (UpdatableSet)this.thys;
    }

    public UpdatableSet prev() {
        return (UpdatableSet)this.prev;
    }

    public synchronized void include(Object object) throws IllegalElementException {
        this.preCheck();
        try {
            this.thys().include(object);
            this.checkInclude(this.thys, this.prev, object, true);
            this.postCheck();
            return;
        }
        catch (IllegalElementException illegalElementException) {
            this.assert(!this.prev.canInclude(object));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalElementException;
        }
    }

    public synchronized Set including(Object object) throws IllegalElementException {
        this.preCheck();
        try {
            Set set = this.thys().including(object);
            this.checkInclude(set, this.thys, object, false);
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            return set;
        }
        catch (IllegalElementException illegalElementException) {
            this.assert(!this.prev.canInclude(object));
            this.assert(this.thys.sameStructure(this.prev));
            this.postCheck();
            throw illegalElementException;
        }
    }

    public synchronized void includeElements(Enumeration enumeration) throws IllegalElementException, CorruptedEnumerationException {
        this.preCheck();
        this.thys().includeElements(enumeration);
        this.postCheck();
    }

    protected void checkInclude(Collection collection, Collection collection2, Object object, boolean bl) {
        this.assert(collection.canInclude(object));
        this.assert(collection.occurrencesOf(object) == 1);
        if (bl) {
            int n = ((UpdatableCollection)collection).version();
            this.assert(n == this.prevVersion == collection2.includes(object));
        }
        CollectionEnumeration collectionEnumeration = collection2.elements();
        while (collectionEnumeration.hasMoreElements()) {
            Object e = collectionEnumeration.nextElement();
            this.assert(collection.occurrencesOf(e) == 1);
        }
        collection.checkImplementation();
    }
}

