/*
 * Decompiled with CFR 0.152.
 */
package collections;

import collections.CLCell;
import collections.CLEnumeration;
import collections.CollectionEnumeration;
import collections.CorruptedEnumerationException;
import collections.IllegalElementException;
import collections.ImplementationError;
import collections.Predicate;
import collections.Seq;
import collections.UpdatableSeq;
import collections.UpdatableSeqImpl;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class CircularList
extends UpdatableSeqImpl
implements UpdatableSeq {
    protected CLCell list_;

    public CircularList() {
        this(null, null, 0);
    }

    public CircularList(Predicate predicate) {
        this(predicate, null, 0);
    }

    protected CircularList(Predicate predicate, CLCell cLCell, int n) {
        super(predicate);
        this.list_ = cLCell;
        this.count_ = n;
    }

    protected Object clone() throws CloneNotSupportedException {
        if (this.list_ == null) {
            return new CircularList(this.screener_, null, 0);
        }
        return new CircularList(this.screener_, this.list_.copyList(), this.count_);
    }

    public synchronized boolean includes(Object object) {
        if (object == null || this.list_ == null) {
            return false;
        }
        return this.list_.find(object) != null;
    }

    public synchronized int occurrencesOf(Object object) {
        if (object == null || this.list_ == null) {
            return 0;
        }
        return this.list_.count(object);
    }

    public synchronized CollectionEnumeration elements() {
        return new CLEnumeration(this, this.list_);
    }

    public synchronized Object first() throws NoSuchElementException {
        return this.firstCell().element();
    }

    public synchronized Object last() throws NoSuchElementException {
        return this.lastCell().element();
    }

    public synchronized Object at(int n) throws NoSuchElementException {
        return this.cellAt(n).element();
    }

    public synchronized int firstIndexOf(Object object, int n) {
        CLCell cLCell;
        if (n < 0) {
            n = 0;
        }
        if ((cLCell = this.list_) == null || object == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < n || !cLCell.element().equals(object)) {
            if ((cLCell = cLCell.next()) == this.list_) {
                return -1;
            }
            ++n2;
        }
        return n2;
    }

    public synchronized int lastIndexOf(Object object, int n) {
        if (object == null || this.count_ == 0) {
            return -1;
        }
        if (n >= this.size()) {
            n = this.size() - 1;
        }
        if (n < 0) {
            n = 0;
        }
        CLCell cLCell = this.cellAt(n);
        int n2 = n;
        while (!cLCell.element().equals(object)) {
            if (cLCell == this.list_) {
                return -1;
            }
            cLCell = cLCell.prev();
            --n2;
        }
        return n2;
    }

    public synchronized int firstIndexOf(Object object) {
        return this.firstIndexOf(object, 0);
    }

    public synchronized int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.size() - 1);
    }

    public synchronized Seq subseq(int n, int n2) throws NoSuchElementException {
        if (n2 > 0) {
            CLCell cLCell;
            this.checkIndex(n);
            CLCell cLCell2 = this.cellAt(n);
            CLCell cLCell3 = cLCell = new CLCell(cLCell2.element());
            int n3 = 1;
            while (n3 < n2) {
                if ((cLCell2 = cLCell2.next()) == null) {
                    this.checkIndex(n + n3);
                }
                cLCell3.addNext(cLCell2.element());
                cLCell3 = cLCell3.next();
                ++n3;
            }
            return new CircularList(this.screener_, cLCell, n2);
        }
        return new CircularList();
    }

    public synchronized void clear() {
        this.list_ = null;
        this.setCount(0);
    }

    public synchronized void exclude(Object object) {
        this.remove_(object, true);
    }

    public synchronized void removeOneOf(Object object) {
        this.remove_(object, false);
    }

    public synchronized void replaceOneOf(Object object, Object object2) throws IllegalElementException {
        this.replace_(object, object2, false);
    }

    public synchronized void replaceAllOf(Object object, Object object2) throws IllegalElementException {
        this.replace_(object, object2, true);
    }

    public synchronized Object take() throws NoSuchElementException {
        Object object = this.last();
        this.removeLast();
        return object;
    }

    public synchronized void insertFirst(Object object) throws IllegalElementException {
        this.checkElement(object);
        this.list_ = this.list_ == null ? new CLCell(object) : this.list_.addPrev(object);
        this.incCount();
    }

    public synchronized void replaceFirst(Object object) throws IllegalElementException {
        this.checkElement(object);
        this.firstCell().element(object);
        this.incVersion();
    }

    public synchronized void removeFirst() throws NoSuchElementException {
        if (this.firstCell().isSingleton()) {
            this.list_ = null;
        } else {
            CLCell cLCell = this.list_.next();
            this.list_.unlink();
            this.list_ = cLCell;
        }
        this.decCount();
    }

    public synchronized void insertLast(Object object) throws IllegalElementException {
        if (this.list_ == null) {
            this.insertFirst(object);
            return;
        }
        this.checkElement(object);
        this.list_.prev().addNext(object);
        this.incCount();
    }

    public synchronized void replaceLast(Object object) throws IllegalElementException, NoSuchElementException {
        this.checkElement(object);
        this.lastCell().element(object);
        this.incVersion();
    }

    public synchronized void removeLast() throws NoSuchElementException {
        CLCell cLCell = this.lastCell();
        if (cLCell == this.list_) {
            this.list_ = null;
        } else {
            cLCell.unlink();
        }
        this.decCount();
    }

    public synchronized void insertAt(int n, Object object) throws IllegalElementException, NoSuchElementException {
        if (n == 0) {
            this.insertFirst(object);
            return;
        }
        this.checkElement(object);
        this.cellAt(n - 1).addNext(object);
        this.incCount();
    }

    public synchronized void replaceAt(int n, Object object) throws IllegalElementException, NoSuchElementException {
        this.checkElement(object);
        this.cellAt(n).element(object);
        this.incVersion();
    }

    public synchronized void removeAt(int n) throws NoSuchElementException {
        if (n == 0) {
            this.removeFirst();
            return;
        }
        this.cellAt(n - 1).unlinkNext();
        this.decCount();
    }

    public synchronized void prependElements(Enumeration enumeration) throws IllegalElementException, CorruptedEnumerationException {
        Object object;
        CLCell cLCell = null;
        CLCell cLCell2 = null;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            this.checkElement(object);
            this.incCount();
            if (cLCell == null) {
                cLCell2 = cLCell = new CLCell(object);
                continue;
            }
            cLCell2.addNext(object);
            cLCell2 = cLCell2.next();
        }
        if (this.list_ == null) {
            this.list_ = cLCell;
            return;
        }
        if (cLCell != null) {
            object = this.list_.prev();
            cLCell2.next(this.list_);
            this.list_.prev(cLCell2);
            ((CLCell)object).next(cLCell);
            cLCell.prev((CLCell)object);
            this.list_ = cLCell;
        }
    }

    public synchronized void appendElements(Enumeration enumeration) throws IllegalElementException, CorruptedEnumerationException {
        if (this.list_ == null) {
            this.prependElements(enumeration);
            return;
        }
        CLCell cLCell = this.list_.prev();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.checkElement(e);
            this.incCount();
            cLCell.addNext(e);
            cLCell = cLCell.next();
        }
    }

    public synchronized void insertElementsAt(int n, Enumeration enumeration) throws IllegalElementException, CorruptedEnumerationException, NoSuchElementException {
        if (this.list_ == null || n == 0) {
            this.prependElements(enumeration);
            return;
        }
        CLCell cLCell = this.cellAt(n - 1);
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.checkElement(e);
            this.incCount();
            cLCell.addNext(e);
            cLCell = cLCell.next();
        }
    }

    public synchronized void removeFromTo(int n, int n2) throws NoSuchElementException {
        this.checkIndex(n2);
        CLCell cLCell = this.cellAt(n);
        CLCell cLCell2 = this.list_.prev();
        int n3 = n;
        while (n3 <= n2) {
            this.decCount();
            CLCell cLCell3 = cLCell.next();
            cLCell.unlink();
            if (cLCell == this.list_) {
                if (cLCell == cLCell2) {
                    this.list_ = null;
                    return;
                }
                this.list_ = cLCell3;
            }
            cLCell = cLCell3;
            ++n3;
        }
    }

    private CLCell firstCell() throws NoSuchElementException {
        if (this.list_ != null) {
            return this.list_;
        }
        this.checkIndex(0);
        return null;
    }

    private CLCell lastCell() throws NoSuchElementException {
        if (this.list_ != null) {
            return this.list_.prev();
        }
        this.checkIndex(0);
        return null;
    }

    private CLCell cellAt(int n) throws NoSuchElementException {
        this.checkIndex(n);
        return this.list_.nth(n);
    }

    private void remove_(Object object, boolean bl) throws IllegalElementException {
        if (object == null || this.list_ == null) {
            return;
        }
        CLCell cLCell = this.list_;
        while (true) {
            CLCell cLCell2 = cLCell.next();
            if (cLCell.element().equals(object)) {
                this.decCount();
                cLCell.unlink();
                if (cLCell == this.list_) {
                    if (cLCell == cLCell2) {
                        this.list_ = null;
                        return;
                    }
                    this.list_ = cLCell2;
                }
                if (!bl) {
                    return;
                }
                cLCell = cLCell2;
                continue;
            }
            if (cLCell2 == this.list_) {
                return;
            }
            cLCell = cLCell2;
        }
    }

    private void replace_(Object object, Object object2, boolean bl) throws IllegalElementException {
        if (object == null || this.list_ == null) {
            return;
        }
        CLCell cLCell = this.list_;
        do {
            if (!cLCell.element().equals(object)) continue;
            this.checkElement(object2);
            this.incVersion();
            cLCell.element(object2);
            if (bl) continue;
            return;
        } while ((cLCell = cLCell.next()) != this.list_);
    }

    public synchronized void checkImplementation() throws ImplementationError {
        super.checkImplementation();
        this.assert(this.count_ == 0 == (this.list_ == null));
        this.assert(this.list_ == null || this.list_.length() == this.count_);
        if (this.list_ == null) {
            return;
        }
        int n = 0;
        CLCell cLCell = this.list_;
        do {
            this.assert(cLCell.prev().next() == cLCell);
            this.assert(cLCell.next().prev() == cLCell);
            this.assert(this.canInclude(cLCell.element()));
            this.assert(this.occurrencesOf(cLCell.element()) > 0);
            this.assert(this.includes(cLCell.element()));
            cLCell = cLCell.next();
            ++n;
        } while (cLCell != this.list_);
        this.assert(n == this.count_);
    }
}

