/*
 * Decompiled with CFR 0.152.
 */
package collections;

import collections.CollectionEnumeration;
import collections.Comparator;
import collections.CorruptedEnumerationException;
import collections.DAEnumeration;
import collections.IllegalElementException;
import collections.ImplementationError;
import collections.Predicate;
import collections.Seq;
import collections.SortableCollection;
import collections.UpdatableSeq;
import collections.UpdatableSeqImpl;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Dynarray
extends UpdatableSeqImpl
implements UpdatableSeq,
SortableCollection {
    public static final int minCapacity = 16;
    protected Object[] array_;

    public Dynarray() {
        this(null, null, 0);
    }

    public Dynarray(Predicate predicate) {
        this(predicate, null, 0);
    }

    protected Dynarray(Predicate predicate, Object[] objectArray, int n) {
        super(predicate);
        this.array_ = objectArray;
        this.count_ = n;
    }

    protected Object clone() throws CloneNotSupportedException {
        int n = this.count_;
        if (n == 0) {
            return new Dynarray(this.screener_, null, 0);
        }
        if (n < 16) {
            n = 16;
        }
        Object[] objectArray = new Object[n];
        System.arraycopy(this.array_, 0, objectArray, 0, this.count_);
        return new Dynarray(this.screener_, objectArray, this.count_);
    }

    public synchronized int capacity() {
        if (this.array_ == null) {
            return 0;
        }
        return this.array_.length;
    }

    public synchronized void capacity(int n) {
        if (n < this.count_) {
            n = this.count_;
        }
        if (n == 0) {
            this.clear();
            return;
        }
        if (this.array_ == null) {
            this.array_ = new Object[n];
            this.incVersion();
            return;
        }
        if (n != this.array_.length) {
            Object[] objectArray = new Object[n];
            System.arraycopy(this.array_, 0, objectArray, 0, this.count_);
            this.array_ = objectArray;
            this.incVersion();
        }
    }

    public synchronized boolean includes(Object object) {
        if (object == null) {
            return false;
        }
        int n = 0;
        while (n < this.count_) {
            if (this.array_[n].equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized int occurrencesOf(Object object) {
        if (object == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.count_) {
            if (this.array_[n2].equals(object)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public synchronized CollectionEnumeration elements() {
        return new DAEnumeration(this, this.array_);
    }

    public synchronized Object first() throws NoSuchElementException {
        this.checkIndex(0);
        return this.array_[0];
    }

    public synchronized Object last() throws NoSuchElementException {
        this.checkIndex(this.count_ - 1);
        return this.array_[this.count_ - 1];
    }

    public synchronized Object at(int n) throws NoSuchElementException {
        this.checkIndex(n);
        return this.array_[n];
    }

    public synchronized int firstIndexOf(Object object, int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = n;
        while (n2 < this.count_) {
            if (this.array_[n2].equals(object)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public synchronized int lastIndexOf(Object object, int n) {
        if (n >= this.count_) {
            n = this.count_ - 1;
        }
        int n2 = n;
        while (n2 >= 0) {
            if (this.array_[n2].equals(object)) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public synchronized int firstIndexOf(Object object) {
        return this.firstIndexOf(object, 0);
    }

    public synchronized int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.size() - 1);
    }

    public synchronized Seq subseq(int n, int n2) throws NoSuchElementException {
        if (n2 > 0) {
            this.checkIndex(n);
            this.checkIndex(n + n2 - 1);
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.array_, n, objectArray, 0, n2);
            return new Dynarray(this.screener_, objectArray, n2);
        }
        return new Dynarray(this.screener_);
    }

    public synchronized void clear() {
        this.array_ = null;
        this.setCount(0);
    }

    public synchronized void removeOneOf(Object object) {
        this.remove_(object, false);
    }

    public synchronized void replaceOneOf(Object object, Object object2) throws IllegalElementException {
        this.replace_(object, object2, false);
    }

    public synchronized void replaceAllOf(Object object, Object object2) throws IllegalElementException {
        this.replace_(object, object2, true);
    }

    public synchronized void exclude(Object object) {
        this.remove_(object, true);
    }

    public synchronized Object take() throws NoSuchElementException {
        Object object = this.last();
        this.removeLast();
        return object;
    }

    public void sort(Comparator comparator) {
        if (this.count_ > 0) {
            Dynarray.quickSort(this.array_, 0, this.count_ - 1, comparator);
            this.incVersion();
        }
    }

    public synchronized void insertFirst(Object object) throws IllegalElementException {
        this.checkElement(object);
        this.growBy_(1);
        int n = this.count_ - 1;
        while (n > 0) {
            this.array_[n] = this.array_[n - 1];
            --n;
        }
        this.array_[0] = object;
    }

    public synchronized void replaceFirst(Object object) throws IllegalElementException {
        this.checkElement(object);
        this.array_[0] = object;
        this.incVersion();
    }

    public synchronized void removeFirst() throws NoSuchElementException {
        this.removeAt(0);
    }

    public synchronized void insertLast(Object object) throws IllegalElementException {
        this.checkElement(object);
        int n = this.count_;
        this.growBy_(1);
        this.array_[n] = object;
    }

    public synchronized void replaceLast(Object object) throws IllegalElementException, NoSuchElementException {
        this.checkElement(object);
        this.array_[this.count_ - 1] = object;
        this.incVersion();
    }

    public synchronized void removeLast() throws NoSuchElementException {
        this.checkIndex(0);
        this.array_[this.count_ - 1] = null;
        this.growBy_(-1);
    }

    public synchronized void insertAt(int n, Object object) throws IllegalElementException, NoSuchElementException {
        if (n != this.count_) {
            this.checkIndex(n);
        }
        this.checkElement(object);
        this.growBy_(1);
        int n2 = this.count_ - 1;
        while (n2 > n) {
            this.array_[n2] = this.array_[n2 - 1];
            --n2;
        }
        this.array_[n] = object;
    }

    public synchronized void removeAt(int n) throws NoSuchElementException {
        this.checkIndex(n);
        int n2 = n + 1;
        while (n2 < this.count_) {
            this.array_[n2 - 1] = this.array_[n2];
            ++n2;
        }
        this.array_[this.count_ - 1] = null;
        this.growBy_(-1);
    }

    public synchronized void replaceAt(int n, Object object) throws IllegalElementException, NoSuchElementException {
        this.checkIndex(n);
        this.checkElement(object);
        this.array_[n] = object;
        this.incVersion();
    }

    public synchronized void prependElements(Enumeration enumeration) throws IllegalElementException, CorruptedEnumerationException {
        this.insertElementsAt_(0, enumeration);
    }

    public synchronized void appendElements(Enumeration enumeration) throws IllegalElementException, CorruptedEnumerationException {
        this.insertElementsAt_(this.count_, enumeration);
    }

    public synchronized void insertElementsAt(int n, Enumeration enumeration) throws IllegalElementException, CorruptedEnumerationException, NoSuchElementException {
        if (n != this.count_) {
            this.checkIndex(n);
        }
        this.insertElementsAt_(n, enumeration);
    }

    public synchronized void removeFromTo(int n, int n2) throws NoSuchElementException {
        this.checkIndex(n);
        this.checkIndex(n2);
        if (n <= n2) {
            int n3 = n2 - n + 1;
            int n4 = n;
            int n5 = n2 + 1;
            while (n5 < this.count_) {
                this.array_[n4++] = this.array_[n5];
                ++n5;
            }
            int n6 = 1;
            while (n6 <= n3) {
                this.array_[this.count_ - n6] = null;
                ++n6;
            }
            this.addToCount(-n3);
        }
    }

    public static void quickSort(Object[] objectArray, int n, int n2, Comparator comparator) {
        int n3;
        int n4;
        Object object;
        if (n >= n2) {
            return;
        }
        int n5 = (n + n2) / 2;
        if (comparator.compare(objectArray[n], objectArray[n5]) > 0) {
            object = objectArray[n];
            objectArray[n] = objectArray[n5];
            objectArray[n5] = object;
        }
        if (comparator.compare(objectArray[n5], objectArray[n2]) > 0) {
            object = objectArray[n5];
            objectArray[n5] = objectArray[n2];
            objectArray[n2] = object;
            if (comparator.compare(objectArray[n], objectArray[n5]) > 0) {
                Object object2 = objectArray[n];
                objectArray[n] = objectArray[n5];
                objectArray[n5] = object2;
            }
        }
        if ((n4 = n + 1) >= (n3 = n2 - 1)) {
            return;
        }
        Object object3 = objectArray[n5];
        while (true) {
            if (comparator.compare(objectArray[n3], object3) > 0) {
                --n3;
                continue;
            }
            while (n4 < n3 && comparator.compare(objectArray[n4], object3) <= 0) {
                ++n4;
            }
            if (n4 >= n3) break;
            Object object4 = objectArray[n4];
            objectArray[n4] = objectArray[n3];
            objectArray[n3] = object4;
            --n3;
        }
        Dynarray.quickSort(objectArray, n, n4, comparator);
        Dynarray.quickSort(objectArray, n4 + 1, n2, comparator);
    }

    private void growBy_(int n) {
        int n2 = this.count_ + n;
        if (n > 0) {
            int n3 = this.capacity();
            if (n2 > n3) {
                this.incVersion();
                int n4 = n2 + (n2 + 16) / 2;
                if (n4 < 16) {
                    n4 = 16;
                }
                if (this.array_ == null) {
                    this.array_ = new Object[n4];
                } else {
                    Object[] objectArray = new Object[n4];
                    System.arraycopy(this.array_, 0, objectArray, 0, this.count_);
                    this.array_ = objectArray;
                }
            }
        } else if (n2 == 0) {
            this.array_ = null;
        }
        this.setCount(n2);
    }

    private void insertElementsAt_(int n, Enumeration enumeration) throws CorruptedEnumerationException, IllegalElementException {
        if (enumeration instanceof CollectionEnumeration) {
            int n2 = ((CollectionEnumeration)enumeration).numberOfRemainingElements();
            int n3 = this.count_;
            int n4 = this.version_;
            this.growBy_(n2);
            int n5 = n3 - 1;
            while (n5 >= n) {
                this.array_[n5 + n2] = this.array_[n5];
                --n5;
            }
            int n6 = n;
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!this.canInclude(e)) {
                    int n7 = n;
                    while (n7 < n3) {
                        this.array_[n7] = this.array_[n7 + n2];
                        ++n7;
                    }
                    this.version_ = n4;
                    this.count_ = n3;
                    this.checkElement(e);
                }
                this.array_[n6++] = e;
            }
            return;
        }
        if (n == this.count_) {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                this.checkElement(e);
                this.growBy_(1);
                this.array_[this.count_ - 1] = e;
            }
            return;
        }
        int n8 = n;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.checkElement(e);
            this.growBy_(1);
            int n9 = this.count_ - 1;
            while (n9 > n8) {
                this.array_[n9] = this.array_[n9 - 1];
                --n9;
            }
            this.array_[n8++] = e;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void remove_(Object var1_1, boolean var2_2) {
        if (var1_1 == null) {
            return;
        }
        var3_3 = 0;
        ** GOTO lbl17
        {
            var4_4 = var3_3 + 1;
            while (var4_4 < this.count_) {
                this.array_[var4_4 - 1] = this.array_[var4_4];
                ++var4_4;
            }
            this.array_[this.count_ - 1] = null;
            this.growBy_(-1);
            if (!var2_2 || this.count_ == 0) {
                return;
            }
            do {
                if (var3_3 < this.count_ && this.array_[var3_3].equals(var1_1)) continue block0;
                ++var3_3;
lbl17:
                // 2 sources

            } while (var3_3 < this.count_);
        }
    }

    private void replace_(Object object, Object object2, boolean bl) throws IllegalElementException {
        if (object == null || this.count_ == 0) {
            return;
        }
        int n = 0;
        while (n < this.count_) {
            if (this.array_[n].equals(object)) {
                this.checkElement(object2);
                this.array_[n] = object2;
                this.incVersion();
                if (!bl) {
                    return;
                }
            }
            ++n;
        }
    }

    public synchronized void checkImplementation() throws ImplementationError {
        super.checkImplementation();
        this.assert(this.array_ != null || this.count_ == 0);
        this.assert(this.array_ == null || this.count_ <= this.array_.length);
        int n = 0;
        while (n < this.count_) {
            this.assert(this.canInclude(this.array_[n]));
            this.assert(this.occurrencesOf(this.array_[n]) > 0);
            this.assert(this.includes(this.array_[n]));
            ++n;
        }
    }
}

