/*
 * Decompiled with CFR 0.152.
 */
package collections;

import collections.CollectionEnumeration;
import collections.HTPairEnumeration;
import collections.HashTableParams;
import collections.IllegalElementException;
import collections.ImplementationError;
import collections.LLPair;
import collections.Predicate;
import collections.UpdatableMap;
import collections.UpdatableMapImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;

public class HashedMap
extends UpdatableMapImpl
implements UpdatableMap,
HashTableParams {
    protected LLPair[] table_ = null;
    protected float loadFactor_;

    public HashedMap() {
        this(null, 0.75f);
    }

    public HashedMap(Predicate predicate) {
        this(predicate, 0.75f);
    }

    protected HashedMap(Predicate predicate, float f) {
        super(predicate);
        this.loadFactor_ = f;
    }

    protected Object clone() throws CloneNotSupportedException {
        HashedMap hashedMap = new HashedMap(this.screener_, this.loadFactor_);
        if (this.count_ != 0) {
            int n = 2 * (int)((float)this.count_ / this.loadFactor_) + 1;
            if (n < 31) {
                n = 31;
            }
            hashedMap.buckets(n);
            int n2 = 0;
            while (n2 < this.table_.length) {
                LLPair lLPair = this.table_[n2];
                while (lLPair != null) {
                    hashedMap.putAt(lLPair.key(), lLPair.element());
                    lLPair = (LLPair)lLPair.next();
                }
                ++n2;
            }
        }
        return hashedMap;
    }

    public synchronized int buckets() {
        if (this.table_ == null) {
            return 0;
        }
        return this.table_.length;
    }

    public synchronized void buckets(int n) throws IllegalArgumentException {
        if (n == this.buckets()) {
            return;
        }
        if (n >= 1) {
            this.resize(n);
            return;
        }
        throw new IllegalArgumentException("Impossible Hash table size:" + n);
    }

    public synchronized float thresholdLoadFactor() {
        return this.loadFactor_;
    }

    public synchronized void thresholdLoadFactor(float f) throws IllegalArgumentException {
        if ((double)f > 0.0) {
            this.loadFactor_ = f;
            this.checkLoadFactor();
            return;
        }
        throw new IllegalArgumentException("Impossible Hash table load factor:" + f);
    }

    public synchronized boolean includes(Object object) {
        if (object == null || this.count_ == 0) {
            return false;
        }
        int n = 0;
        while (n < this.table_.length) {
            LLPair lLPair = this.table_[n];
            if (lLPair != null && lLPair.find(object) != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized int occurrencesOf(Object object) {
        if (object == null || this.count_ == 0) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.table_.length) {
            LLPair lLPair = this.table_[n2];
            if (lLPair != null) {
                n += lLPair.count(object);
            }
            ++n2;
        }
        return n;
    }

    public synchronized CollectionEnumeration elements() {
        return new HTPairEnumeration(this, this.table_, false);
    }

    public synchronized boolean includesKey(Object object) {
        if (object == null || this.count_ == 0) {
            return false;
        }
        LLPair lLPair = this.table_[this.hashOf(object)];
        if (lLPair != null) {
            return lLPair.findKey(object) != null;
        }
        return false;
    }

    public synchronized boolean includesAt(Object object, Object object2) {
        if (object == null || object2 == null || this.count_ == 0) {
            return false;
        }
        LLPair lLPair = this.table_[this.hashOf(object)];
        if (lLPair != null) {
            return lLPair.find(object, object2) != null;
        }
        return false;
    }

    public synchronized CollectionEnumeration keys() {
        return new HTPairEnumeration(this, this.table_, true);
    }

    public synchronized Object at(Object object) throws NoSuchElementException {
        LLPair lLPair;
        LLPair lLPair2;
        this.checkKey(object);
        if (this.count_ != 0 && (lLPair2 = this.table_[this.hashOf(object)]) != null && (lLPair = lLPair2.findKey(object)) != null) {
            return lLPair.element();
        }
        throw new NoSuchElementException("no Key matching argument " + object);
    }

    public synchronized Object aKeyOf(Object object) {
        if (object == null || this.count_ == 0) {
            return null;
        }
        int n = 0;
        while (n < this.table_.length) {
            LLPair lLPair;
            LLPair lLPair2 = this.table_[n];
            if (lLPair2 != null && (lLPair = (LLPair)lLPair2.find(object)) != null) {
                return lLPair.key();
            }
            ++n;
        }
        return null;
    }

    public synchronized void clear() {
        this.setCount(0);
        this.table_ = null;
    }

    public synchronized void exclude(Object object) {
        this.remove_(object, true);
    }

    public synchronized void removeOneOf(Object object) {
        this.remove_(object, false);
    }

    public synchronized void replaceOneOf(Object object, Object object2) throws IllegalElementException {
        this.replace_(object, object2, false);
    }

    public synchronized void replaceAllOf(Object object, Object object2) throws IllegalElementException {
        this.replace_(object, object2, true);
    }

    public synchronized Object take() throws NoSuchElementException {
        if (this.count_ != 0) {
            int n = 0;
            while (n < this.table_.length) {
                if (this.table_[n] != null) {
                    this.decCount();
                    Object object = this.table_[n].element();
                    this.table_[n] = (LLPair)this.table_[n].next();
                    return object;
                }
                ++n;
            }
        }
        this.checkIndex(0);
        return null;
    }

    public synchronized void putAt(Object object, Object object2) {
        int n;
        LLPair lLPair;
        this.checkKey(object);
        this.checkElement(object2);
        if (this.table_ == null) {
            this.resize(31);
        }
        if ((lLPair = this.table_[n = this.hashOf(object)]) == null) {
            this.table_[n] = new LLPair(object, object2, lLPair);
            this.incCount();
            return;
        }
        LLPair lLPair2 = lLPair.findKey(object);
        if (lLPair2 != null) {
            if (!lLPair2.element().equals(object2)) {
                lLPair2.element(object2);
                this.incVersion();
                return;
            }
        } else {
            this.table_[n] = new LLPair(object, object2, lLPair);
            this.incCount();
            this.checkLoadFactor();
        }
    }

    public synchronized void removeAt(Object object) {
        LLPair lLPair;
        LLPair lLPair2;
        if (object == null || this.count_ == 0) {
            return;
        }
        int n = this.hashOf(object);
        LLPair lLPair3 = lLPair2 = (lLPair = this.table_[n]);
        while (lLPair2 != null) {
            LLPair lLPair4 = (LLPair)lLPair2.next();
            if (lLPair2.key().equals(object)) {
                this.decCount();
                if (lLPair2 == lLPair) {
                    this.table_[n] = lLPair4;
                    return;
                }
                lLPair3.unlinkNext();
                return;
            }
            lLPair3 = lLPair2;
            lLPair2 = lLPair4;
        }
    }

    public synchronized void replaceElement(Object object, Object object2, Object object3) throws IllegalElementException {
        LLPair lLPair;
        if (object == null || object2 == null || this.count_ == 0) {
            return;
        }
        LLPair lLPair2 = this.table_[this.hashOf(object)];
        if (lLPair2 != null && (lLPair = lLPair2.find(object, object2)) != null) {
            this.checkElement(object3);
            lLPair.element(object3);
            this.incVersion();
        }
    }

    protected void checkLoadFactor() {
        if (this.table_ == null) {
            if (this.count_ != 0) {
                this.resize(31);
                return;
            }
        } else {
            float f = this.count_;
            float f2 = this.table_.length;
            if (f / f2 > this.loadFactor_) {
                int n = 2 * (int)(f / this.loadFactor_) + 1;
                this.resize(n);
            }
        }
    }

    protected final int hashOf(Object object) {
        return (object.hashCode() & Integer.MAX_VALUE) % this.table_.length;
    }

    protected void resize(int n) {
        LLPair[] lLPairArray = new LLPair[n];
        if (this.table_ != null) {
            int n2 = 0;
            while (n2 < this.table_.length) {
                LLPair lLPair = this.table_[n2];
                while (lLPair != null) {
                    LLPair lLPair2 = (LLPair)lLPair.next();
                    int n3 = (lLPair.key().hashCode() & Integer.MAX_VALUE) % n;
                    lLPair.next(lLPairArray[n3]);
                    lLPairArray[n3] = lLPair;
                    lLPair = lLPair2;
                }
                ++n2;
            }
        }
        this.table_ = lLPairArray;
        this.incVersion();
    }

    private void remove_(Object object, boolean bl) {
        if (object == null || this.count_ == 0) {
            return;
        }
        int n = 0;
        while (n < this.table_.length) {
            LLPair lLPair;
            LLPair lLPair2;
            LLPair lLPair3 = lLPair2 = (lLPair = this.table_[n]);
            while (lLPair2 != null) {
                LLPair lLPair4 = (LLPair)lLPair2.next();
                if (lLPair2.element().equals(object)) {
                    this.decCount();
                    if (lLPair2 == this.table_[n]) {
                        this.table_[n] = lLPair4;
                        lLPair3 = lLPair4;
                    } else {
                        lLPair3.next(lLPair4);
                    }
                    if (!bl) {
                        return;
                    }
                    lLPair2 = lLPair4;
                    continue;
                }
                lLPair3 = lLPair2;
                lLPair2 = lLPair4;
            }
            ++n;
        }
    }

    private void replace_(Object object, Object object2, boolean bl) throws IllegalElementException {
        if (this.count_ == 0 || object == null || object.equals(object2)) {
            return;
        }
        int n = 0;
        while (n < this.table_.length) {
            LLPair lLPair;
            LLPair lLPair2;
            LLPair lLPair3 = lLPair2 = (lLPair = this.table_[n]);
            while (lLPair2 != null) {
                LLPair lLPair4 = (LLPair)lLPair2.next();
                if (lLPair2.element().equals(object)) {
                    this.checkElement(object2);
                    this.incVersion();
                    lLPair2.element(object2);
                    if (!bl) {
                        return;
                    }
                }
                lLPair3 = lLPair2;
                lLPair2 = lLPair4;
            }
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        this.table_ = n > 0 ? new LLPair[n] : null;
        this.loadFactor_ = objectInputStream.readFloat();
        int n2 = objectInputStream.readInt();
        while (n2-- > 0) {
            LLPair lLPair;
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            int n3 = this.hashOf(object);
            LLPair lLPair2 = this.table_[n3];
            this.table_[n3] = lLPair = new LLPair(object, object2, lLPair2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.table_ != null ? this.table_.length : 0;
        objectOutputStream.writeInt(n);
        objectOutputStream.writeFloat(this.loadFactor_);
        objectOutputStream.writeInt(this.count_);
        if (n > 0) {
            CollectionEnumeration collectionEnumeration = this.keys();
            CollectionEnumeration collectionEnumeration2 = this.elements();
            while (collectionEnumeration.hasMoreElements()) {
                objectOutputStream.writeObject(collectionEnumeration.nextElement());
                objectOutputStream.writeObject(collectionEnumeration2.nextElement());
            }
        }
    }

    public synchronized void checkImplementation() throws ImplementationError {
        super.checkImplementation();
        this.assert(this.table_ != null || this.count_ == 0);
        this.assert(this.table_ == null || this.table_.length > 0);
        this.assert(this.loadFactor_ > 0.0f);
        if (this.table_ == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.table_.length) {
            LLPair lLPair = this.table_[n2];
            while (lLPair != null) {
                ++n;
                this.assert(this.canInclude(lLPair.element()));
                this.assert(this.canIncludeKey(lLPair.key()));
                this.assert(this.includesKey(lLPair.key()));
                this.assert(this.includes(lLPair.element()));
                this.assert(this.occurrencesOf(lLPair.element()) >= 1);
                this.assert(this.includesAt(lLPair.key(), lLPair.element()));
                this.assert(this.hashOf(lLPair.key()) == n2);
                lLPair = (LLPair)lLPair.next();
            }
            ++n2;
        }
        this.assert(n == this.count_);
    }
}

