/*
 * Decompiled with CFR 0.152.
 */
package collections;

import collections.CollectionEnumeration;
import collections.HTEnumeration;
import collections.HashTableParams;
import collections.IllegalElementException;
import collections.ImplementationError;
import collections.LLCell;
import collections.Predicate;
import collections.UpdatableSet;
import collections.UpdatableSetImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;

public class HashedSet
extends UpdatableSetImpl
implements UpdatableSet,
HashTableParams {
    protected LLCell[] table_ = null;
    protected float loadFactor_;

    public HashedSet() {
        this(null, 0.75f);
    }

    public HashedSet(Predicate predicate) {
        this(predicate, 0.75f);
    }

    protected HashedSet(Predicate predicate, float f) {
        super(predicate);
        this.loadFactor_ = f;
    }

    protected Object clone() throws CloneNotSupportedException {
        HashedSet hashedSet = new HashedSet(this.screener_, this.loadFactor_);
        if (this.count_ != 0) {
            int n = 2 * (int)((float)this.count_ / this.loadFactor_) + 1;
            if (n < 31) {
                n = 31;
            }
            hashedSet.buckets(n);
            int n2 = 0;
            while (n2 < this.table_.length) {
                LLCell lLCell = this.table_[n2];
                while (lLCell != null) {
                    hashedSet.include(lLCell.element());
                    lLCell = lLCell.next();
                }
                ++n2;
            }
        }
        return hashedSet;
    }

    public synchronized int buckets() {
        if (this.table_ == null) {
            return 0;
        }
        return this.table_.length;
    }

    public synchronized void buckets(int n) throws IllegalArgumentException {
        if (n == this.buckets()) {
            return;
        }
        if (n >= 1) {
            this.resize(n);
            return;
        }
        throw new IllegalArgumentException("Impossible Hash table size:" + n);
    }

    public synchronized float thresholdLoadFactor() {
        return this.loadFactor_;
    }

    public synchronized void thresholdLoadFactor(float f) throws IllegalArgumentException {
        if ((double)f > 0.0) {
            this.loadFactor_ = f;
            this.checkLoadFactor();
            return;
        }
        throw new IllegalArgumentException("Impossible Hash table load factor:" + f);
    }

    public synchronized boolean includes(Object object) {
        if (object == null || this.count_ == 0) {
            return false;
        }
        LLCell lLCell = this.table_[this.hashOf(object)];
        if (lLCell != null) {
            return lLCell.find(object) != null;
        }
        return false;
    }

    public synchronized int occurrencesOf(Object object) {
        if (this.includes(object)) {
            return 1;
        }
        return 0;
    }

    public synchronized CollectionEnumeration elements() {
        return new HTEnumeration(this, this.table_);
    }

    public synchronized void clear() {
        this.setCount(0);
        this.table_ = null;
    }

    public synchronized void exclude(Object object) {
        this.removeOneOf(object);
    }

    public synchronized void removeOneOf(Object object) {
        LLCell lLCell;
        LLCell lLCell2;
        if (object == null || this.count_ == 0) {
            return;
        }
        int n = this.hashOf(object);
        LLCell lLCell3 = lLCell2 = (lLCell = this.table_[n]);
        while (lLCell2 != null) {
            LLCell lLCell4 = lLCell2.next();
            if (lLCell2.element().equals(object)) {
                this.decCount();
                if (lLCell2 == this.table_[n]) {
                    this.table_[n] = lLCell4;
                    lLCell3 = lLCell4;
                    return;
                }
                lLCell3.next(lLCell4);
                return;
            }
            lLCell3 = lLCell2;
            lLCell2 = lLCell4;
        }
    }

    public synchronized void replaceOneOf(Object object, Object object2) throws IllegalElementException {
        if (this.count_ == 0 || object == null || object.equals(object2)) {
            return;
        }
        if (this.includes(object)) {
            this.checkElement(object2);
            this.exclude(object);
            this.include(object2);
        }
    }

    public synchronized void replaceAllOf(Object object, Object object2) throws IllegalElementException {
        this.replaceOneOf(object, object2);
    }

    public synchronized Object take() throws NoSuchElementException {
        if (this.count_ != 0) {
            int n = 0;
            while (n < this.table_.length) {
                if (this.table_[n] != null) {
                    this.decCount();
                    Object object = this.table_[n].element();
                    this.table_[n] = this.table_[n].next();
                    return object;
                }
                ++n;
            }
        }
        this.checkIndex(0);
        return null;
    }

    public synchronized void include(Object object) {
        LLCell lLCell;
        int n;
        LLCell lLCell2;
        this.checkElement(object);
        if (this.table_ == null) {
            this.resize(31);
        }
        if ((lLCell2 = this.table_[n = this.hashOf(object)]) != null && lLCell2.find(object) != null) {
            return;
        }
        this.table_[n] = lLCell = new LLCell(object, lLCell2);
        this.incCount();
        if (lLCell2 != null) {
            this.checkLoadFactor();
        }
    }

    protected void checkLoadFactor() {
        if (this.table_ == null) {
            if (this.count_ != 0) {
                this.resize(31);
                return;
            }
        } else {
            float f = this.count_;
            float f2 = this.table_.length;
            if (f / f2 > this.loadFactor_) {
                int n = 2 * (int)(f / this.loadFactor_) + 1;
                this.resize(n);
            }
        }
    }

    protected final int hashOf(Object object) {
        return (object.hashCode() & Integer.MAX_VALUE) % this.table_.length;
    }

    protected void resize(int n) {
        LLCell[] lLCellArray = new LLCell[n];
        if (this.table_ != null) {
            int n2 = 0;
            while (n2 < this.table_.length) {
                LLCell lLCell = this.table_[n2];
                while (lLCell != null) {
                    LLCell lLCell2 = lLCell.next();
                    int n3 = (lLCell.element().hashCode() & Integer.MAX_VALUE) % n;
                    lLCell.next(lLCellArray[n3]);
                    lLCellArray[n3] = lLCell;
                    lLCell = lLCell2;
                }
                ++n2;
            }
        }
        this.table_ = lLCellArray;
        this.incVersion();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        this.table_ = n > 0 ? new LLCell[n] : null;
        this.loadFactor_ = objectInputStream.readFloat();
        int n2 = objectInputStream.readInt();
        while (n2-- > 0) {
            LLCell lLCell;
            Object object = objectInputStream.readObject();
            int n3 = this.hashOf(object);
            LLCell lLCell2 = this.table_[n3];
            this.table_[n3] = lLCell = new LLCell(object, lLCell2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.table_ != null ? this.table_.length : 0;
        objectOutputStream.writeInt(n);
        objectOutputStream.writeFloat(this.loadFactor_);
        objectOutputStream.writeInt(this.count_);
        if (n > 0) {
            CollectionEnumeration collectionEnumeration = this.elements();
            while (collectionEnumeration.hasMoreElements()) {
                objectOutputStream.writeObject(collectionEnumeration.nextElement());
            }
        }
    }

    public synchronized void checkImplementation() throws ImplementationError {
        super.checkImplementation();
        this.assert(this.table_ != null || this.count_ == 0);
        this.assert(this.table_ == null || this.table_.length > 0);
        this.assert(this.loadFactor_ > 0.0f);
        if (this.table_ != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.table_.length) {
                LLCell lLCell = this.table_[n2];
                while (lLCell != null) {
                    ++n;
                    this.assert(this.canInclude(lLCell.element()));
                    this.assert(this.includes(lLCell.element()));
                    this.assert(this.occurrencesOf(lLCell.element()) == 1);
                    this.assert(this.hashOf(lLCell.element()) == n2);
                    lLCell = lLCell.next();
                }
                ++n2;
            }
            this.assert(n == this.count_);
        }
    }
}

