/*
 * Decompiled with CFR 0.152.
 */
package collections;

import collections.CollectionEnumeration;
import collections.IllegalElementException;
import collections.ImplementationError;
import collections.LLCell;
import collections.LLPair;
import collections.LLPairEnumeration;
import collections.Predicate;
import collections.UpdatableMap;
import collections.UpdatableMapImpl;
import java.util.NoSuchElementException;

public class LLMap
extends UpdatableMapImpl
implements UpdatableMap {
    protected LLPair list_;

    public LLMap() {
        this(null, null, 0);
    }

    public LLMap(Predicate predicate) {
        this(predicate, null, 0);
    }

    protected LLMap(Predicate predicate, LLPair lLPair, int n) {
        super(predicate);
        this.list_ = lLPair;
        this.count_ = n;
    }

    protected Object clone() throws CloneNotSupportedException {
        if (this.list_ == null) {
            return new LLMap(this.screener_, null, 0);
        }
        return new LLMap(this.screener_, (LLPair)this.list_.copyList(), this.count_);
    }

    public synchronized boolean includes(Object object) {
        if (object == null || this.list_ == null) {
            return false;
        }
        return this.list_.find(object) != null;
    }

    public synchronized int occurrencesOf(Object object) {
        if (object == null || this.list_ == null) {
            return 0;
        }
        return this.list_.count(object);
    }

    public synchronized CollectionEnumeration elements() {
        return new LLPairEnumeration(this, this.list_, false);
    }

    public synchronized boolean includesKey(Object object) {
        if (object == null || this.list_ == null) {
            return false;
        }
        return this.list_.findKey(object) != null;
    }

    public synchronized boolean includesAt(Object object, Object object2) {
        if (object == null || object2 == null || this.list_ == null) {
            return false;
        }
        return this.list_.find(object, object2) != null;
    }

    public synchronized CollectionEnumeration keys() {
        return new LLPairEnumeration(this, this.list_, true);
    }

    public synchronized Object at(Object object) throws NoSuchElementException {
        LLPair lLPair;
        this.checkKey(object);
        if (this.list_ != null && (lLPair = this.list_.findKey(object)) != null) {
            return lLPair.element();
        }
        throw new NoSuchElementException("no Key matching argument " + object);
    }

    public synchronized Object aKeyOf(Object object) {
        if (object == null || this.count_ == 0) {
            return null;
        }
        LLPair lLPair = (LLPair)this.list_.find(object);
        if (lLPair != null) {
            return lLPair.key();
        }
        return null;
    }

    public synchronized void clear() {
        this.list_ = null;
        this.setCount(0);
    }

    public synchronized void replaceOneOf(Object object, Object object2) throws IllegalElementException {
        this.replace_(object, object2, false);
    }

    public synchronized void replaceAllOf(Object object, Object object2) throws IllegalElementException {
        this.replace_(object, object2, true);
    }

    public synchronized void exclude(Object object) {
        this.remove_(object, true);
    }

    public synchronized void removeOneOf(Object object) {
        this.remove_(object, false);
    }

    public synchronized Object take() throws NoSuchElementException {
        if (this.list_ != null) {
            Object object = this.list_.element();
            this.list_ = (LLPair)this.list_.next();
            this.decCount();
            return object;
        }
        this.checkIndex(0);
        return null;
    }

    public synchronized void putAt(Object object, Object object2) {
        LLPair lLPair;
        this.checkKey(object);
        this.checkElement(object2);
        if (this.list_ != null && (lLPair = this.list_.findKey(object)) != null) {
            if (!lLPair.element().equals(object2)) {
                lLPair.element(object2);
                this.incVersion();
            }
            return;
        }
        this.list_ = new LLPair(object, object2, this.list_);
        this.incCount();
    }

    public synchronized void removeAt(Object object) {
        LLPair lLPair;
        if (object == null || this.list_ == null) {
            return;
        }
        LLPair lLPair2 = lLPair = this.list_;
        while (lLPair != null) {
            LLPair lLPair3 = (LLPair)lLPair.next();
            if (lLPair.key().equals(object)) {
                this.decCount();
                if (lLPair == this.list_) {
                    this.list_ = lLPair3;
                    return;
                }
                lLPair2.unlinkNext();
                return;
            }
            lLPair2 = lLPair;
            lLPair = lLPair3;
        }
    }

    public synchronized void replaceElement(Object object, Object object2, Object object3) throws IllegalElementException {
        if (object == null || object2 == null || this.list_ == null) {
            return;
        }
        LLPair lLPair = this.list_.find(object, object2);
        if (lLPair != null) {
            this.checkElement(object3);
            lLPair.element(object3);
            this.incVersion();
        }
    }

    private void remove_(Object object, boolean bl) {
        LLPair lLPair;
        if (object == null || this.count_ == 0) {
            return;
        }
        LLPair lLPair2 = lLPair = this.list_;
        while (lLPair != null) {
            LLPair lLPair3 = (LLPair)lLPair.next();
            if (lLPair.element().equals(object)) {
                this.decCount();
                if (lLPair == this.list_) {
                    this.list_ = lLPair3;
                    lLPair2 = lLPair3;
                } else {
                    lLPair2.next(lLPair3);
                }
                if (!bl || this.count_ == 0) {
                    return;
                }
                lLPair = lLPair3;
                continue;
            }
            lLPair2 = lLPair;
            lLPair = lLPair3;
        }
    }

    private void replace_(Object object, Object object2, boolean bl) throws IllegalElementException {
        if (this.list_ == null || object == null || object.equals(object2)) {
            return;
        }
        LLCell lLCell = this.list_.find(object);
        while (lLCell != null) {
            this.checkElement(object2);
            lLCell.element(object2);
            this.incVersion();
            if (!bl) {
                return;
            }
            lLCell = lLCell.find(object);
        }
    }

    public synchronized void checkImplementation() throws ImplementationError {
        super.checkImplementation();
        this.assert(this.count_ == 0 == (this.list_ == null));
        this.assert(this.list_ == null || this.list_.length() == this.count_);
        LLPair lLPair = this.list_;
        while (lLPair != null) {
            this.assert(this.canInclude(lLPair.element()));
            this.assert(this.canIncludeKey(lLPair.key()));
            this.assert(this.includesKey(lLPair.key()));
            this.assert(this.includes(lLPair.element()));
            this.assert(this.occurrencesOf(lLPair.element()) >= 1);
            this.assert(this.includesAt(lLPair.key(), lLPair.element()));
            lLPair = (LLPair)lLPair.next();
        }
    }
}

