/*
 * Decompiled with CFR 0.152.
 */
package collections;

import collections.CLCell;
import collections.CollectionEnumeration;
import collections.IllegalElementException;
import collections.ImplementationError;
import collections.LBEnumeration;
import collections.Predicate;
import collections.UpdatableBag;
import collections.UpdatableBagImpl;
import java.util.NoSuchElementException;

public class LinkedBuffer
extends UpdatableBagImpl
implements UpdatableBag {
    public static final int defaultChunkSize = 32;
    protected CLCell tail_;
    protected int lastCount_;
    protected int chunkSize_;

    public LinkedBuffer() {
        this(null, 0, null, 0, 32);
    }

    public LinkedBuffer(Predicate predicate) {
        this(predicate, 0, null, 0, 32);
    }

    protected LinkedBuffer(Predicate predicate, int n, CLCell cLCell, int n2, int n3) {
        super(predicate);
        this.count_ = n;
        this.tail_ = cLCell;
        this.lastCount_ = n2;
        this.chunkSize_ = n3;
    }

    protected Object clone() throws CloneNotSupportedException {
        CLCell cLCell;
        if (this.count_ == 0) {
            return new LinkedBuffer(this.screener_);
        }
        CLCell cLCell2 = cLCell = this.tail_.copyList();
        do {
            Object[] objectArray = (Object[])cLCell2.element();
            Object[] objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = objectArray[n];
                ++n;
            }
            cLCell2.element(objectArray2);
        } while ((cLCell2 = cLCell2.next()) != cLCell);
        return new LinkedBuffer(this.screener_, this.count_, cLCell, this.lastCount_, this.chunkSize_);
    }

    public synchronized int chunkSize() {
        return this.chunkSize_;
    }

    public synchronized void chunkSize(int n) throws IllegalArgumentException {
        if (n > 0) {
            this.chunkSize_ = n;
            return;
        }
        throw new IllegalArgumentException("Attempt to set impossible chunk size value of " + n);
    }

    public synchronized boolean includes(Object object) {
        if (object == null || this.count_ == 0) {
            return false;
        }
        CLCell cLCell = this.tail_.next();
        while (true) {
            Object[] objectArray = (Object[])cLCell.element();
            boolean bl = cLCell == this.tail_;
            int n = bl ? this.lastCount_ : objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (objectArray[n2].equals(object)) {
                    return true;
                }
                ++n2;
            }
            if (bl) break;
            cLCell = cLCell.next();
        }
        return false;
    }

    public synchronized int occurrencesOf(Object object) {
        if (object == null || this.count_ == 0) {
            return 0;
        }
        int n = 0;
        CLCell cLCell = this.tail_.next();
        while (true) {
            Object[] objectArray = (Object[])cLCell.element();
            boolean bl = cLCell == this.tail_;
            int n2 = bl ? this.lastCount_ : objectArray.length;
            int n3 = 0;
            while (n3 < n2) {
                if (objectArray[n3].equals(object)) {
                    ++n;
                }
                ++n3;
            }
            if (bl) break;
            cLCell = cLCell.next();
        }
        return n;
    }

    public synchronized CollectionEnumeration elements() {
        return new LBEnumeration(this, this.tail_ == null ? null : this.tail_.next());
    }

    public synchronized void clear() {
        this.setCount(0);
        this.tail_ = null;
        this.lastCount_ = 0;
    }

    public synchronized void exclude(Object object) {
        this.remove_(object, true);
    }

    public synchronized void removeOneOf(Object object) {
        this.remove_(object, false);
    }

    public synchronized void replaceOneOf(Object object, Object object2) throws IllegalElementException {
        this.replace_(object, object2, false);
    }

    public synchronized void replaceAllOf(Object object, Object object2) throws IllegalElementException {
        this.replace_(object, object2, true);
    }

    public synchronized Object take() throws NoSuchElementException {
        if (this.count_ != 0) {
            Object[] objectArray = (Object[])this.tail_.element();
            Object object = objectArray[this.lastCount_ - 1];
            objectArray[this.lastCount_ - 1] = null;
            this.shrink_();
            return object;
        }
        this.checkIndex(0);
        return null;
    }

    public synchronized void addIfAbsent(Object object) throws IllegalElementException {
        if (!this.includes(object)) {
            this.add(object);
        }
    }

    public synchronized void add(Object object) throws IllegalElementException {
        Object[] objectArray;
        this.checkElement(object);
        this.incCount();
        if (this.tail_ == null) {
            this.tail_ = new CLCell(new Object[this.chunkSize_]);
            this.lastCount_ = 0;
        }
        if (this.lastCount_ == (objectArray = (Object[])this.tail_.element()).length) {
            objectArray = new Object[this.chunkSize_];
            this.tail_.addNext(objectArray);
            this.tail_ = this.tail_.next();
            this.lastCount_ = 0;
        }
        objectArray[this.lastCount_++] = object;
    }

    private void remove_(Object object, boolean bl) {
        if (object == null || this.count_ == 0) {
            return;
        }
        CLCell cLCell = this.tail_;
        while (true) {
            Object[] objectArray = (Object[])cLCell.element();
            int n = cLCell == this.tail_ ? this.lastCount_ - 1 : objectArray.length - 1;
            while (n >= 0) {
                if (objectArray[n].equals(object)) {
                    Object[] objectArray2 = (Object[])this.tail_.element();
                    objectArray[n] = objectArray2[this.lastCount_ - 1];
                    objectArray2[this.lastCount_ - 1] = null;
                    this.shrink_();
                    if (!bl || this.count_ == 0) {
                        return;
                    }
                    if (cLCell != this.tail_ || n < this.lastCount_) continue;
                    n = this.lastCount_ - 1;
                    continue;
                }
                --n;
            }
            if (cLCell == this.tail_.next()) {
                return;
            }
            cLCell = cLCell.prev();
        }
    }

    private void replace_(Object object, Object object2, boolean bl) throws IllegalElementException {
        if (object == null || this.count_ == 0 || object.equals(object2)) {
            return;
        }
        CLCell cLCell = this.tail_.next();
        while (true) {
            Object[] objectArray = (Object[])cLCell.element();
            boolean bl2 = cLCell == this.tail_;
            int n = bl2 ? this.lastCount_ : objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (objectArray[n2].equals(object)) {
                    this.checkElement(object2);
                    this.incVersion();
                    objectArray[n2] = object2;
                    if (!bl) {
                        return;
                    }
                }
                ++n2;
            }
            if (bl2) {
                return;
            }
            cLCell = cLCell.next();
        }
    }

    private void shrink_() {
        this.decCount();
        --this.lastCount_;
        if (this.lastCount_ == 0) {
            if (this.count_ == 0) {
                this.clear();
                return;
            }
            CLCell cLCell = this.tail_;
            this.tail_ = this.tail_.prev();
            cLCell.unlink();
            Object[] objectArray = (Object[])this.tail_.element();
            this.lastCount_ = objectArray.length;
        }
    }

    public void checkImplementation() throws ImplementationError {
        super.checkImplementation();
        this.assert(this.chunkSize_ >= 0);
        this.assert(this.lastCount_ >= 0);
        this.assert(this.count_ == 0 == (this.tail_ == null));
        if (this.tail_ == null) {
            return;
        }
        int n = 0;
        CLCell cLCell = this.tail_.next();
        while (true) {
            Object[] objectArray = (Object[])cLCell.element();
            boolean bl = cLCell == this.tail_;
            int n2 = bl ? this.lastCount_ : objectArray.length;
            n += n2;
            int n3 = 0;
            while (n3 < n2) {
                Object object = objectArray[n3];
                this.assert(this.canInclude(object) && this.includes(object));
                ++n3;
            }
            if (bl) break;
            cLCell = cLCell.next();
        }
        this.assert(n == this.count_);
    }
}

