/*
 * Decompiled with CFR 0.152.
 */
package collections;

import collections.CollectionEnumeration;
import collections.Comparator;
import collections.DefaultComparator;
import collections.IllegalElementException;
import collections.ImplementationError;
import collections.KeySortedCollection;
import collections.Predicate;
import collections.RBPair;
import collections.RBPairEnumeration;
import collections.UpdatableMap;
import collections.UpdatableMapImpl;
import java.util.NoSuchElementException;

public class RBMap
extends UpdatableMapImpl
implements UpdatableMap,
KeySortedCollection {
    protected RBPair tree_;
    protected Comparator cmp_;

    public RBMap() {
        this(null, null, null, 0);
    }

    public RBMap(Predicate predicate) {
        this(predicate, null, null, 0);
    }

    public RBMap(Comparator comparator) {
        this(null, comparator, null, 0);
    }

    public RBMap(Predicate predicate, Comparator comparator) {
        this(predicate, comparator, null, 0);
    }

    protected RBMap(Predicate predicate, Comparator comparator, RBPair rBPair, int n) {
        super(predicate);
        this.count_ = n;
        this.tree_ = rBPair;
        if (comparator != null) {
            this.cmp_ = comparator;
            return;
        }
        this.cmp_ = new DefaultComparator();
    }

    protected Object clone() throws CloneNotSupportedException {
        if (this.count_ == 0) {
            return new RBMap(this.screener_, this.cmp_);
        }
        return new RBMap(this.screener_, this.cmp_, (RBPair)this.tree_.copyTree(), this.count_);
    }

    public synchronized boolean includes(Object object) {
        if (object == null || this.count_ == 0) {
            return false;
        }
        return this.tree_.find(object, this.cmp_) != null;
    }

    public synchronized int occurrencesOf(Object object) {
        if (object == null || this.count_ == 0) {
            return 0;
        }
        return this.tree_.count(object, this.cmp_);
    }

    public synchronized CollectionEnumeration elements() {
        return new RBPairEnumeration(this, this.tree_, false);
    }

    public synchronized Comparator keyComparator() {
        return this.cmp_;
    }

    public synchronized void comparator(Comparator comparator) {
        if (comparator != this.cmp_) {
            this.cmp_ = comparator != null ? comparator : new DefaultComparator();
            if (this.count_ != 0) {
                this.incVersion();
                RBPair rBPair = (RBPair)this.tree_.leftmost();
                this.tree_ = null;
                this.count_ = 0;
                while (rBPair != null) {
                    this.add_(rBPair.key(), rBPair.element(), false);
                    rBPair = (RBPair)rBPair.successor();
                }
            }
        }
    }

    public synchronized boolean includesKey(Object object) {
        if (object == null || this.count_ == 0) {
            return false;
        }
        return this.tree_.findKey(object, this.cmp_) != null;
    }

    public synchronized boolean includesAt(Object object, Object object2) {
        if (object == null || object2 == null || this.count_ == 0) {
            return false;
        }
        return this.tree_.find(object, object2, this.cmp_) != null;
    }

    public synchronized CollectionEnumeration keys() {
        return new RBPairEnumeration(this, this.tree_, true);
    }

    public synchronized Object at(Object object) throws NoSuchElementException {
        RBPair rBPair;
        if (this.count_ != 0 && (rBPair = this.tree_.findKey(object, this.cmp_)) != null) {
            return rBPair.element();
        }
        throw new NoSuchElementException("no Key matching argument " + object);
    }

    public synchronized Object aKeyOf(Object object) {
        if (object == null || this.count_ == 0) {
            return null;
        }
        RBPair rBPair = (RBPair)this.tree_.find(object, this.cmp_);
        if (rBPair != null) {
            return rBPair.key();
        }
        return null;
    }

    public synchronized void clear() {
        this.setCount(0);
        this.tree_ = null;
    }

    public synchronized void exclude(Object object) {
        if (object == null || this.count_ == 0) {
            return;
        }
        RBPair rBPair = (RBPair)this.tree_.find(object, this.cmp_);
        while (rBPair != null) {
            this.tree_ = (RBPair)rBPair.delete(this.tree_);
            this.decCount();
            if (this.count_ == 0) {
                return;
            }
            rBPair = (RBPair)this.tree_.find(object, this.cmp_);
        }
    }

    public synchronized void removeOneOf(Object object) {
        if (object == null || this.count_ == 0) {
            return;
        }
        RBPair rBPair = (RBPair)this.tree_.find(object, this.cmp_);
        if (rBPair != null) {
            this.tree_ = (RBPair)rBPair.delete(this.tree_);
            this.decCount();
        }
    }

    public synchronized void replaceOneOf(Object object, Object object2) throws IllegalElementException {
        if (this.count_ == 0 || object == null || object.equals(object2)) {
            return;
        }
        RBPair rBPair = (RBPair)this.tree_.find(object, this.cmp_);
        if (rBPair != null) {
            this.checkElement(object2);
            this.incVersion();
            rBPair.element(object2);
        }
    }

    public synchronized void replaceAllOf(Object object, Object object2) throws IllegalElementException {
        RBPair rBPair = (RBPair)this.tree_.find(object, this.cmp_);
        while (rBPair != null) {
            this.checkElement(object2);
            this.incVersion();
            rBPair.element(object2);
            rBPair = (RBPair)this.tree_.find(object, this.cmp_);
        }
    }

    public synchronized Object take() throws NoSuchElementException {
        if (this.count_ != 0) {
            RBPair rBPair = (RBPair)this.tree_.leftmost();
            Object object = rBPair.element();
            this.tree_ = (RBPair)rBPair.delete(this.tree_);
            this.decCount();
            return object;
        }
        this.checkIndex(0);
        return null;
    }

    public synchronized void putAt(Object object, Object object2) {
        this.add_(object, object2, true);
    }

    public synchronized void removeAt(Object object) {
        if (object == null || this.count_ == 0) {
            return;
        }
        RBPair rBPair = this.tree_.findKey(object, this.cmp_);
        if (rBPair != null) {
            this.tree_ = (RBPair)rBPair.delete(this.tree_);
            this.decCount();
        }
    }

    public synchronized void replaceElement(Object object, Object object2, Object object3) throws IllegalElementException {
        if (object == null || object2 == null || this.count_ == 0) {
            return;
        }
        RBPair rBPair = this.tree_.find(object, object2, this.cmp_);
        if (rBPair != null) {
            this.checkElement(object3);
            rBPair.element(object3);
            this.incVersion();
        }
    }

    private void add_(Object object, Object object2, boolean bl) throws IllegalElementException {
        this.checkKey(object);
        this.checkElement(object2);
        if (this.tree_ == null) {
            this.tree_ = new RBPair(object, object2);
            this.incCount();
            return;
        }
        RBPair rBPair = this.tree_;
        while (true) {
            int n;
            if ((n = this.cmp_.compare(object, rBPair.key())) == 0 && bl) {
                if (!rBPair.element().equals(object2)) {
                    rBPair.element(object2);
                    this.incVersion();
                }
                return;
            }
            if (n <= 0) {
                if (rBPair.left() != null) {
                    rBPair = (RBPair)rBPair.left();
                    continue;
                }
                this.tree_ = (RBPair)rBPair.insertLeft(new RBPair(object, object2), this.tree_);
                this.incCount();
                return;
            }
            if (rBPair.right() == null) break;
            rBPair = (RBPair)rBPair.right();
        }
        this.tree_ = (RBPair)rBPair.insertRight(new RBPair(object, object2), this.tree_);
        this.incCount();
    }

    public void checkImplementation() throws ImplementationError {
        super.checkImplementation();
        this.assert(this.cmp_ != null);
        this.assert(this.count_ == 0 == (this.tree_ == null));
        this.assert(this.tree_ == null || this.tree_.size() == this.count_);
        if (this.tree_ != null) {
            this.tree_.checkImplementation();
            Object object = null;
            RBPair rBPair = (RBPair)this.tree_.leftmost();
            while (rBPair != null) {
                Object object2 = rBPair.key();
                this.assert(object == null || this.cmp_.compare(object, object2) <= 0);
                object = object2;
                rBPair = (RBPair)rBPair.successor();
            }
        }
    }
}

