/*
 * Decompiled with CFR 0.152.
 */
package collections;

import collections.CollectionEnumeration;
import collections.Comparator;
import collections.DefaultComparator;
import collections.ElementSortedCollection;
import collections.IllegalElementException;
import collections.ImplementationError;
import collections.Predicate;
import collections.RBCell;
import collections.RBCellEnumeration;
import collections.UpdatableBag;
import collections.UpdatableBagImpl;
import java.util.NoSuchElementException;

public class RBTree
extends UpdatableBagImpl
implements UpdatableBag,
ElementSortedCollection {
    protected RBCell tree_;
    protected Comparator cmp_;

    public RBTree() {
        this(null, null, null, 0);
    }

    public RBTree(Predicate predicate) {
        this(predicate, null, null, 0);
    }

    public RBTree(Comparator comparator) {
        this(null, comparator, null, 0);
    }

    public RBTree(Predicate predicate, Comparator comparator) {
        this(predicate, comparator, null, 0);
    }

    protected RBTree(Predicate predicate, Comparator comparator, RBCell rBCell, int n) {
        super(predicate);
        this.count_ = n;
        this.tree_ = rBCell;
        if (comparator != null) {
            this.cmp_ = comparator;
            return;
        }
        this.cmp_ = new DefaultComparator();
    }

    protected Object clone() throws CloneNotSupportedException {
        if (this.count_ == 0) {
            return new RBTree(this.screener_, this.cmp_);
        }
        return new RBTree(this.screener_, this.cmp_, this.tree_.copyTree(), this.count_);
    }

    public synchronized boolean includes(Object object) {
        if (object == null || this.count_ == 0) {
            return false;
        }
        return this.tree_.find(object, this.cmp_) != null;
    }

    public synchronized int occurrencesOf(Object object) {
        if (object == null || this.count_ == 0) {
            return 0;
        }
        return this.tree_.count(object, this.cmp_);
    }

    public synchronized CollectionEnumeration elements() {
        return new RBCellEnumeration(this, this.tree_);
    }

    public synchronized Comparator elementComparator() {
        return this.cmp_;
    }

    public synchronized void elementComparator(Comparator comparator) {
        if (comparator != this.cmp_) {
            this.cmp_ = comparator != null ? comparator : new DefaultComparator();
            if (this.count_ != 0) {
                this.incVersion();
                RBCell rBCell = this.tree_.leftmost();
                this.tree_ = null;
                this.count_ = 0;
                while (rBCell != null) {
                    this.add_(rBCell.element(), false);
                    rBCell = rBCell.successor();
                }
            }
        }
    }

    public synchronized void clear() {
        this.setCount(0);
        this.tree_ = null;
    }

    public synchronized void exclude(Object object) {
        this.remove_(object, true);
    }

    public synchronized void removeOneOf(Object object) {
        this.remove_(object, false);
    }

    public synchronized void replaceOneOf(Object object, Object object2) throws IllegalElementException {
        this.replace_(object, object2, false);
    }

    public synchronized void replaceAllOf(Object object, Object object2) throws IllegalElementException {
        this.replace_(object, object2, true);
    }

    public synchronized Object take() throws NoSuchElementException {
        if (this.count_ != 0) {
            RBCell rBCell = this.tree_.leftmost();
            Object object = rBCell.element();
            this.tree_ = rBCell.delete(this.tree_);
            this.decCount();
            return object;
        }
        this.checkIndex(0);
        return null;
    }

    public synchronized void addIfAbsent(Object object) throws IllegalElementException {
        this.add_(object, true);
    }

    public synchronized void add(Object object) throws IllegalElementException {
        this.add_(object, false);
    }

    private void add_(Object object, boolean bl) throws IllegalElementException {
        this.checkElement(object);
        if (this.tree_ == null) {
            this.tree_ = new RBCell(object);
            this.incCount();
            return;
        }
        RBCell rBCell = this.tree_;
        while (true) {
            int n;
            if ((n = this.cmp_.compare(object, rBCell.element())) == 0 && bl) {
                return;
            }
            if (n <= 0) {
                if (rBCell.left() != null) {
                    rBCell = rBCell.left();
                    continue;
                }
                this.tree_ = rBCell.insertLeft(new RBCell(object), this.tree_);
                this.incCount();
                return;
            }
            if (rBCell.right() == null) break;
            rBCell = rBCell.right();
        }
        this.tree_ = rBCell.insertRight(new RBCell(object), this.tree_);
        this.incCount();
    }

    /*
     * Unable to fully structure code
     */
    private void remove_(Object var1_1, boolean var2_2) {
        if (var1_1 != null) ** GOTO lbl8
        return;
        while ((var3_3 = this.tree_.find(var1_1, this.cmp_)) != null) {
            this.tree_ = var3_3.delete(this.tree_);
            this.decCount();
            if (!var2_2) {
                return;
            }
lbl8:
            // 3 sources

            if (this.count_ > 0) continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void replace_(Object var1_1, Object var2_2, boolean var3_3) throws IllegalElementException {
        if (var1_1 != null && this.count_ != 0 && !var1_1.equals(var2_2)) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            this.removeOneOf(var1_1);
            this.add(var2_2);
            if (var3_3) continue;
            return;
lbl7:
            // 2 sources

            ** while (this.includes((Object)var1_1))
        }
lbl8:
        // 1 sources

    }

    public void checkImplementation() throws ImplementationError {
        super.checkImplementation();
        this.assert(this.cmp_ != null);
        this.assert(this.count_ == 0 == (this.tree_ == null));
        this.assert(this.tree_ == null || this.tree_.size() == this.count_);
        if (this.tree_ != null) {
            this.tree_.checkImplementation();
            Object object = null;
            RBCell rBCell = this.tree_.leftmost();
            while (rBCell != null) {
                Object object2 = rBCell.element();
                if (object != null) {
                    this.assert(this.cmp_.compare(object, object2) <= 0);
                }
                object = object2;
                rBCell = rBCell.successor();
            }
        }
    }
}

