/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNetSystem;
import de.renew.simulator.ConsoleTracer;
import de.renew.simulator.Net;
import de.renew.simulator.NetInstance;
import de.renew.simulator.Simulator;
import de.renew.simulator.SimulatorHelper;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ShadowSimulator {
    public static void main(String[] stringArray) {
        NetInstance netInstance;
        Object object;
        Object object2;
        Serializable serializable;
        if (stringArray.length != 3) {
            System.out.println("Usage: java de.renew.application.ShadowSimulator SIMCLASS FILE NETNAME");
            System.exit(0);
        }
        Simulator simulator = null;
        try {
            serializable = Class.forName(stringArray[0]);
            simulator = (Simulator)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println("Could not load simulator class " + stringArray[0] + ".");
            System.exit(0);
        }
        serializable = null;
        try {
            object2 = new FileInputStream(stringArray[1]);
            object = new ObjectInputStream((InputStream)object2);
            serializable = (ShadowNetSystem)object.readObject();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Could not load net system from file " + stringArray[1] + ".");
            System.exit(0);
        }
        object2 = null;
        try {
            object2 = ((ShadowNetSystem)serializable).compile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object2 == null) {
            System.out.println("Could not compile net system.");
            System.exit(0);
        }
        if ((object = ((ShadowLookup)object2).getNet(stringArray[2])) == null) {
            System.out.println("Net system does not contain the net " + stringArray[2] + ".");
            System.exit(0);
        }
        if ((netInstance = SimulatorHelper.fireInitially((Net)object, new ConsoleTracer("Initially", "(0) "), true)) != null) {
            simulator.startRun();
            return;
        }
        System.out.println("The net did not accept the init request.");
    }
}

