/*
 * Decompiled with CFR 0.152.
 */
package de.renew.call;

import de.renew.call.StubParser;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class StubCompiler {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Please provide the names of the stub files to be");
            System.err.println("compiled as arguments to this command. Each file");
            System.err.println("should have the extension '.stub'. The resulting");
            System.err.println("Java sources will be placed in the corresponding");
            System.err.println("'.java' files. No files will be overwritten.");
            System.exit(1);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (!"stub".equals(StringUtil.getExtension(string))) {
                string = String.valueOf(string) + ".stub";
            }
            File file = new File(string);
            String string2 = null;
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                System.out.println("Source file could not be located.");
                System.exit(1);
            }
            String string3 = String.valueOf(StringUtil.getPath(string2)) + File.separator + StringUtil.getFilename(string) + ".java";
            File file2 = new File(string3);
            if (!file.canRead()) {
                System.err.println("Cannot read source file " + string + ". " + "Ignoring this argument.");
            } else if (file2.exists()) {
                System.err.println("Target file " + string3 + " already exists. " + "Ignoring this argument.");
            } else {
                FileReader fileReader = null;
                FileWriter fileWriter = null;
                try {
                    fileReader = new FileReader(file);
                    fileWriter = new FileWriter(file2);
                    StubParser stubParser = new StubParser(fileReader);
                    stubParser.setWriter(fileWriter);
                    stubParser.StubFile();
                    fileReader.close();
                    fileWriter.close();
                    System.err.println("Target file " + string3 + " created.");
                }
                catch (Exception exception) {
                    System.err.println("An error occurred during parsing the stub file.");
                    System.err.println(exception.getMessage());
                    System.err.println("Trying to clean up and continue.");
                    try {
                        fileReader.close();
                    }
                    catch (Exception exception2) {}
                    try {
                        fileWriter.close();
                    }
                    catch (Exception exception3) {}
                    try {
                        if (file2.exists()) {
                            file2.delete();
                        }
                    }
                    catch (Exception exception4) {
                        System.err.println("Could not remove broken file " + string3 + ".");
                    }
                }
            }
            ++n;
        }
    }
}

