/*
 * Decompiled with CFR 0.152.
 */
package de.renew.call;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Hashtable;

class StubGenerator {
    private static String USAGE_MESSAGE = "Required arguments: [-d PATH] CLASS NET {[+]INTERFACE}\n\nCLASS must be a fully qualified class name.\nNET must be a valid net identifier.\nIf an INTERFACE in the list is preceeded by '+',\nits void methods will be designated as 'break void'.\n\nThe resulting stub file will be placed in the directory\nthat corresponds to the package of CLASS, if any.\nIf the -d option if specified, PATH is taken as the root directory\nfor the target stub file, otherwise the current directory.\nNo directory will be created. No files will be overwritten.\n";
    static /* synthetic */ Class class$de$renew$simulator$NetInstance;

    static String complexForPrimitive(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return "Boolean";
        }
        if (clazz == Byte.TYPE) {
            return "Byte";
        }
        if (clazz == Character.TYPE) {
            return "Character";
        }
        if (clazz == Short.TYPE) {
            return "Short";
        }
        if (clazz == Integer.TYPE) {
            return "Integer";
        }
        if (clazz == Long.TYPE) {
            return "Long";
        }
        if (clazz == Float.TYPE) {
            return "Float";
        }
        if (clazz == Double.TYPE) {
            return "Double";
        }
        return "";
    }

    static String getTypeName(Class clazz) {
        int n = 0;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        StringBuffer stringBuffer = new StringBuffer(clazz.getName());
        while (n > 0) {
            stringBuffer.append("[]");
            --n;
        }
        return stringBuffer.toString();
    }

    static String makeSignature(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(StubGenerator.getTypeName(method.getReturnType()));
        stringBuffer.append(" ");
        stringBuffer.append(method.getName());
        stringBuffer.append("(");
        int n = 0;
        while (n < classArray.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(StubGenerator.getTypeName(classArray[n]));
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static void outputMethod(Method method, boolean bl, PrintWriter printWriter) {
        Class<?>[] classArray = method.getParameterTypes();
        StringBuffer stringBuffer = new StringBuffer("  ");
        if (method.getReturnType() == Void.TYPE && bl) {
            stringBuffer.append("break ");
        }
        stringBuffer.append(StubGenerator.getTypeName(method.getReturnType()));
        stringBuffer.append(" ");
        stringBuffer.append(method.getName());
        stringBuffer.append("(");
        int n = 0;
        while (n < classArray.length) {
            if (n > 0) {
                printWriter.println(stringBuffer);
                stringBuffer = new StringBuffer();
                stringBuffer.append("    ");
            }
            String string = String.valueOf(StubGenerator.getTypeName(classArray[n])) + " arg" + n;
            stringBuffer.append(string);
            if (n < classArray.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append(")");
        if (classArray.length > 1) {
            printWriter.println(stringBuffer);
            stringBuffer = new StringBuffer();
            stringBuffer.append(" ");
        }
        stringBuffer.append(" {");
        printWriter.println(stringBuffer);
        stringBuffer = new StringBuffer("    this:");
        stringBuffer.append(method.getName());
        stringBuffer.append("(instance");
        int n2 = 0;
        while (n2 < classArray.length) {
            stringBuffer.append(",arg" + n2);
            ++n2;
        }
        stringBuffer.append(");");
        printWriter.println(stringBuffer);
        if (method.getReturnType() == Void.TYPE) {
            printWriter.println("    this:result(instance);");
        } else {
            printWriter.println("    this:result(instance,return);");
        }
        printWriter.println("  }");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2 || "-d".equals(stringArray[0]) && stringArray.length < 4) {
            System.err.println(USAGE_MESSAGE);
            System.exit(0);
        }
        int n = 0;
        String string = "";
        if ("-d".equals(stringArray[0])) {
            int n2 = ++n;
            ++n;
            string = stringArray[n2].substring(2).trim();
            if (!string.endsWith(File.separator)) {
                string = String.valueOf(string) + File.separator;
            }
        }
        String string2 = stringArray[n++];
        String string3 = String.valueOf(string) + string2.replace('.', File.separatorChar) + ".stub";
        File file = new File(string3);
        if (file.exists()) {
            System.err.println("Target file " + string3 + " already exists. Aborting.");
        }
        String string4 = stringArray[n++];
        PrintWriter printWriter = null;
        try {
            Object object;
            String string5;
            printWriter = new PrintWriter(new FileWriter(file));
            boolean[] blArray = new boolean[stringArray.length - n];
            String[] stringArray2 = new String[stringArray.length - n];
            int n3 = 0;
            while (n < stringArray.length) {
                blArray[n3] = stringArray[n].charAt(0) == '+';
                stringArray2[n3] = blArray[n3] ? stringArray[n].substring(1) : stringArray[n];
                ++n;
                ++n3;
            }
            int n4 = string2.lastIndexOf(".");
            if (n4 > 0) {
                printWriter.println("package " + string2.substring(0, n4) + ";");
                string5 = string2.substring(n4 + 1);
            } else {
                string5 = string2;
            }
            int n5 = stringArray2.length;
            printWriter.println("class " + string5 + " for net " + string4);
            if (n5 > 0) {
                printWriter.println("implements");
                int n6 = 0;
                while (n6 < n5) {
                    if (n6 + 1 < n5) {
                        printWriter.println("  " + stringArray2[n6] + ",");
                    } else {
                        printWriter.println("  " + stringArray2[n6]);
                    }
                    ++n6;
                }
            }
            printWriter.println("{");
            Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
            Method[] methodArray = (class$de$renew$simulator$NetInstance != null ? class$de$renew$simulator$NetInstance : (class$de$renew$simulator$NetInstance = StubGenerator.class$("de.renew.simulator.NetInstance"))).getMethods();
            int n7 = 0;
            while (n7 < methodArray.length) {
                Method method = methodArray[n7];
                object = StubGenerator.makeSignature(method);
                hashtable.put((String)object, Boolean.FALSE);
                ++n7;
            }
            int n8 = 0;
            while (n8 < n5) {
                try {
                    object = Class.forName(stringArray2[n8]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException.toString());
                }
                if (!((Class)object).isInterface()) {
                    throw new RuntimeException("Not an interface: " + stringArray2[n8]);
                }
                Method[] methodArray2 = ((Class)object).getMethods();
                int n9 = 0;
                while (n9 < methodArray2.length) {
                    Method method = methodArray2[n9];
                    String string6 = StubGenerator.makeSignature(method);
                    if (!hashtable.containsKey(string6)) {
                        hashtable.put(string6, new Boolean(blArray[n8]));
                        StubGenerator.outputMethod(method, blArray[n8], printWriter);
                    } else {
                        Boolean bl = (Boolean)hashtable.get(string6);
                        if (method.getReturnType() == Void.TYPE && bl ^ blArray[n8]) {
                            throw new RuntimeException("Method requested twice, but only once as break void. " + string6);
                        }
                    }
                    ++n9;
                }
                ++n8;
            }
            printWriter.println("}");
            printWriter.close();
            return;
        }
        catch (Exception exception) {
            System.err.println("An error occurred during the creation of the stub file.");
            System.err.println(exception.getMessage());
            try {
                printWriter.close();
            }
            catch (Exception exception2) {}
            try {
                if (file.exists()) {
                    file.delete();
                    return;
                }
            }
            catch (Exception exception3) {
                System.err.println("Could not remove broken file " + string3 + ".");
                return;
            }
            return;
        }
    }

    StubGenerator() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

