/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.fs;

import collections.CollectionEnumeration;
import de.renew.formalism.fs.FSNetParser;
import de.renew.formalism.fs.FSShadowCompiler;
import de.renew.formalism.fs.FSShadowLookup;
import de.renew.formalism.fs.ShadowAssoc;
import de.renew.formalism.fs.ShadowConcept;
import de.renew.formalism.fs.ShadowIsa;
import de.renew.formalism.java.InscriptionParser;
import de.renew.formalism.java.JavaNetCompiler;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.shadow.ShadowInscribable;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.SyntaxException;
import de.uni_hamburg.fs.ConceptImpl;
import de.uni_hamburg.fs.ConceptSet;
import de.uni_hamburg.fs.CyclicHierarchyException;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.OrderedTable;
import de.uni_hamburg.fs.Partition;
import de.uni_hamburg.fs.TypeException;
import de.uni_hamburg.fs.TypeSystem;
import java.io.StringReader;

public class FSNetCompiler
extends JavaNetCompiler
implements FSShadowCompiler {
    static final long serialVersionUID = 262012294953452116L;

    public FSNetCompiler() {
        super(false, false);
    }

    protected InscriptionParser makeParser(String string) {
        return new FSNetParser(new StringReader(string));
    }

    protected CollectionEnumeration parseArcInscription(String string, ParsedDeclarationNode parsedDeclarationNode) throws SyntaxException {
        if (string == null || string.equals("")) {
            string = "[]";
        }
        return super.parseArcInscription(string, parsedDeclarationNode);
    }

    public void checkConcept(String string, String string2, ShadowNet shadowNet) throws SyntaxException {
    }

    public synchronized ShadowLookup compile(ShadowNetSystem shadowNetSystem) throws SyntaxException {
        return this.compile(new FSShadowLookup(), shadowNetSystem);
    }

    protected void createNetElements() throws SyntaxException {
        ShadowNetSystem shadowNetSystem = this.getNetSystem();
        Partition partition = new Partition();
        TypeSystem.newInstance();
        CollectionEnumeration collectionEnumeration = shadowNetSystem.elements();
        while (collectionEnumeration.hasMoreElements()) {
            this.compileConcepts((ShadowNet)collectionEnumeration.nextElement(), partition);
        }
        collectionEnumeration = shadowNetSystem.elements();
        while (collectionEnumeration.hasMoreElements()) {
            this.compileApprops((ShadowNet)collectionEnumeration.nextElement());
        }
        collectionEnumeration = shadowNetSystem.elements();
        while (collectionEnumeration.hasMoreElements()) {
            this.compilePartitions((ShadowNet)collectionEnumeration.nextElement());
        }
        collectionEnumeration = shadowNetSystem.elements();
        while (collectionEnumeration.hasMoreElements()) {
            this.compileIsas((ShadowNet)collectionEnumeration.nextElement());
        }
        try {
            TypeSystem.instance().inheritFeatures();
        }
        catch (TypeException typeException) {
            SyntaxException syntaxException = new SyntaxException("Feature \"" + typeException.featureName + "\" has been redefined illegally in concept \"" + typeException.concept.getName() + "\".", null);
            FSShadowLookup fSShadowLookup = (FSShadowLookup)this.getLookup();
            syntaxException.addObject(fSShadowLookup.getApprop(typeException.concept, typeException.featureName));
            throw syntaxException;
        }
        super.createNetElements();
    }

    private void compileConcepts(ShadowNet shadowNet, Partition partition) throws SyntaxException {
        FSShadowLookup fSShadowLookup = (FSShadowLookup)this.getLookup();
        CollectionEnumeration collectionEnumeration = shadowNet.elements();
        while (collectionEnumeration.hasMoreElements()) {
            Object object;
            ShadowNetElement shadowNetElement = (ShadowNetElement)collectionEnumeration.nextElement();
            if (!(shadowNetElement instanceof ShadowConcept)) continue;
            ShadowConcept shadowConcept = (ShadowConcept)shadowNetElement;
            String string = shadowConcept.getName();
            System.out.println("Compiling concept " + string + "...");
            if (TypeSystem.instance().hasConcept(string)) {
                object = new SyntaxException("The concept \"" + string + "\" already exists.", null);
                ((SyntaxException)object).addObject(shadowConcept);
                throw object;
            }
            object = new ConceptImpl(string);
            fSShadowLookup.setConcept(shadowConcept, (ConceptImpl)object);
            if (shadowConcept.elements().hasMoreElements()) continue;
            try {
                partition.addConcept((ConceptImpl)object);
            }
            catch (TypeException typeException) {
                throw new RuntimeException(typeException.toString());
            }
        }
    }

    private void compileApprops(ShadowNet shadowNet) throws SyntaxException {
        Object object;
        Object object2;
        ConceptImpl conceptImpl;
        ShadowInscribable shadowInscribable;
        ShadowNetElement shadowNetElement;
        FSShadowLookup fSShadowLookup = (FSShadowLookup)this.getLookup();
        CollectionEnumeration collectionEnumeration = shadowNet.elements();
        while (collectionEnumeration.hasMoreElements()) {
            Object object3;
            shadowNetElement = (ShadowNetElement)collectionEnumeration.nextElement();
            if (!(shadowNetElement instanceof ShadowConcept)) continue;
            shadowInscribable = (ShadowConcept)shadowNetElement;
            conceptImpl = fSShadowLookup.getConcept((ShadowConcept)shadowInscribable);
            object2 = (FSNetParser)this.makeParser("\n" + ((ShadowConcept)shadowInscribable).getApprop());
            ((FSNetParser)object2).setLookup(fSShadowLookup);
            try {
                object = ((FSNetParser)object2).parseAppropDef();
                conceptImpl.setApprops((OrderedTable)object);
                object3 = ((OrderedTable)object).keys();
                while (object3.hasMoreElements()) {
                    Name name = (Name)object3.nextElement();
                    fSShadowLookup.setApprop(conceptImpl, name, shadowInscribable);
                }
            }
            catch (ParseException parseException) {
                object3 = JavaNetCompiler.makeSyntaxException(parseException);
                ((SyntaxException)object3).addObject(shadowInscribable);
                throw object3;
            }
        }
        collectionEnumeration = shadowNet.elements();
        while (collectionEnumeration.hasMoreElements()) {
            shadowNetElement = (ShadowNetElement)collectionEnumeration.nextElement();
            if (!(shadowNetElement instanceof ShadowAssoc)) continue;
            shadowInscribable = (ShadowAssoc)shadowNetElement;
            conceptImpl = fSShadowLookup.getConcept(((ShadowAssoc)shadowInscribable).getConcept());
            object2 = new ConceptSet(fSShadowLookup.getConcept(((ShadowAssoc)shadowInscribable).getType()));
            object = ((ShadowAssoc)shadowInscribable).getFeature();
            conceptImpl.addApprop((Name)object, (ConceptSet)object2);
            fSShadowLookup.setApprop(conceptImpl, (Name)object, shadowInscribable);
        }
    }

    private void compilePartitions(ShadowNet shadowNet) throws SyntaxException {
        FSShadowLookup fSShadowLookup = (FSShadowLookup)this.getLookup();
        CollectionEnumeration collectionEnumeration = shadowNet.elements();
        while (collectionEnumeration.hasMoreElements()) {
            ShadowIsa shadowIsa;
            ShadowNetElement shadowNetElement = (ShadowNetElement)collectionEnumeration.nextElement();
            if (!(shadowNetElement instanceof ShadowIsa) || !(shadowIsa = (ShadowIsa)shadowNetElement).isDisjunctive()) continue;
            ConceptImpl conceptImpl = fSShadowLookup.getConcept(shadowIsa.getSource());
            ShadowConcept shadowConcept = shadowIsa.getTarget();
            System.out.println("Adding " + conceptImpl.getName() + " to sub-partition of " + shadowConcept.getName());
            try {
                fSShadowLookup.addToSubPartition(shadowConcept, conceptImpl);
            }
            catch (TypeException typeException) {
                SyntaxException syntaxException = new SyntaxException("This disjunction leads to a contradiction.", null);
                syntaxException.addObject(shadowIsa);
                throw syntaxException;
            }
        }
    }

    private void compileIsas(ShadowNet shadowNet) throws SyntaxException {
        FSShadowLookup fSShadowLookup = (FSShadowLookup)this.getLookup();
        CollectionEnumeration collectionEnumeration = shadowNet.elements();
        while (collectionEnumeration.hasMoreElements()) {
            ShadowNetElement shadowNetElement = (ShadowNetElement)collectionEnumeration.nextElement();
            if (!(shadowNetElement instanceof ShadowIsa)) continue;
            ShadowIsa shadowIsa = (ShadowIsa)shadowNetElement;
            ConceptImpl conceptImpl = fSShadowLookup.getConcept(shadowIsa.getSource());
            ShadowConcept shadowConcept = shadowIsa.getTarget();
            ConceptImpl conceptImpl2 = fSShadowLookup.getConcept(shadowConcept);
            System.out.println("Compiling is-a from " + conceptImpl.getName() + " to " + conceptImpl2.getName());
            try {
                conceptImpl.addIsa(conceptImpl2);
            }
            catch (CyclicHierarchyException cyclicHierarchyException) {
                SyntaxException syntaxException = new SyntaxException("This is-a-relation leads to a cyclic type hierarchy.", null);
                syntaxException.addObject(shadowIsa);
                throw syntaxException;
            }
            catch (TypeException typeException) {
                SyntaxException syntaxException = new SyntaxException("This is-a-relation leads to a contradiction.", null);
                syntaxException.addObject(shadowIsa);
                throw syntaxException;
            }
        }
    }
}

