/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.UpdatableSet;
import de.renew.shadow.SyntaxException;

public class ChannelCheckNode {
    public final String name;
    public final int arity;
    private final int hash;
    private int checkState;
    private boolean satisfiable;
    private UpdatableSet invokableChannels;

    public ChannelCheckNode(String string, int n) {
        this.name = string.intern();
        this.arity = n;
        this.hash = string.hashCode() + n * 135;
        this.checkState = 0;
        this.satisfiable = false;
        this.invokableChannels = new HashedSet();
    }

    public void setSatisfiable() {
        this.satisfiable = true;
    }

    public void check() throws SyntaxException {
        String string = this.checkRecursively();
        if (string != null) {
            throw new SyntaxException(string, null);
        }
    }

    public String makeChannelName() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        stringBuffer.append('(');
        int n = 1;
        while (n < this.arity) {
            stringBuffer.append("*,");
            ++n;
        }
        if (this.arity > 0) {
            stringBuffer.append('*');
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String checkRecursively() throws SyntaxException {
        if (this.checkState == 2) {
            return null;
        }
        if (this.checkState == 1) {
            this.checkState = 3;
            return "This completes a cycle.";
        }
        this.checkState = 1;
        CollectionEnumeration collectionEnumeration = this.invokableChannels.elements();
        if (collectionEnumeration.hasMoreElements()) {
            do {
                ChannelCheckNode channelCheckNode;
                if (this.equals(channelCheckNode = (ChannelCheckNode)collectionEnumeration.nextElement())) {
                    throw new SyntaxException("Channel " + this.makeChannelName() + " can invoke itself.", null);
                }
                String string = channelCheckNode.checkRecursively();
                if (string == null) continue;
                string = this.name.equals("") ? "Channel " + channelCheckNode.makeChannelName() + " can be invoked spontaneously.\n" + string : "Channel " + this.makeChannelName() + " can invoke channel " + channelCheckNode.makeChannelName() + ".\n" + string;
                if (this.checkState == 3) {
                    throw new SyntaxException(string, null);
                }
                return string;
            } while (collectionEnumeration.hasMoreElements());
        } else if (!this.satisfiable) {
            throw new SyntaxException("Channel " + this.makeChannelName() + " cannot be satisfied.", null);
        }
        this.checkState = 2;
        return null;
    }

    public void addInvokableChannel(ChannelCheckNode channelCheckNode) {
        this.invokableChannels.include(channelCheckNode);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ChannelCheckNode)) {
            return false;
        }
        ChannelCheckNode channelCheckNode = (ChannelCheckNode)object;
        return this.name.equals(channelCheckNode.name) && this.arity == channelCheckNode.arity;
    }
}

