/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.formalism.java.ArcFactory;
import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.TypedExpression;
import de.renew.function.CastFunction;
import de.renew.shadow.SyntaxException;
import de.renew.simulator.FlexibleArc;
import de.renew.simulator.Place;
import de.renew.simulator.Transition;
import de.renew.simulator.TransitionInscription;
import de.renew.util.Types;
import java.io.Serializable;

public class FlexibleOutArcFactory
implements ArcFactory {
    public static FlexibleOutArcFactory INSTANCE = new FlexibleOutArcFactory();

    private FlexibleOutArcFactory() {
    }

    public void emptyArcCheck() throws SyntaxException {
        throw new SyntaxException("Flexible arcs must be inscribed.", null);
    }

    public void compileArc(Place place, Transition transition, boolean bl, Class clazz, TypedExpression typedExpression) throws SyntaxException {
        Serializable serializable;
        CastFunction castFunction = null;
        Class clazz2 = typedExpression.getType();
        if (!(clazz2 == Types.UNTYPED || clazz2 != null && clazz2.isArray())) {
            throw new SyntaxException("Expression of array type expected.", null);
        }
        if (clazz != Types.UNTYPED) {
            if (!typedExpression.isTyped()) {
                throw new SyntaxException("Output arc expression for typed place must be typed.", null);
            }
            serializable = clazz2.getComponentType();
            if (!Types.allowsLosslessWidening(serializable, clazz)) {
                throw new SyntaxException("Cannot losslessly convert " + JavaHelper.makeTypeErrorString((Class)serializable) + " to " + JavaHelper.makeTypeErrorString(clazz) + ".", null);
            }
            if (clazz.isPrimitive()) {
                castFunction = new CastFunction(clazz);
            }
        }
        serializable = new FlexibleArc(place, 1, typedExpression.getExpression(), castFunction, null);
        ((FlexibleArc)serializable).setTrace(bl);
        transition.add((TransitionInscription)serializable);
    }
}

