/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.expression.CallExpression;
import de.renew.expression.EqualsExpression;
import de.renew.expression.Expression;
import de.renew.expression.InvertibleExpression;
import de.renew.expression.ListExpression;
import de.renew.expression.LocalVariable;
import de.renew.expression.NoArgExpression;
import de.renew.expression.TupleExpression;
import de.renew.expression.TypeCheckingExpression;
import de.renew.expression.VariableExpression;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.formalism.java.PrimaryPart;
import de.renew.formalism.java.Token;
import de.renew.formalism.java.TypedExpression;
import de.renew.function.ArrayFunction;
import de.renew.function.ArrayWriteFunction;
import de.renew.function.CastFunction;
import de.renew.function.ConstructorFunction;
import de.renew.function.DynamicConstructorFunction;
import de.renew.function.DynamicFieldFunction;
import de.renew.function.DynamicFieldWriteFunction;
import de.renew.function.DynamicMethodFunction;
import de.renew.function.DynamicStaticMethodFunction;
import de.renew.function.Executor;
import de.renew.function.FieldFunction;
import de.renew.function.FieldWriteFunction;
import de.renew.function.Function;
import de.renew.function.Identity;
import de.renew.function.MethodFunction;
import de.renew.function.StaticFieldFunction;
import de.renew.function.StaticFieldWriteFunction;
import de.renew.function.StaticMethodFunction;
import de.renew.util.Types;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Vector;

public class JavaHelper {
    public static ParseException makeParseException(String string, Token token) {
        if (token != null) {
            ParseException parseException = new ParseException("Error in line " + token.next.beginLine + ", column " + token.next.beginColumn + ":\n" + string);
            parseException.currentToken = token;
            return parseException;
        }
        return new ParseException(string);
    }

    public static TypedExpression makeTypedBinary(TypedExpression typedExpression, TypedExpression typedExpression2, Function function, Class clazz) {
        return new TypedExpression(clazz, new CallExpression(clazz, new TupleExpression(typedExpression.getExpression(), typedExpression2.getExpression()), function));
    }

    public static TypedExpression makeBooleanBinary(TypedExpression typedExpression, TypedExpression typedExpression2, Function function) {
        return JavaHelper.makeTypedBinary(typedExpression, typedExpression2, function, Boolean.TYPE);
    }

    public static TypedExpression makeBinary(TypedExpression typedExpression, TypedExpression typedExpression2, Function function, Token token) throws ParseException {
        Class<Serializable> clazz;
        if (!typedExpression.isTyped() || !typedExpression2.isTyped()) {
            clazz = Types.UNTYPED;
        } else if (typedExpression.getType() == Boolean.TYPE || typedExpression2.getType() == Boolean.TYPE) {
            if (typedExpression.getType() != Boolean.TYPE || typedExpression2.getType() != Boolean.TYPE) {
                throw JavaHelper.makeParseException("Operator types do not match.", token);
            }
            clazz = Boolean.TYPE;
        } else {
            clazz = typedExpression.getType() == Double.TYPE || typedExpression2.getType() == Double.TYPE ? Double.TYPE : (typedExpression.getType() == Float.TYPE || typedExpression2.getType() == Float.TYPE ? Float.TYPE : (typedExpression.getType() == Long.TYPE || typedExpression2.getType() == Long.TYPE ? Long.TYPE : Integer.TYPE));
        }
        return JavaHelper.makeTypedBinary(typedExpression, typedExpression2, function, clazz);
    }

    public static Class unaryNumericPromotion(Class clazz, Token token) throws ParseException {
        if (clazz == Types.UNTYPED) {
            return clazz;
        }
        if (clazz == null || !clazz.isPrimitive()) {
            throw JavaHelper.makeParseException("Primitive type expected.", token);
        }
        if (clazz == Boolean.TYPE) {
            throw JavaHelper.makeParseException("Numeric type expected.", token);
        }
        if (clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Character.TYPE) {
            return Integer.TYPE;
        }
        return clazz;
    }

    public static Class unaryIntegralPromotion(Class clazz, Token token) throws ParseException {
        if (clazz == Float.TYPE || clazz == Double.TYPE) {
            throw JavaHelper.makeParseException("Integral type expected.", token);
        }
        return JavaHelper.unaryNumericPromotion(clazz, token);
    }

    public static void ensureNonVoid(TypedExpression typedExpression, Token token) throws ParseException {
        if (typedExpression.getType() == Void.TYPE) {
            throw JavaHelper.makeParseException("Expression of type void not allowed here.", token);
        }
    }

    public static void ensureConvertability(Class clazz, TypedExpression typedExpression, Token token) throws ParseException {
        if (typedExpression.isTyped() && !Types.allowsWideningConversion(typedExpression.getType(), clazz)) {
            throw JavaHelper.makeParseException("Cannot convert " + JavaHelper.makeTypeErrorString(typedExpression.getType()) + " to " + JavaHelper.makeTypeErrorString(clazz) + ".", token);
        }
    }

    public static void ensureEnumerateability(TypedExpression typedExpression, Token token) throws ParseException {
        if (typedExpression.isTyped() && (typedExpression.getType() == null || !typedExpression.getType().isPrimitive() || typedExpression.getType() == Double.TYPE || typedExpression.getType() == Float.TYPE)) {
            throw JavaHelper.makeParseException("Enumerable type expected.", token);
        }
    }

    public static void ensureBinaryMatch(TypedExpression typedExpression, TypedExpression typedExpression2, Token token) throws ParseException {
        if (typedExpression.isTyped() && typedExpression2.isTyped()) {
            boolean bl;
            Class clazz = typedExpression.getType();
            Class clazz2 = typedExpression2.getType();
            boolean bl2 = clazz == null || !clazz.isPrimitive();
            boolean bl3 = bl = clazz2 == null || !clazz2.isPrimitive();
            if (bl2 ^ bl) {
                throw JavaHelper.makeParseException("Operator types do not match.", token);
            }
            if (clazz == Boolean.TYPE ^ clazz2 == Boolean.TYPE) {
                throw JavaHelper.makeParseException("Operator types do not match.", token);
            }
        }
    }

    private static boolean allowsInvertibleCast(Class clazz, Class clazz2) {
        if (clazz2.isPrimitive()) {
            return Types.allowsLosslessWidening(clazz, clazz2);
        }
        if (clazz == null) {
            return true;
        }
        return !clazz.isPrimitive();
    }

    public static TypedExpression makeExplicitCastExpression(Class clazz, TypedExpression typedExpression, Token token) throws ParseException {
        if (typedExpression.getType() == clazz) {
            return typedExpression;
        }
        if (!typedExpression.isTyped()) {
            if (clazz.isPrimitive()) {
                return new TypedExpression(clazz, new CallExpression(clazz, typedExpression.getExpression(), new CastFunction(clazz)));
            }
            return new TypedExpression(clazz, new TypeCheckingExpression(clazz, typedExpression.getExpression()));
        }
        if (Types.allowsCast(typedExpression.getType(), clazz)) {
            if (clazz.isPrimitive()) {
                if (typedExpression.getType() == null) {
                    return new TypedExpression(clazz, typedExpression.getExpression());
                }
                if (Types.allowsLosslessWidening(typedExpression.getType(), clazz)) {
                    return new TypedExpression(clazz, new InvertibleExpression(clazz, typedExpression.getExpression(), new CastFunction(clazz), new CastFunction(typedExpression.getType())));
                }
                return new TypedExpression(clazz, new CallExpression(clazz, typedExpression.getExpression(), new CastFunction(clazz)));
            }
            return new TypedExpression(clazz, new TypeCheckingExpression(clazz, JavaHelper.makeGuardedExpression(typedExpression)));
        }
        throw JavaHelper.makeParseException("Cannot cast " + typedExpression.getType() + " to " + clazz + ".", token);
    }

    public static Expression[] makeExpressionArray(Vector vector) {
        Expression[] expressionArray = new Expression[vector.size()];
        int n = 0;
        while (n < expressionArray.length) {
            TypedExpression typedExpression = (TypedExpression)vector.elementAt(n);
            expressionArray[n] = typedExpression.getExpression();
            ++n;
        }
        return expressionArray;
    }

    public static TupleExpression makeTupleExpression(Vector vector) {
        return new TupleExpression(JavaHelper.makeExpressionArray(vector));
    }

    public static ListExpression makeListExpression(Vector vector, boolean bl) {
        return new ListExpression(JavaHelper.makeExpressionArray(vector), bl);
    }

    public static Expression makeGuardedExpression(TypedExpression typedExpression) {
        if (typedExpression.isTyped() && typedExpression.getType() != null) {
            return new TypeCheckingExpression(typedExpression.getType(), typedExpression.getExpression());
        }
        return typedExpression.getExpression();
    }

    public static TupleExpression makeGuardedTupleExpression(Vector vector) {
        Expression[] expressionArray = new Expression[vector.size()];
        int n = 0;
        while (n < expressionArray.length) {
            expressionArray[n] = JavaHelper.makeGuardedExpression((TypedExpression)vector.elementAt(n));
            ++n;
        }
        return new TupleExpression(expressionArray);
    }

    public static Class[] makeTypeArray(Vector vector) {
        Class[] classArray = new Class[vector.size()];
        int n = 0;
        while (n < classArray.length) {
            TypedExpression typedExpression = (TypedExpression)vector.elementAt(n);
            if (!typedExpression.isTyped()) {
                return null;
            }
            classArray[n] = typedExpression.getType();
            ++n;
        }
        return classArray;
    }

    public static Class increaseArrayLevel(Class clazz, Token token) throws ParseException {
        try {
            return Array.newInstance(clazz, 0).getClass();
        }
        catch (Exception exception) {
            throw JavaHelper.makeParseException("Could not create class.", token);
        }
    }

    public static String makeTypeErrorString(Class clazz) {
        if (clazz == null) {
            return "a null expression";
        }
        if (clazz == Types.UNTYPED) {
            return "an untyped expression";
        }
        String string = "";
        while (clazz.isArray()) {
            string = String.valueOf(string) + "[]";
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            return "an expression of type " + clazz + string;
        }
        return "an expression of " + clazz + string;
    }

    private static TypedExpression makeTypedEquality(TypedExpression typedExpression, TypedExpression typedExpression2, Token token) throws ParseException {
        Class clazz = typedExpression.getType();
        Class clazz2 = typedExpression2.getType();
        Expression expression = clazz2 == null ? typedExpression2.getExpression() : (clazz2.isPrimitive() ? new InvertibleExpression(clazz, typedExpression2.getExpression(), new CastFunction(clazz), new CastFunction(clazz2)) : JavaHelper.makeGuardedExpression(typedExpression2));
        return new TypedExpression(typedExpression.getType(), new EqualsExpression(typedExpression.getType(), typedExpression.getExpression(), expression));
    }

    public static TypedExpression makeEqualityAssertion(TypedExpression typedExpression, TypedExpression typedExpression2, Token token) throws ParseException {
        Class clazz = typedExpression.getType();
        Class clazz2 = typedExpression2.getType();
        if (clazz == Void.TYPE || clazz2 == Void.TYPE) {
            throw JavaHelper.makeParseException("Expression of type void not allowed here.", token);
        }
        if (!typedExpression.isTyped() || !typedExpression2.isTyped() || Types.allowsIdentityConversion(clazz, clazz2)) {
            return new TypedExpression(clazz, new EqualsExpression(clazz, JavaHelper.makeGuardedExpression(typedExpression), JavaHelper.makeGuardedExpression(typedExpression2)));
        }
        if (Types.allowsLosslessWidening(clazz2, clazz)) {
            return JavaHelper.makeTypedEquality(typedExpression, typedExpression2, token);
        }
        if (Types.allowsLosslessWidening(clazz, clazz2)) {
            return JavaHelper.makeTypedEquality(typedExpression2, typedExpression, token);
        }
        throw JavaHelper.makeParseException("Type mismatch in assignment.", token);
    }

    public static TypedExpression makeSinglePartExpression(PrimaryPart primaryPart, TypedExpression typedExpression, ParsedDeclarationNode parsedDeclarationNode) throws ParseException {
        switch (primaryPart.type) {
            case 3: {
                if (typedExpression == null) {
                    return (TypedExpression)primaryPart.obj;
                }
                throw JavaHelper.makeParseException("Invalid left hand side of assignment.", primaryPart.token);
            }
            case 0: {
                Object object = parsedDeclarationNode.interpreteName((String)primaryPart.obj);
                if (object instanceof LocalVariable) {
                    Class clazz = parsedDeclarationNode.findType((LocalVariable)object);
                    if (typedExpression == null) {
                        return new TypedExpression(clazz, new VariableExpression(clazz, (LocalVariable)object));
                    }
                    if (clazz == Types.UNTYPED) {
                        return new TypedExpression(clazz, new EqualsExpression(clazz, new VariableExpression(clazz, (LocalVariable)object), new CallExpression(typedExpression.getType(), typedExpression.getExpression(), Identity.FUN)));
                    }
                    if (typedExpression.isTyped() && Types.allowsWideningConversion(typedExpression.getType(), clazz)) {
                        return new TypedExpression(clazz, new EqualsExpression(clazz, new VariableExpression(clazz, (LocalVariable)object), new CallExpression(typedExpression.getType(), typedExpression.getExpression(), new CastFunction(clazz))));
                    }
                    throw JavaHelper.makeParseException("Cannot assign " + JavaHelper.makeTypeErrorString(typedExpression.getType()) + " to " + JavaHelper.makeTypeErrorString(clazz) + ".", primaryPart.token);
                }
                throw JavaHelper.makeParseException("No such variable.", primaryPart.token);
            }
        }
        throw new RuntimeException("Malformed primary vector.");
    }

    public static TypedExpression makeConstructorExpression(Class clazz, Vector vector, Token token) throws ParseException {
        Class[] classArray = JavaHelper.makeTypeArray(vector);
        if (classArray != null) {
            Constructor constructor = null;
            try {
                constructor = Executor.findBestConstructor(clazz, classArray, true);
                if (constructor == null) {
                    throw JavaHelper.makeParseException("Multiple constructors match.", token);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw JavaHelper.makeParseException("No such constructor.", token);
            }
            return new TypedExpression(clazz, new CallExpression(clazz, JavaHelper.makeTupleExpression(vector), new ConstructorFunction(constructor)));
        }
        return new TypedExpression(clazz, new CallExpression(clazz, JavaHelper.makeTupleExpression(vector), new DynamicConstructorFunction(clazz)));
    }

    public static TypedExpression makeMethodCall(TypedExpression typedExpression, Class clazz, String string, Vector vector, Token token) throws ParseException {
        Method method;
        if (clazz != null) {
            throw JavaHelper.makeParseException("Calls to super object are not supported.", token);
        }
        Class clazz2 = typedExpression.getType();
        if (clazz2 == null) {
            throw JavaHelper.makeParseException("Cannot invoke method on null object.", token);
        }
        Class[] classArray = JavaHelper.makeTypeArray(vector);
        if (classArray == null || !typedExpression.isTyped()) {
            if (clazz != null) {
                throw JavaHelper.makeParseException("Cannot invoke super method with untyped arguments.", token);
            }
            return new TypedExpression(Types.UNTYPED, new CallExpression(Types.UNTYPED, new TupleExpression(typedExpression.getExpression(), JavaHelper.makeTupleExpression(vector)), new DynamicMethodFunction(string)));
        }
        if (clazz != null) {
            clazz2 = clazz;
        }
        try {
            method = Executor.findBestMethod(clazz2, string, classArray, true);
            if (method == null) {
                throw JavaHelper.makeParseException("Multiple methods match.", token);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw JavaHelper.makeParseException("No such method.", token);
        }
        return new TypedExpression(method.getReturnType(), new CallExpression(method.getReturnType(), new TupleExpression(typedExpression.getExpression(), JavaHelper.makeTupleExpression(vector)), new MethodFunction(method)));
    }

    public static TypedExpression makeExpression(Vector vector, TypedExpression typedExpression, ParsedDeclarationNode parsedDeclarationNode, Token token) throws ParseException {
        Object object;
        Object object2;
        Object object3;
        if (typedExpression != null) {
            JavaHelper.ensureNonVoid(typedExpression, token);
        }
        PrimaryPart primaryPart = (PrimaryPart)vector.elementAt(0);
        if (vector.size() == 1) {
            return JavaHelper.makeSinglePartExpression(primaryPart, typedExpression, parsedDeclarationNode);
        }
        int n = vector.size();
        if (typedExpression != null) {
            --n;
        }
        int n2 = 1;
        Object object4 = null;
        switch (primaryPart.type) {
            case 3: {
                object4 = primaryPart.obj;
                break;
            }
            case 0: {
                object3 = (String)primaryPart.obj;
                object4 = parsedDeclarationNode.interpreteName((String)object3);
                int n3 = n2;
                while (n2 < n) {
                    object2 = (PrimaryPart)vector.elementAt(n2);
                    ++n2;
                    if (((PrimaryPart)object2).type != 0) break;
                    object = parsedDeclarationNode.interpreteName((String)(object3 = String.valueOf(object3) + "." + (String)((PrimaryPart)object2).obj));
                    if (object == null) continue;
                    object4 = object;
                    n3 = n2;
                }
                n2 = n3;
                break;
            }
            default: {
                throw new RuntimeException("Malformed primary vector.");
            }
        }
        if (object4 == null) {
            throw JavaHelper.makeParseException("No such class or variable.", primaryPart.token);
        }
        if (object4 instanceof LocalVariable) {
            object3 = parsedDeclarationNode.findType((LocalVariable)object4);
            object4 = new TypedExpression((Class)object3, new VariableExpression((Class)object3, (LocalVariable)object4));
        }
        while (n2 < n) {
            object3 = (PrimaryPart)vector.elementAt(n2);
            ++n2;
            switch (((PrimaryPart)object3).type) {
                case 3: {
                    throw new RuntimeException("Malformed primary vector.");
                }
                case 0: {
                    Vector vector2 = null;
                    if (n2 < vector.size()) {
                        object2 = (PrimaryPart)vector.elementAt(n2);
                        if (((PrimaryPart)object2).type == 2) {
                            ++n2;
                            vector2 = (Vector)((PrimaryPart)object2).obj;
                        }
                    }
                    if (vector2 != null) {
                        if (object4 instanceof Class) {
                            object2 = JavaHelper.makeTypeArray(vector2);
                            if (object2 == null) {
                                object4 = new TypedExpression(Types.UNTYPED, new CallExpression(Types.UNTYPED, JavaHelper.makeTupleExpression(vector2), new DynamicStaticMethodFunction((String)((PrimaryPart)object3).obj, (Class)object4)));
                                break;
                            }
                            try {
                                object = Executor.findBestMethod((Class)object4, (String)((PrimaryPart)object3).obj, (Class[])object2, true);
                                if (object == null) {
                                    throw JavaHelper.makeParseException("Multiple methods match.", ((PrimaryPart)object3).token);
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                throw JavaHelper.makeParseException("No such method.", ((PrimaryPart)object3).token);
                            }
                            if ((((Method)object).getModifiers() & 8) == 0) {
                                throw JavaHelper.makeParseException("Cannot make static call to instance method.", ((PrimaryPart)object3).token);
                            }
                            object4 = new TypedExpression(((Method)object).getReturnType(), new CallExpression(((Method)object).getReturnType(), JavaHelper.makeTupleExpression(vector2), new StaticMethodFunction((Method)object)));
                            break;
                        }
                        object4 = JavaHelper.makeMethodCall((TypedExpression)object4, null, (String)((PrimaryPart)object3).obj, vector2, ((PrimaryPart)object3).token);
                        break;
                    }
                    if (object4 instanceof Class) {
                        object2 = (Class)object4;
                        object = null;
                        try {
                            object = ((Class)object2).getField((String)((PrimaryPart)object3).obj);
                        }
                        catch (Exception exception) {
                            throw JavaHelper.makeParseException("No such field.", ((PrimaryPart)object3).token);
                        }
                        object4 = new TypedExpression(((Field)object).getType(), new NoArgExpression(((Field)object).getType(), new StaticFieldFunction((Field)object)));
                        break;
                    }
                    if (((TypedExpression)object4).isTyped()) {
                        object2 = ((TypedExpression)object4).getType();
                        if (object2 == null) {
                            throw JavaHelper.makeParseException("Cannot access field of null object.", ((PrimaryPart)object3).token);
                        }
                        object = null;
                        try {
                            object = ((Class)object2).getField((String)((PrimaryPart)object3).obj);
                        }
                        catch (Exception exception) {
                            throw JavaHelper.makeParseException("No such field.", ((PrimaryPart)object3).token);
                        }
                        object4 = new TypedExpression(((Field)object).getType(), new CallExpression(((Field)object).getType(), ((TypedExpression)object4).getExpression(), new FieldFunction((Field)object)));
                        break;
                    }
                    object4 = new TypedExpression(Types.UNTYPED, new CallExpression(Types.UNTYPED, ((TypedExpression)object4).getExpression(), new DynamicFieldFunction((String)((PrimaryPart)object3).obj)));
                    break;
                }
                case 1: {
                    if (!(object4 instanceof TypedExpression)) {
                        throw JavaHelper.makeParseException("No such class or variable.", ((PrimaryPart)object3).token);
                    }
                    object2 = Types.UNTYPED;
                    if (((TypedExpression)object4).isTyped()) {
                        object2 = ((TypedExpression)object4).getType();
                        if (!((Class)object2).isArray()) {
                            throw JavaHelper.makeParseException("Not an array.", ((PrimaryPart)object3).token);
                        }
                        object2 = ((Class)object2).getComponentType();
                    }
                    JavaHelper.ensureConvertability(Integer.TYPE, (TypedExpression)((PrimaryPart)object3).obj, ((PrimaryPart)object3).token);
                    object4 = new TypedExpression((Class)object2, new CallExpression((Class)object2, new TupleExpression(((TypedExpression)object4).getExpression(), ((TypedExpression)((PrimaryPart)object3).obj).getExpression()), ArrayFunction.FUN));
                    break;
                }
                case 2: {
                    throw JavaHelper.makeParseException("Bad method call or no such method.", ((PrimaryPart)object3).token);
                }
                default: {
                    throw new RuntimeException("Malformed primary vector.");
                }
            }
        }
        if (typedExpression != null) {
            if (n2 == vector.size()) {
                throw JavaHelper.makeParseException("Invalid left hand side of assignment.", token);
            }
            object3 = (PrimaryPart)vector.elementAt(n2);
            switch (((PrimaryPart)object3).type) {
                case 0: {
                    if (object4 instanceof TypedExpression) {
                        if (((TypedExpression)object4).isTyped()) {
                            Class clazz = ((TypedExpression)object4).getType();
                            object2 = null;
                            try {
                                object2 = clazz.getField((String)((PrimaryPart)object3).obj);
                            }
                            catch (Exception exception) {
                                throw JavaHelper.makeParseException("No such field.", ((PrimaryPart)object3).token);
                            }
                            JavaHelper.ensureConvertability(((Field)object2).getType(), typedExpression, token);
                            object4 = new TypedExpression(((Field)object2).getType(), new CallExpression(((Field)object2).getType(), new TupleExpression(((TypedExpression)object4).getExpression(), typedExpression.getExpression()), new FieldWriteFunction((Field)object2)));
                            break;
                        }
                        object4 = new TypedExpression(Types.UNTYPED, new CallExpression(Types.UNTYPED, new TupleExpression(((TypedExpression)object4).getExpression(), typedExpression.getExpression()), new DynamicFieldWriteFunction((String)((PrimaryPart)object3).obj)));
                        break;
                    }
                    Class clazz = (Class)object4;
                    object2 = null;
                    try {
                        object2 = clazz.getField((String)((PrimaryPart)object3).obj);
                    }
                    catch (Exception exception) {
                        throw JavaHelper.makeParseException("No such field.", ((PrimaryPart)object3).token);
                    }
                    JavaHelper.ensureConvertability(((Field)object2).getType(), typedExpression, token);
                    object4 = new TypedExpression(((Field)object2).getType(), new CallExpression(((Field)object2).getType(), typedExpression.getExpression(), new StaticFieldWriteFunction((Field)object2)));
                    break;
                }
                case 1: {
                    if (!(object4 instanceof TypedExpression)) {
                        throw JavaHelper.makeParseException("No such class or variable.", ((PrimaryPart)object3).token);
                    }
                    Class clazz = Types.UNTYPED;
                    if (((TypedExpression)object4).isTyped()) {
                        clazz = ((TypedExpression)object4).getType();
                        if (!clazz.isArray()) {
                            throw JavaHelper.makeParseException("Not an array.", ((PrimaryPart)object3).token);
                        }
                        clazz = clazz.getComponentType();
                    }
                    JavaHelper.ensureConvertability(Integer.TYPE, (TypedExpression)((PrimaryPart)object3).obj, ((PrimaryPart)object3).token);
                    JavaHelper.ensureConvertability(clazz, typedExpression, token);
                    object4 = new TypedExpression(clazz, new CallExpression(clazz, new TupleExpression(((TypedExpression)object4).getExpression(), ((TypedExpression)((PrimaryPart)object3).obj).getExpression(), typedExpression.getExpression()), ArrayWriteFunction.FUN));
                    break;
                }
                default: {
                    throw new RuntimeException("Malformed primary vector.");
                }
            }
        }
        if (!(object4 instanceof TypedExpression)) {
            throw JavaHelper.makeParseException("No such class or variable.", primaryPart.token);
        }
        return (TypedExpression)object4;
    }
}

