/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.LinkedList;
import de.renew.expression.ConstantExpression;
import de.renew.expression.Expression;
import de.renew.expression.VariableExpression;
import de.renew.formalism.java.ArcFactory;
import de.renew.formalism.java.ChannelCheckNode;
import de.renew.formalism.java.ChannelInscription;
import de.renew.formalism.java.FlexibleInArcFactory;
import de.renew.formalism.java.FlexibleOutArcFactory;
import de.renew.formalism.java.ImportCompiler;
import de.renew.formalism.java.InscriptionParser;
import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.JavaNetHelper;
import de.renew.formalism.java.JavaNetParser;
import de.renew.formalism.java.NameInterpreter;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.formalism.java.SimpleArcFactory;
import de.renew.formalism.java.Token;
import de.renew.formalism.java.TypedExpression;
import de.renew.shadow.ShadowArc;
import de.renew.shadow.ShadowCompiler;
import de.renew.shadow.ShadowDeclarationNode;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.ShadowNode;
import de.renew.shadow.ShadowPlace;
import de.renew.shadow.ShadowTransition;
import de.renew.shadow.SyntaxException;
import de.renew.simulator.ClearArc;
import de.renew.simulator.ExpressionTokenSource;
import de.renew.simulator.Net;
import de.renew.simulator.Place;
import de.renew.simulator.Transition;
import de.renew.simulator.TransitionInscription;
import de.renew.simulator.UplinkInscription;
import de.renew.unify.Tuple;
import de.renew.util.EmptyEnumeration;
import de.renew.util.SingletonEnumeration;
import de.renew.util.Types;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;

public class JavaNetCompiler
implements ShadowCompiler,
ImportCompiler {
    private boolean allowDangerousArcs = false;
    private boolean wantEarlyTokens = false;
    static final long serialVersionUID = 6357839474457945975L;
    private transient ShadowLookup lookup;
    private transient Hashtable placeTypes;
    private transient ShadowNetSystem netSystem;
    private transient int placeNum;
    private transient int transitionNum;
    private static final String[] lintNames = new String[]{"channel check", "name check"};
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$de$renew$unify$Tuple;

    public JavaNetCompiler() {
        this(false, false);
    }

    public JavaNetCompiler(boolean bl, boolean bl2) {
        this.allowDangerousArcs = bl;
        this.wantEarlyTokens = bl2;
    }

    protected InscriptionParser makeParser(String string) {
        return new JavaNetParser(new StringReader(string));
    }

    public static SyntaxException makeSyntaxException(ParseException parseException) {
        Token token = parseException.currentToken.next;
        return new SyntaxException(parseException.getMessage(), null, token.beginLine, token.beginColumn);
    }

    public NameInterpreter compileImports(ShadowDeclarationNode shadowDeclarationNode) throws SyntaxException {
        try {
            return this.parseDeclarationNode(shadowDeclarationNode.inscr);
        }
        catch (SyntaxException syntaxException) {
            throw syntaxException.addObject(shadowDeclarationNode);
        }
    }

    public void checkDeclarationNode(String string) throws SyntaxException {
        this.parseDeclarationNode(string);
    }

    public void checkArcInscription(String string, ShadowNet shadowNet) throws SyntaxException {
        this.parseArcInscription(string, this.makeDeclarationNode(shadowNet));
    }

    public void checkTransitionInscription(String string, ShadowNet shadowNet) throws SyntaxException {
        this.makeInscriptions(string, null, false, this.makeDeclarationNode(shadowNet));
    }

    public void checkPlaceInscription(String string, ShadowNet shadowNet) throws SyntaxException {
        ParsedDeclarationNode parsedDeclarationNode = this.makeDeclarationNode(shadowNet);
        this.parsePlaceInscription(string, parsedDeclarationNode);
    }

    ParsedDeclarationNode compile(ShadowDeclarationNode shadowDeclarationNode) throws SyntaxException {
        try {
            return this.parseDeclarationNode(shadowDeclarationNode.inscr);
        }
        catch (SyntaxException syntaxException) {
            throw syntaxException.addObject(shadowDeclarationNode);
        }
    }

    void compile(ShadowPlace shadowPlace, ParsedDeclarationNode parsedDeclarationNode, Net net) throws SyntaxException {
        Class<Object> clazz;
        String string = shadowPlace.getName();
        if (string == null) {
            ++this.placeNum;
            string = "P" + this.placeNum;
        }
        Place place = new Place(net, string);
        place.setID(shadowPlace.getID());
        place.setTrace(shadowPlace.getTrace());
        this.lookup.set(shadowPlace, place);
        Vector vector = new Vector();
        Vector<Class> vector2 = new Vector<Class>();
        CollectionEnumeration collectionEnumeration = shadowPlace.elements();
        while (collectionEnumeration.hasMoreElements()) {
            clazz = collectionEnumeration.nextElement();
            if (clazz instanceof ShadowInscription) {
                String string2 = ((ShadowInscription)((Object)clazz)).inscr;
                try {
                    CollectionEnumeration collectionEnumeration2 = this.parsePlaceInscription(string2, parsedDeclarationNode);
                    while (collectionEnumeration2.hasMoreElements()) {
                        vector.addElement(collectionEnumeration2.nextElement());
                        vector2.addElement(clazz);
                    }
                    continue;
                }
                catch (SyntaxException syntaxException) {
                    throw syntaxException.addObject((ShadowInscription)((Object)clazz));
                }
            }
            throw new SyntaxException("Unsupported place inscription", null).addObject(shadowPlace).addObject(clazz);
        }
        clazz = Types.UNTYPED;
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) instanceof Class) {
                clazz = (Class)vector.elementAt(n2);
                ++n;
            }
            ++n2;
        }
        if (n > 1) {
            SyntaxException syntaxException = new SyntaxException("Place is typed more than once.", null);
            int n3 = 0;
            while (n3 < vector.size()) {
                if (vector.elementAt(n3) instanceof Class) {
                    syntaxException.addObject(vector2.elementAt(n3));
                }
                ++n3;
            }
            throw syntaxException;
        }
        if (clazz != Types.UNTYPED) {
            this.placeTypes.put(shadowPlace, clazz);
        }
        int n4 = 0;
        while (n4 < vector.size()) {
            if (vector.elementAt(n4) instanceof TypedExpression) {
                TypedExpression typedExpression = (TypedExpression)vector.elementAt(n4);
                Expression expression = null;
                try {
                    expression = JavaNetHelper.makeCastedOutputExpression(clazz, typedExpression);
                }
                catch (SyntaxException syntaxException) {
                    throw syntaxException.addObject(vector2.elementAt(n4));
                }
                place.add(new ExpressionTokenSource(expression));
            }
            ++n4;
        }
    }

    Class getType(ShadowPlace shadowPlace) {
        if (this.placeTypes.containsKey(shadowPlace)) {
            return (Class)this.placeTypes.get(shadowPlace);
        }
        return Types.UNTYPED;
    }

    /*
     * Unable to fully structure code
     */
    void compile(ShadowTransition var1_1, ParsedDeclarationNode var2_2, Net var3_3) throws SyntaxException {
        var4_4 = var1_1.getName();
        if (var4_4 == null) {
            ++this.transitionNum;
            var4_4 = "T" + this.transitionNum;
        }
        var5_5 = new Transition(var3_3, var4_4);
        var5_5.setID(var1_1.getID());
        var5_5.setTrace(var1_1.getTrace());
        this.lookup.set(var1_1, var5_5);
        var6_6 = new Vector<E>();
        var7_7 = new Vector<ShadowInscription>();
        var8_8 = var1_1.elements();
        while (var8_8.hasMoreElements()) {
            block12: {
                var9_9 = var8_8.nextElement();
                if (!(var9_9 instanceof ShadowInscription)) break block12;
                var10_11 = (ShadowInscription)var9_9;
                var11_13 = null;
                try {
                    var11_13 = this.makeInscriptions(var10_11.inscr, this.lookup, true, var2_2);
                    if (true) ** GOTO lbl25
                }
                catch (SyntaxException var12_15) {
                    throw var12_15.addObject(var10_11);
                }
                do {
                    var6_6.addElement(var11_13.nextElement());
                    var7_7.addElement(var10_11);
lbl25:
                    // 2 sources

                } while (var11_13.hasMoreElements());
                continue;
            }
            if (var9_9 instanceof ShadowArc) {
                this.compile((ShadowArc)var9_9, var2_2);
                continue;
            }
            throw new SyntaxException("Unsupported transition inscription", null).addObject(var1_1).addObject(var9_9);
        }
        var9_10 = 0;
        var10_12 = 0;
        while (var10_12 < var6_6.size()) {
            if (var6_6.elementAt(var10_12) instanceof UplinkInscription) {
                ++var9_10;
            }
            ++var10_12;
        }
        if (var9_10 > 1) {
            var11_13 = new SyntaxException("Transition has more than one uplink.", null);
            var12_16 = 0;
            while (var12_16 < var6_6.size()) {
                if (var6_6.elementAt(var12_16) instanceof UplinkInscription) {
                    var11_13.addObject(var7_7.elementAt(var12_16));
                }
                ++var12_16;
            }
            throw var11_13;
        }
        var11_14 = 0;
        while (var11_14 < var6_6.size()) {
            var5_5.add((TransitionInscription)var6_6.elementAt(var11_14));
            ++var11_14;
        }
    }

    protected ShadowInscription getSingleArcInscription(ShadowArc shadowArc) throws SyntaxException {
        CollectionEnumeration collectionEnumeration = shadowArc.elements();
        if (collectionEnumeration.numberOfRemainingElements() > 1) {
            SyntaxException syntaxException = new SyntaxException("This arc must not be inscribed multiple times.", null).addObject(shadowArc);
            while (collectionEnumeration.hasMoreElements()) {
                syntaxException.addObject((ShadowInscription)collectionEnumeration.nextElement());
            }
            throw syntaxException;
        }
        new EmptyEnumeration();
        if (collectionEnumeration.hasMoreElements()) {
            return (ShadowInscription)collectionEnumeration.nextElement();
        }
        return null;
    }

    protected TypedExpression parseVariable(String string, ParsedDeclarationNode parsedDeclarationNode) throws SyntaxException {
        InscriptionParser inscriptionParser = this.makeParser(string);
        inscriptionParser.setDeclarationNode(parsedDeclarationNode);
        try {
            return inscriptionParser.VariableInscription();
        }
        catch (ParseException parseException) {
            throw JavaNetCompiler.makeSyntaxException(parseException);
        }
    }

    protected void compileClearArc(ShadowArc shadowArc, ParsedDeclarationNode parsedDeclarationNode) throws SyntaxException {
        Class<?> clazz;
        TypedExpression typedExpression;
        Transition transition = this.lookup.get(shadowArc.transition);
        Place place = this.lookup.get(shadowArc.place);
        Class<?> clazz2 = this.getType(shadowArc.place);
        ShadowInscription shadowInscription = this.getSingleArcInscription(shadowArc);
        String string = null;
        if (shadowInscription != null) {
            string = shadowInscription.inscr;
        }
        if (string == null || string.equals("")) {
            ClearArc clearArc = new ClearArc(place, new VariableExpression(Types.UNTYPED, null), class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = JavaNetCompiler.class$("java.lang.Object")));
            clearArc.setTrace(shadowArc.getTrace());
            transition.add(clearArc);
            return;
        }
        try {
            typedExpression = this.parseVariable(string, parsedDeclarationNode);
        }
        catch (SyntaxException syntaxException) {
            throw syntaxException.addObject(shadowInscription);
        }
        Class clazz3 = typedExpression.getType();
        if (clazz2 == Types.UNTYPED) {
            if (clazz3 != Types.UNTYPED) {
                throw new SyntaxException("Cannot clear untyped place using typed variable.", null).addObject(shadowArc);
            }
            clazz = class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = JavaNetCompiler.class$("java.lang.Object"));
        } else if (clazz3 == Types.UNTYPED) {
            clazz = clazz2;
        } else {
            if (!clazz3.isArray()) {
                throw new SyntaxException("Variable of array type expected.", null).addObject(shadowInscription);
            }
            clazz = clazz3.getComponentType();
            if (!Types.allowsLosslessWidening(clazz2, clazz)) {
                throw new SyntaxException("Cannot losslessly convert " + JavaHelper.makeTypeErrorString(clazz2) + " to " + JavaHelper.makeTypeErrorString(clazz) + ".", null).addObject(shadowInscription);
            }
        }
        ClearArc clearArc = new ClearArc(place, typedExpression.getExpression(), clazz);
        clearArc.setTrace(shadowArc.getTrace());
        transition.add(clearArc);
    }

    protected CollectionEnumeration makeArcExpression(String string, ParsedDeclarationNode parsedDeclarationNode) throws SyntaxException {
        CollectionEnumeration collectionEnumeration = this.parseArcInscription(string, parsedDeclarationNode);
        LinkedList linkedList = new LinkedList();
        while (collectionEnumeration.hasMoreElements()) {
            TypedExpression typedExpression = (TypedExpression)collectionEnumeration.nextElement();
            if (typedExpression.getType() == Void.TYPE) {
                throw new SyntaxException("Cannot use void expressions as arc inscriptions.", null);
            }
            linkedList.insertFirst(typedExpression);
        }
        return linkedList.elements();
    }

    protected CollectionEnumeration makeEmptyArcExpression(ParsedDeclarationNode parsedDeclarationNode) throws SyntaxException {
        return this.makeArcExpression(null, parsedDeclarationNode);
    }

    protected void compileSingleArcInscription(CollectionEnumeration collectionEnumeration, Class clazz, ArcFactory arcFactory, Place place, Transition transition, boolean bl) throws SyntaxException {
        while (collectionEnumeration.hasMoreElements()) {
            TypedExpression typedExpression = (TypedExpression)collectionEnumeration.nextElement();
            arcFactory.compileArc(place, transition, bl, clazz, typedExpression);
        }
    }

    protected void compileArcInscriptions(ShadowArc shadowArc, ArcFactory arcFactory, ParsedDeclarationNode parsedDeclarationNode) throws SyntaxException {
        Transition transition = this.lookup.get(shadowArc.transition);
        Place place = this.lookup.get(shadowArc.place);
        CollectionEnumeration collectionEnumeration = shadowArc.elements();
        if (collectionEnumeration.hasMoreElements()) {
            do {
                ShadowInscription shadowInscription = (ShadowInscription)collectionEnumeration.nextElement();
                try {
                    this.compileSingleArcInscription(this.makeArcExpression(shadowInscription.inscr, parsedDeclarationNode), this.getType(shadowArc.place), arcFactory, place, transition, shadowArc.getTrace());
                }
                catch (SyntaxException syntaxException) {
                    throw syntaxException.addObject(shadowInscription);
                }
            } while (collectionEnumeration.hasMoreElements());
            return;
        }
        try {
            arcFactory.emptyArcCheck();
            this.compileSingleArcInscription(this.makeEmptyArcExpression(parsedDeclarationNode), this.getType(shadowArc.place), arcFactory, place, transition, shadowArc.getTrace());
            return;
        }
        catch (SyntaxException syntaxException) {
            throw syntaxException.addObject(shadowArc);
        }
    }

    protected void compile(ShadowArc shadowArc, ParsedDeclarationNode parsedDeclarationNode) throws SyntaxException {
        switch (shadowArc.shadowArcType) {
            case 0: {
                this.compileArcInscriptions(shadowArc, new SimpleArcFactory(0), parsedDeclarationNode);
                return;
            }
            case 2: {
                this.compileArcInscriptions(shadowArc, new SimpleArcFactory(2), parsedDeclarationNode);
                return;
            }
            case 1: {
                this.compileArcInscriptions(shadowArc, new SimpleArcFactory(shadowArc.placeToTransition ? -1 : 1), parsedDeclarationNode);
                return;
            }
            case 3: {
                if (!this.allowDangerousArcs) break;
                this.compileArcInscriptions(shadowArc, new SimpleArcFactory(5), parsedDeclarationNode);
                return;
            }
            case 4: {
                if (shadowArc.placeToTransition) {
                    this.compileArcInscriptions(shadowArc, FlexibleInArcFactory.INSTANCE, parsedDeclarationNode);
                    return;
                }
                this.compileArcInscriptions(shadowArc, FlexibleOutArcFactory.INSTANCE, parsedDeclarationNode);
                return;
            }
            case 5: {
                if (!this.allowDangerousArcs) break;
                this.compileClearArc(shadowArc, parsedDeclarationNode);
                return;
            }
        }
        throw new SyntaxException("Unsupported arc type.", null).addObject(shadowArc);
    }

    ParsedDeclarationNode parseDeclarationNode(String string) throws SyntaxException {
        if (string != null) {
            InscriptionParser inscriptionParser = this.makeParser(string);
            try {
                return inscriptionParser.DeclarationNode();
            }
            catch (ParseException parseException) {
                throw JavaNetCompiler.makeSyntaxException(parseException);
            }
        }
        return new ParsedDeclarationNode();
    }

    CollectionEnumeration parsePlaceInscription(String string, ParsedDeclarationNode parsedDeclarationNode) throws SyntaxException {
        if (string != null && !string.equals("")) {
            InscriptionParser inscriptionParser = this.makeParser(string);
            inscriptionParser.setDeclarationNode(parsedDeclarationNode);
            try {
                return inscriptionParser.PlaceInscription();
            }
            catch (ParseException parseException) {
                throw JavaNetCompiler.makeSyntaxException(parseException);
            }
        }
        return new EmptyEnumeration();
    }

    protected CollectionEnumeration parseArcInscription(String string, ParsedDeclarationNode parsedDeclarationNode) throws SyntaxException {
        if (string != null && !string.equals("")) {
            InscriptionParser inscriptionParser = this.makeParser(string);
            inscriptionParser.setDeclarationNode(parsedDeclarationNode);
            try {
                return inscriptionParser.ArcInscription();
            }
            catch (ParseException parseException) {
                throw JavaNetCompiler.makeSyntaxException(parseException);
            }
        }
        return new SingletonEnumeration(new TypedExpression(class$de$renew$unify$Tuple != null ? class$de$renew$unify$Tuple : (class$de$renew$unify$Tuple = JavaNetCompiler.class$("de.renew.unify.Tuple")), new ConstantExpression(class$de$renew$unify$Tuple != null ? class$de$renew$unify$Tuple : (class$de$renew$unify$Tuple = JavaNetCompiler.class$("de.renew.unify.Tuple")), new Tuple(0))));
    }

    private CollectionEnumeration makeInscriptions(String string, ShadowLookup shadowLookup, boolean bl, ParsedDeclarationNode parsedDeclarationNode) throws SyntaxException {
        InscriptionParser inscriptionParser = this.makeParser(string);
        inscriptionParser.setLookup(shadowLookup);
        inscriptionParser.setDeclarationNode(parsedDeclarationNode);
        try {
            return inscriptionParser.TransitionInscription(bl);
        }
        catch (ParseException parseException) {
            throw JavaNetCompiler.makeSyntaxException(parseException);
        }
    }

    ParsedDeclarationNode makeDeclarationNode(ShadowNet shadowNet) throws SyntaxException {
        Object object;
        CollectionEnumeration collectionEnumeration = shadowNet.elements();
        ShadowDeclarationNode shadowDeclarationNode = null;
        while (collectionEnumeration.hasMoreElements()) {
            object = collectionEnumeration.nextElement();
            if (!(object instanceof ShadowDeclarationNode)) continue;
            if (shadowDeclarationNode != null) {
                SyntaxException syntaxException = new SyntaxException("Only one declaration node is allowed.", null);
                syntaxException.addObject(shadowDeclarationNode);
                syntaxException.addObject((ShadowDeclarationNode)object);
                while (collectionEnumeration.hasMoreElements()) {
                    object = collectionEnumeration.nextElement();
                    if (!(object instanceof ShadowDeclarationNode)) continue;
                    syntaxException.addObject((ShadowDeclarationNode)object);
                }
                throw syntaxException;
            }
            shadowDeclarationNode = (ShadowDeclarationNode)object;
        }
        object = shadowDeclarationNode == null ? new ParsedDeclarationNode() : this.compile(shadowDeclarationNode);
        return object;
    }

    void compile(ShadowNet shadowNet) throws SyntaxException {
        Object e;
        Net net = this.lookup.getNet(shadowNet.getName());
        ParsedDeclarationNode parsedDeclarationNode = this.makeDeclarationNode(shadowNet);
        CollectionEnumeration collectionEnumeration = shadowNet.elements();
        while (collectionEnumeration.hasMoreElements()) {
            e = collectionEnumeration.nextElement();
            if (!(e instanceof ShadowPlace)) continue;
            this.compile((ShadowPlace)e, parsedDeclarationNode, net);
        }
        collectionEnumeration = shadowNet.elements();
        while (collectionEnumeration.hasMoreElements()) {
            e = collectionEnumeration.nextElement();
            if (!(e instanceof ShadowTransition)) continue;
            this.compile((ShadowTransition)e, parsedDeclarationNode, net);
        }
    }

    void createNets() throws SyntaxException {
        CollectionEnumeration collectionEnumeration = this.netSystem.elements();
        while (collectionEnumeration.hasMoreElements()) {
            ShadowNet shadowNet = (ShadowNet)collectionEnumeration.nextElement();
            if (this.lookup.getNet(shadowNet.getName()) != null) {
                throw new SyntaxException("Detected two nets with the same name: " + shadowNet.getName() + ".", null);
            }
            Net net = new Net(shadowNet.getName());
            net.setEarlyTokens(this.wantEarlyTokens);
            this.lookup.setNet(shadowNet.getName(), net);
        }
    }

    protected void createNetElements() throws SyntaxException {
        CollectionEnumeration collectionEnumeration = this.netSystem.elements();
        while (collectionEnumeration.hasMoreElements()) {
            this.compile((ShadowNet)collectionEnumeration.nextElement());
        }
    }

    protected ShadowLookup getLookup() {
        return this.lookup;
    }

    protected ShadowNetSystem getNetSystem() {
        return this.netSystem;
    }

    public synchronized ShadowLookup compile(ShadowNetSystem shadowNetSystem) throws SyntaxException {
        return this.compile(new ShadowLookup(), shadowNetSystem);
    }

    protected synchronized ShadowLookup compile(ShadowLookup shadowLookup, ShadowNetSystem shadowNetSystem) throws SyntaxException {
        this.lookup = shadowLookup;
        this.placeTypes = new Hashtable();
        this.netSystem = shadowNetSystem;
        this.placeNum = 0;
        this.transitionNum = 0;
        this.createNets();
        this.createNetElements();
        this.lookup = null;
        this.placeTypes = null;
        this.netSystem = null;
        return shadowLookup;
    }

    protected void channelCheck(ShadowNetSystem shadowNetSystem) throws SyntaxException {
        Object object;
        Object object2;
        new HashedSet();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        CollectionEnumeration collectionEnumeration = shadowNetSystem.elements();
        while (collectionEnumeration.hasMoreElements()) {
            object2 = (ShadowNet)collectionEnumeration.nextElement();
            object = this.makeDeclarationNode((ShadowNet)object2);
            CollectionEnumeration collectionEnumeration2 = ((ShadowNet)object2).elements();
            while (collectionEnumeration2.hasMoreElements()) {
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object e = collectionEnumeration2.nextElement();
                if (!(e instanceof ShadowTransition)) continue;
                ShadowTransition shadowTransition = (ShadowTransition)e;
                ChannelInscription channelInscription = null;
                HashedSet hashedSet = new HashedSet();
                CollectionEnumeration collectionEnumeration3 = shadowTransition.elements();
                while (collectionEnumeration3.hasMoreElements()) {
                    object6 = collectionEnumeration3.nextElement();
                    if (!(object6 instanceof ShadowInscription)) continue;
                    object5 = ((ShadowInscription)object6).inscr;
                    try {
                        object4 = this.makeParser((String)object5);
                        object4.setDeclarationNode((ParsedDeclarationNode)object);
                        object3 = object4.tryParseChannelInscription();
                        if (((ChannelInscription)object3).isUplink) {
                            if (channelInscription != null) {
                                throw new SyntaxException("Transition has more than one uplink.", null).addObject(shadowTransition);
                            }
                            channelInscription = object3;
                            continue;
                        }
                        hashedSet.include(object3);
                    }
                    catch (ParseException parseException) {}
                }
                object6 = (ChannelCheckNode)hashtable.get(channelInscription = channelInscription == null ? new ChannelInscription(false, "", 0) : new ChannelInscription(false, channelInscription.name, channelInscription.arity));
                if (object6 == null) {
                    object6 = new ChannelCheckNode(channelInscription.name, channelInscription.arity);
                    hashtable.put(channelInscription, object6);
                }
                if ((object5 = hashedSet.elements()).hasMoreElements()) {
                    do {
                        if ((object3 = (ChannelCheckNode)hashtable.get(object4 = (ChannelInscription)object5.nextElement())) == null) {
                            object3 = new ChannelCheckNode(((ChannelInscription)object4).name, ((ChannelInscription)object4).arity);
                            hashtable.put(object4, object3);
                        }
                        ((ChannelCheckNode)object6).addInvokableChannel((ChannelCheckNode)object3);
                    } while (object5.hasMoreElements());
                    continue;
                }
                ((ChannelCheckNode)object6).setSatisfiable();
            }
        }
        object2 = hashtable.elements();
        while (object2.hasMoreElements()) {
            object = (ChannelCheckNode)object2.nextElement();
            ((ChannelCheckNode)object).check();
        }
    }

    protected void doubleNameCheck(ShadowNetSystem shadowNetSystem) throws SyntaxException {
        CollectionEnumeration collectionEnumeration = shadowNetSystem.elements();
        while (collectionEnumeration.hasMoreElements()) {
            ShadowNet shadowNet = (ShadowNet)collectionEnumeration.nextElement();
            Hashtable<String, ShadowNode> hashtable = new Hashtable<String, ShadowNode>();
            CollectionEnumeration collectionEnumeration2 = shadowNet.elements();
            while (collectionEnumeration2.hasMoreElements()) {
                ShadowNode shadowNode;
                String string;
                Object e = collectionEnumeration2.nextElement();
                if (!(e instanceof ShadowNode) || (string = (shadowNode = (ShadowNode)e).getName()) == null || string.equals("")) continue;
                if (hashtable.containsKey(string)) {
                    throw new SyntaxException("Detected two net elements with the same name: " + string + ".", null).addObject(shadowNode).addObject((ShadowNode)hashtable.get(string));
                }
                hashtable.put(string, shadowNode);
            }
        }
    }

    public String[] getLintNames() {
        return lintNames;
    }

    public void lint(int n, ShadowNetSystem shadowNetSystem, ShadowNet shadowNet, ShadowNet shadowNet2) throws SyntaxException {
        switch (n) {
            case 0: {
                this.channelCheck(shadowNetSystem);
                return;
            }
            case 1: {
                this.doubleNameCheck(shadowNetSystem);
                return;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

